/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.TaggedValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.AnnotationVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LocalVariableNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.MethodNode;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArray;
import java.util.ArrayList;
import java.util.HashMap;

public class MethodArgReindexer
extends MethodVisitor {
    int originalLastArgIdx;
    int[] oldArgMappings;
    int[] origArgMappings;
    int newArgOffset;
    boolean isStatic;
    int origNumArgs;
    String name;
    String desc;
    boolean hasTaintSentinalAddedToDesc = false;
    ArrayList<Type> oldArgTypesList;
    Type[] oldArgTypes;
    MethodNode lvStore;
    int nNewArgs = 0;
    Type[] firstFrameLocals;
    int idxOfReturnPrealloc;
    boolean hasPreAllocedReturnAddr;
    Type newReturnType;
    ArrayList<Type> oldTypesDoublesAreOne;
    boolean isLambda;
    int nLongDoubleArgs = 0;
    int nLVTaintsCounted = 0;
    boolean returnLVVisited = false;
    HashMap<String, Integer> parameters = new HashMap();
    int line;
    int indexOfControlTagsInLocals;
    boolean debug = false;

    public MethodArgReindexer(MethodVisitor mv, int access, String name, String desc, String originalDesc, MethodNode lvStore, boolean isLambda) {
        super(Configuration.ASM_VERSION, mv);
        this.lvStore = lvStore;
        this.isLambda = isLambda;
        lvStore.localVariables = new ArrayList<LocalVariableNode>();
        this.name = name;
        this.desc = desc;
        this.oldArgTypes = Type.getArgumentTypes(originalDesc);
        this.origNumArgs = this.oldArgTypes.length;
        this.isStatic = (8 & access) != 0;
        for (Type t : this.oldArgTypes) {
            this.originalLastArgIdx += t.getSize();
        }
        if (!this.isStatic) {
            ++this.originalLastArgIdx;
        }
        if (!this.isStatic) {
            ++this.origNumArgs;
        }
        this.newArgOffset = 0;
        this.oldArgTypesList = new ArrayList();
        this.oldTypesDoublesAreOne = new ArrayList();
        if (!this.isStatic) {
            this.oldArgTypesList.add(Type.getType("Lthis;"));
            this.oldTypesDoublesAreOne.add(Type.getType("Lthis;"));
        }
        this.firstFrameLocals = new Type[this.origNumArgs];
        int ffl = 0;
        if (!this.isStatic) {
            this.firstFrameLocals[0] = Type.getObjectType("java/lang/Object");
            ++ffl;
        }
        for (Type t : Type.getArgumentTypes(originalDesc)) {
            this.oldArgTypesList.add(t);
            this.oldTypesDoublesAreOne.add(t);
            this.firstFrameLocals[ffl] = t;
            ++ffl;
            if (t.getSize() != 2) continue;
            this.oldArgTypesList.add(Type.getType("LTOP;"));
            ++this.nLongDoubleArgs;
        }
        boolean hasBeenRemapped = false;
        this.oldArgMappings = new int[this.originalLastArgIdx + 1];
        int oldVarCount = this.isStatic ? 0 : 1;
        for (int i = 0; i < this.oldArgTypes.length; ++i) {
            if (!isLambda) {
                if (this.oldArgTypes[i].getSort() == 9) {
                    if (this.oldArgTypes[i].getElementType().getSort() != 10) {
                        if (this.oldArgTypes[i].getDimensions() == 1) {
                            ++this.newArgOffset;
                            ++this.nNewArgs;
                        }
                        hasBeenRemapped = true;
                    }
                } else if (this.oldArgTypes[i].getSort() != 10) {
                    hasBeenRemapped = true;
                    ++this.newArgOffset;
                    ++this.nNewArgs;
                }
            }
            this.oldArgMappings[oldVarCount] = oldVarCount + this.newArgOffset;
            if (this.oldArgTypes[i].getSize() == 2) {
                this.oldArgMappings[oldVarCount + 1] = oldVarCount + this.newArgOffset + 1;
                ++oldVarCount;
            }
            ++oldVarCount;
        }
        if ((Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING) && !name.equals("<clinit>")) {
            hasBeenRemapped = true;
            this.indexOfControlTagsInLocals = this.oldArgTypes.length + this.newArgOffset + (this.isStatic ? 0 : 1);
            ++this.newArgOffset;
        }
        if (name.equals("<init>") && hasBeenRemapped) {
            this.hasTaintSentinalAddedToDesc = true;
            ++this.newArgOffset;
            ++this.nNewArgs;
        }
        this.hasPreAllocedReturnAddr = TaintUtils.isPreAllocReturnType(originalDesc);
        if (this.hasPreAllocedReturnAddr) {
            this.newReturnType = Type.getReturnType(desc);
            ++this.newArgOffset;
            ++this.nNewArgs;
            this.idxOfReturnPrealloc = this.originalLastArgIdx + this.newArgOffset - 1;
        }
        this.origArgMappings = new int[this.oldArgMappings.length];
        System.arraycopy(this.oldArgMappings, 0, this.origArgMappings, 0, this.oldArgMappings.length);
    }

    public int getNewArgOffset() {
        return this.newArgOffset;
    }

    @Override
    public void visitParameter(String name, int access) {
        super.visitParameter(name, access);
        this.parameters.put(name, access);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.parameters.size() > 0) {
            for (int i = 0; i < this.nNewArgs; ++i) {
                super.visitParameter("Phosphor$$Param$$" + i, 0);
            }
        }
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index < this.originalLastArgIdx) {
            boolean found = false;
            for (LocalVariableNode _lv : this.lvStore.localVariables) {
                LocalVariableNode lv = _lv;
                if (lv == null || lv.name == null || !lv.name.equals(name) || lv.index != index) continue;
                found = true;
            }
            if (!found) {
                this.lvStore.localVariables.add(new LocalVariableNode(name, desc, signature, null, null, index));
            }
        }
        if (!this.isStatic && index == 0) {
            super.visitLocalVariable(name, desc, signature, start, end, index);
        } else if (index < this.originalLastArgIdx) {
            String shadow = TaintUtils.getShadowTaintType(desc);
            if (shadow != null) {
                super.visitLocalVariable(name + "$$PHOSPHORTAGGED", shadow, null, start, end, this.origArgMappings[index] - 1);
            }
            super.visitLocalVariable(name, desc, signature, start, end, this.origArgMappings[index]);
            if (index == this.originalLastArgIdx - 1 && (Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING)) {
                super.visitLocalVariable("Phopshor$$ImplicitTaintTrackingFromParent", Type.getDescriptor(ControlTaintTagStack.class), null, start, end, this.origArgMappings[index] + 1);
            }
            if (index == this.originalLastArgIdx - 1 && this.name.equals("<init>") && this.hasTaintSentinalAddedToDesc) {
                super.visitLocalVariable("Phosphor$$TaintSentinel", "Ljava/lang/Object;", null, start, end, this.origArgMappings[index] + (Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING ? 2 : 1));
            }
            if (index == this.originalLastArgIdx - Type.getType(desc).getSize() && this.hasPreAllocedReturnAddr) {
                super.visitLocalVariable("Phosphor$$ReturnPreAllocated", this.newReturnType.getDescriptor(), null, start, end, this.origArgMappings[index] + (Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING ? 2 : 1));
            }
        } else {
            super.visitLocalVariable(name, desc, signature, start, end, index + this.newArgOffset);
        }
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.debug = line == 182;
    }

    @Override
    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(value);
    }

    public static Type getTypeForStackTypeTOPAsNull(Object obj) {
        if (obj instanceof TaggedValue) {
            obj = ((TaggedValue)obj).v;
        }
        if (obj == Opcodes.INTEGER) {
            return Type.INT_TYPE;
        }
        if (obj == Opcodes.FLOAT) {
            return Type.FLOAT_TYPE;
        }
        if (obj == Opcodes.DOUBLE) {
            return Type.DOUBLE_TYPE;
        }
        if (obj == Opcodes.LONG) {
            return Type.LONG_TYPE;
        }
        if (obj == Opcodes.NULL) {
            return Type.getType("Ljava/lang/Object;");
        }
        if (obj == Opcodes.TOP) {
            return Type.getType("Ljava/lang/Object;");
        }
        if (obj instanceof String) {
            if (((String)obj).charAt(0) != '[' && ((String)obj).length() > 1) {
                return Type.getType("L" + obj + ";");
            }
            return Type.getType((String)obj);
        }
        if (obj instanceof Label || obj == Opcodes.UNINITIALIZED_THIS) {
            return Type.getType("Luninitialized;");
        }
        throw new IllegalArgumentException("got " + obj + " zzz" + obj.getClass());
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        Object[] remappedLocals = new Object[Math.max(local.length, this.origNumArgs) + this.newArgOffset + 1 + this.nLongDoubleArgs];
        int nLocalsInputFrame = nLocal;
        this.oldArgMappings = new int[this.originalLastArgIdx + 1];
        if (type == 0 || type == -1) {
            int i;
            int thisLocalVarNumberInNewFrame = 0;
            int thisLocalVarNumberInOldFrame = 0;
            int thisLocalIndexInNewFrame = 0;
            int thisLocalIndexInOldFrame = 0;
            if (this.origNumArgs == 0) {
                if ((Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING) && !this.name.equals("<clinit>")) {
                    remappedLocals[thisLocalIndexInNewFrame] = Type.getInternalName(ControlTaintTagStack.class);
                    ++thisLocalIndexInNewFrame;
                    ++nLocal;
                }
                if (this.hasPreAllocedReturnAddr) {
                    remappedLocals[thisLocalIndexInNewFrame] = this.newReturnType.getInternalName();
                    ++thisLocalIndexInNewFrame;
                    ++nLocal;
                }
            }
            for (i = 0; i < this.oldArgTypesList.size() && local.length > 0; ++i) {
                Object thisLocalTypeObjNew = null;
                thisLocalTypeObjNew = thisLocalIndexInOldFrame < local.length ? local[thisLocalIndexInOldFrame] : Opcodes.TOP;
                Type thisLocalTypeOld = this.oldArgTypesList.get(i);
                Type thisLocalTypeNew = MethodArgReindexer.getTypeForStackTypeTOPAsNull(thisLocalTypeObjNew);
                if (thisLocalTypeOld.getDescriptor().equals("LTOP;") && thisLocalIndexInOldFrame > 0 && thisLocalIndexInOldFrame - 1 < local.length && MethodArgReindexer.getTypeForStackTypeTOPAsNull(local[thisLocalIndexInOldFrame - 1]).getSize() == 2) continue;
                if (TaintUtils.isPrimitiveOrPrimitiveArrayType(thisLocalTypeOld)) {
                    if (TaintUtils.isPrimitiveOrPrimitiveArrayType(thisLocalTypeNew)) {
                        remappedLocals[thisLocalIndexInNewFrame] = TaintUtils.getShadowTaintTypeForFrame(thisLocalTypeNew);
                        ++thisLocalIndexInNewFrame;
                        ++thisLocalVarNumberInNewFrame;
                        ++nLocal;
                    } else {
                        remappedLocals[thisLocalIndexInNewFrame] = Opcodes.TOP;
                        ++thisLocalIndexInNewFrame;
                        ++thisLocalVarNumberInNewFrame;
                        ++nLocal;
                    }
                } else if (TaintUtils.isPrimitiveOrPrimitiveArrayType(thisLocalTypeNew)) {
                    thisLocalTypeObjNew = new TaggedValue(thisLocalTypeObjNew);
                }
                if (thisLocalIndexInNewFrame < remappedLocals.length) {
                    remappedLocals[thisLocalIndexInNewFrame] = thisLocalTypeObjNew;
                }
                if (thisLocalTypeNew.getSort() == 9 && thisLocalTypeNew.getDimensions() > 1 && thisLocalTypeNew.getElementType().getSort() != 10 && thisLocalIndexInNewFrame < remappedLocals.length) {
                    remappedLocals[thisLocalIndexInNewFrame] = MultiDTaintedArray.getTypeForType(Type.getObjectType((String)local[thisLocalIndexInOldFrame])).getInternalName();
                }
                this.oldArgMappings[thisLocalVarNumberInOldFrame] = thisLocalVarNumberInNewFrame;
                if (thisLocalTypeNew.getSize() == 2) {
                    this.oldArgMappings[thisLocalVarNumberInOldFrame + 1] = thisLocalVarNumberInNewFrame + 1;
                }
                ++thisLocalIndexInNewFrame;
                ++thisLocalIndexInOldFrame;
                thisLocalVarNumberInNewFrame += thisLocalTypeNew.getSize();
                thisLocalVarNumberInOldFrame += thisLocalTypeNew.getSize();
            }
            if (this.origNumArgs != 0 && (Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING)) {
                while (thisLocalIndexInNewFrame < this.indexOfControlTagsInLocals) {
                    remappedLocals[thisLocalIndexInNewFrame] = Opcodes.TOP;
                    ++thisLocalIndexInNewFrame;
                    ++nLocal;
                }
                remappedLocals[thisLocalIndexInNewFrame] = Type.getInternalName(ControlTaintTagStack.class);
                ++thisLocalIndexInNewFrame;
                ++thisLocalVarNumberInNewFrame;
                ++nLocal;
            }
            if (this.origNumArgs != 0 && this.hasPreAllocedReturnAddr) {
                remappedLocals[thisLocalIndexInNewFrame] = this.newReturnType.getInternalName();
                ++thisLocalIndexInNewFrame;
                ++thisLocalVarNumberInNewFrame;
                ++nLocal;
            }
            if (this.hasTaintSentinalAddedToDesc) {
                remappedLocals[thisLocalIndexInNewFrame] = Opcodes.TOP;
                ++thisLocalIndexInNewFrame;
                ++thisLocalVarNumberInNewFrame;
                ++nLocal;
            }
            for (i = thisLocalIndexInOldFrame; i < nLocalsInputFrame; ++i) {
                remappedLocals[thisLocalIndexInNewFrame] = local[i];
                Type t = MethodArgReindexer.getTypeForStackTypeTOPAsNull(local[i]);
                if (t.getSort() == 9 && t.getDimensions() > 1 && t.getElementType().getSort() != 10) {
                    remappedLocals[thisLocalIndexInNewFrame] = MultiDTaintedArray.getTypeForType(Type.getObjectType((String)local[i])).getInternalName();
                }
                ++thisLocalIndexInNewFrame;
                thisLocalVarNumberInNewFrame += t.getSize();
                thisLocalVarNumberInOldFrame += t.getSize();
            }
        } else {
            remappedLocals = local;
        }
        if (nLocal > remappedLocals.length) {
            throw new IllegalStateException();
        }
        ArrayList<Object> newStack = new ArrayList<Object>();
        int origNStack = nStack;
        for (int i = 0; i < origNStack; ++i) {
            if (stack[i] instanceof TaggedValue) {
                Object o = ((TaggedValue)stack[i]).v;
                if (o instanceof String || o == Opcodes.NULL) {
                    if (o == Opcodes.NULL) {
                        newStack.add(Opcodes.NULL);
                    } else {
                        newStack.add(TaintUtils.getShadowTaintTypeForFrame((String)o));
                    }
                    ++nStack;
                } else {
                    newStack.add(Configuration.TAINT_TAG_STACK_TYPE);
                    ++nStack;
                }
                newStack.add(stack[i]);
                continue;
            }
            if (stack[i] != Opcodes.TOP && stack[i] instanceof String && ((String)stack[i]).charAt(1) == '[' && Type.getObjectType((String)stack[i]).getElementType().getSort() != 10) {
                newStack.add(MultiDTaintedArray.getTypeForType(Type.getObjectType((String)stack[i])).getInternalName());
                continue;
            }
            newStack.add(stack[i]);
        }
        Object[] stack2 = new Object[newStack.size()];
        stack2 = newStack.toArray();
        super.visitFrame(type, nLocal, remappedLocals, nStack, stack2);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        if (!this.isStatic) {
            ++parameter;
        }
        int remappedVar = parameter;
        remappedVar = parameter < this.originalLastArgIdx ? this.oldArgMappings[parameter] : (remappedVar += this.newArgOffset);
        if (!this.isStatic) {
            --remappedVar;
        }
        return super.visitParameterAnnotation(remappedVar, descriptor, visible);
    }

    @Override
    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        if (!this.isStatic) {
            ++parameterCount;
        }
        int remappedVar = parameterCount;
        remappedVar = parameterCount < this.originalLastArgIdx ? this.oldArgMappings[parameterCount] : (remappedVar += this.newArgOffset);
        if (!this.isStatic) {
            --remappedVar;
        }
        super.visitAnnotableParameterCount(remappedVar, visible);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        int origVar = var;
        var = !this.isStatic && var == 0 ? 0 : (var < this.originalLastArgIdx ? this.oldArgMappings[var] : (var += this.newArgOffset));
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
        super.visitMethodInsn(opcode, owner, name, desc, itfc);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (opcode == 215 || opcode == 214) {
            super.visitVarInsn(opcode, var);
            return;
        }
        int origVar = var;
        var = !this.isStatic && var == 0 ? 0 : (var < this.originalLastArgIdx ? this.oldArgMappings[var] : (var += this.newArgOffset));
        super.visitVarInsn(opcode, var);
    }
}

