/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.PrimitiveArrayAnalyzer;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintAdapter;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.NeverNullArgAnalyzerAdapter;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.TaggedValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.commons.OurLocalVariablesSorter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LabelNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LocalVariableNode;
import edu.columbia.cs.psl.phosphor.runtime.TaintSentinel;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.EnqueuedTaint;
import edu.columbia.cs.psl.phosphor.struct.ExceptionalTaintData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class LocalVariableManager
extends OurLocalVariablesSorter
implements Opcodes {
    private NeverNullArgAnalyzerAdapter analyzer;
    private static final boolean DEBUG = false;
    int createdLVIdx = 0;
    HashSet<LocalVariableNode> createdLVs = new HashSet();
    HashMap<Integer, LocalVariableNode> curLocalIdxToLVNode = new HashMap();
    MethodVisitor uninstMV;
    Type returnType;
    int lastArg;
    ArrayList<Type> oldArgTypes = new ArrayList();
    boolean isIgnoreEverything = false;
    private boolean isInMethodThatsTooBig;
    public HashMap<Integer, Integer> varToShadowVar = new HashMap();
    private boolean generateExtraDebug;
    private Type[] args;
    private boolean isStatic;
    private int extraLVsInArg;
    HashMap<Integer, Integer> origLVMap = new HashMap();
    HashMap<Integer, Integer> shadowLVMap = new HashMap();
    HashMap<Integer, Object> shadowLVMapType = new HashMap();
    int jumpIdx;
    int idxOfMasterControlLV = -1;
    int idxOfMasterExceptionLV = -1;
    private Label ctrlTagStartLbl;
    HashSet<Integer> tmpLVIdices = new HashSet();
    ArrayList<TmpLV> tmpLVs = new ArrayList();
    boolean endVisited = false;
    Label end;
    Label start = new Label();
    HashMap<Type, Integer> preAllocedReturnTypes = new HashMap();
    PrimitiveArrayAnalyzer primitiveArrayFixer;
    public HashMap<Integer, Integer> varsToRemove = new HashMap();
    private boolean disabled = false;

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 203) {
            this.isIgnoreEverything = !this.isIgnoreEverything;
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        if (this.isIgnoreEverything) {
            this.isInMethodThatsTooBig = true;
            this.mv.visitIincInsn(var, increment);
        } else {
            super.visitIincInsn(var, increment);
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (opcode == 215 || opcode == 214 || this.isIgnoreEverything) {
            this.mv.visitVarInsn(opcode, var);
            return;
        }
        if (opcode == 203) {
            this.isInMethodThatsTooBig = true;
        } else {
            super.visitVarInsn(opcode, var);
        }
    }

    public LocalVariableManager(int access, String desc, MethodVisitor mv, NeverNullArgAnalyzerAdapter analyzer, MethodVisitor uninstMV, boolean generateExtraDebug) {
        super(Configuration.ASM_VERSION, access, desc, mv);
        this.analyzer = analyzer;
        this.uninstMV = uninstMV;
        this.returnType = Type.getReturnType(desc);
        this.args = Type.getArgumentTypes(desc);
        if ((access & 8) == 0) {
            ++this.lastArg;
            this.oldArgTypes.add(Type.getType("Lthis;"));
        } else {
            this.isStatic = true;
        }
        for (int i = 0; i < this.args.length; ++i) {
            this.lastArg += this.args[i].getSize();
            this.oldArgTypes.add(this.args[i]);
            if (this.args[i].getSize() > 1) {
                this.oldArgTypes.add(Type.getType("Ltop;"));
            }
            if (this.args[i].getDescriptor().equals(Type.getDescriptor(ControlTaintTagStack.class))) {
                ++this.extraLVsInArg;
                this.idxOfMasterControlLV = this.lastArg - 1;
            }
            if (this.args[i].getDescriptor().equals(Configuration.TAINT_TAG_DESC)) {
                ++this.extraLVsInArg;
            }
            if (!this.args[i].getDescriptor().equals(Type.getType(TaintSentinel.class))) continue;
            ++this.extraLVsInArg;
        }
        --this.lastArg;
        if (this.returnType.getDescriptor().startsWith("Ledu/columbia/cs/psl/phosphor/struct/Tainted")) {
            this.preAllocedReturnTypes.put(this.returnType, this.lastArg);
        }
        this.end = new Label();
        this.generateExtraDebug = generateExtraDebug;
    }

    public void freeTmpLV(int idx) {
        for (TmpLV v : this.tmpLVs) {
            if (v.idx != idx || !v.inUse) continue;
            Label lbl = new Label();
            super.visitLabel(lbl);
            this.curLocalIdxToLVNode.get((Object)Integer.valueOf((int)v.idx)).end = new LabelNode(lbl);
            v.inUse = false;
            v.owner = null;
            if (idx < this.analyzer.locals.size()) {
                this.analyzer.locals.set(idx, Opcodes.TOP);
            }
            return;
        }
        throw new IllegalArgumentException("asked to free tmp lv " + idx + " but couldn't find it?");
    }

    @Override
    @Deprecated
    public int newLocal(Type type) {
        throw new UnsupportedOperationException();
    }

    public int newShadowLV(Type type, int shadows) {
        int idx = super.newLocal(type);
        Label lbl = new Label();
        super.visitLabel(lbl);
        String shadowName = null;
        if (this.primitiveArrayFixer != null) {
            Iterator<LocalVariableNode> iterator = this.primitiveArrayFixer.mn.localVariables.iterator();
            while (iterator.hasNext()) {
                LocalVariableNode o;
                LocalVariableNode lv = o = iterator.next();
                int id = this.remap(lv.index + (lv.index < this.lastArg - this.extraLVsInArg ? 0 : this.extraLVsInArg), Type.getType(lv.desc));
                if (id != shadows) continue;
                shadowName = lv.name + "$$PHOSPHORTAG";
            }
        }
        if (shadowName == null) {
            shadowName = "phosphorShadowLVFor" + shadows + "XX" + this.createdLVIdx;
        }
        LocalVariableNode newLVN = new LocalVariableNode(shadowName, type.getDescriptor(), null, new LabelNode(lbl), new LabelNode(this.end), idx);
        this.createdLVs.add(newLVN);
        this.curLocalIdxToLVNode.put(idx, newLVN);
        ++this.createdLVIdx;
        this.shadowLVMap.put(idx, this.origLVMap.get(shadows));
        this.varToShadowVar.put(shadows, idx);
        return idx;
    }

    public int getIdxOfMasterExceptionLV() {
        return this.idxOfMasterExceptionLV;
    }

    public int createExceptionTaintLV() {
        int idx = super.newLocal(Type.getType(ExceptionalTaintData.class));
        if (this.ctrlTagStartLbl == null) {
            this.ctrlTagStartLbl = new Label();
            super.visitLabel(this.ctrlTagStartLbl);
        }
        LocalVariableNode newLVN = new LocalVariableNode("phosphorExceptionTaintData", Type.getDescriptor(ExceptionalTaintData.class), null, new LabelNode(this.ctrlTagStartLbl), new LabelNode(this.end), idx);
        this.createdLVs.add(newLVN);
        this.analyzer.locals.add(idx, Type.getInternalName(ExceptionalTaintData.class));
        this.idxOfMasterExceptionLV = idx;
        return idx;
    }

    public int getIdxOfMasterControlLV() {
        return this.idxOfMasterControlLV;
    }

    public int createMasterControlTaintLV() {
        int idx = super.newLocal(Type.getType(ControlTaintTagStack.class));
        if (this.ctrlTagStartLbl == null) {
            this.ctrlTagStartLbl = new Label();
            super.visitLabel(this.ctrlTagStartLbl);
        }
        LocalVariableNode newLVN = new LocalVariableNode("phosphorJumpControlTag" + this.jumpIdx, Type.getDescriptor(ControlTaintTagStack.class), null, new LabelNode(this.ctrlTagStartLbl), new LabelNode(this.end), idx);
        this.createdLVs.add(newLVN);
        this.analyzer.locals.add(idx, Type.getInternalName(ControlTaintTagStack.class));
        this.idxOfMasterControlLV = idx;
        ++this.jumpIdx;
        return idx;
    }

    public int newControlTaintLV() {
        int idx = super.newLocal(Type.getType("[I"));
        if (this.ctrlTagStartLbl == null) {
            this.ctrlTagStartLbl = new Label();
            super.visitLabel(this.ctrlTagStartLbl);
        }
        LocalVariableNode newLVN = new LocalVariableNode("phosphorJumpControlTag", "[I", null, new LabelNode(this.ctrlTagStartLbl), new LabelNode(this.end), idx);
        this.createdLVs.add(newLVN);
        this.analyzer.locals.add(idx, "[I");
        ++this.jumpIdx;
        return idx;
    }

    public int newControlExceptionTaintLV() {
        Type t = Type.getType(EnqueuedTaint.class);
        int idx = super.newLocal(t);
        if (this.ctrlTagStartLbl == null) {
            this.ctrlTagStartLbl = new Label();
            super.visitLabel(this.ctrlTagStartLbl);
        }
        LocalVariableNode newLVN = new LocalVariableNode("phosphorExceptionData", t.getDescriptor(), null, new LabelNode(this.ctrlTagStartLbl), new LabelNode(this.end), idx);
        this.createdLVs.add(newLVN);
        this.analyzer.locals.add(idx, t.getInternalName());
        return idx;
    }

    @Override
    protected int remap(int var, Type type) {
        int ret = super.remap(var, type);
        this.origLVMap.put(ret, var);
        Object objType = "[I";
        switch (type.getSort()) {
            case 1: 
            case 4: 
            case 5: {
                objType = Opcodes.INTEGER;
                break;
            }
            case 7: {
                objType = Opcodes.LONG;
                break;
            }
            case 8: {
                objType = Opcodes.DOUBLE;
                break;
            }
            case 6: {
                objType = Opcodes.FLOAT;
            }
        }
        this.shadowLVMapType.put(ret, objType);
        return ret;
    }

    private int newPreAllocedReturnType(Type type) {
        int idx = super.newLocal(type);
        Label lbl = new Label();
        super.visitLabel(lbl);
        LocalVariableNode newLVN = new LocalVariableNode("phosphorReturnPreAlloc" + this.createdLVIdx, type.getDescriptor(), null, new LabelNode(lbl), new LabelNode(this.end), idx);
        this.createdLVs.add(newLVN);
        this.curLocalIdxToLVNode.put(idx, newLVN);
        ++this.createdLVIdx;
        this.analyzer.locals.add(idx, type.getInternalName());
        return idx;
    }

    public int getTmpLV() {
        Object obj = this.analyzer.stack.get(this.analyzer.stack.size() - 1);
        if (obj instanceof String) {
            return this.getTmpLV(Type.getObjectType((String)obj));
        }
        if (obj == Opcodes.INTEGER) {
            return this.getTmpLV(Type.INT_TYPE);
        }
        if (obj == Opcodes.FLOAT) {
            return this.getTmpLV(Type.FLOAT_TYPE);
        }
        if (obj == Opcodes.DOUBLE) {
            return this.getTmpLV(Type.DOUBLE_TYPE);
        }
        if (obj == Opcodes.LONG) {
            return this.getTmpLV(Type.LONG_TYPE);
        }
        if (obj == Opcodes.TOP) {
            obj = this.analyzer.stack.get(this.analyzer.stack.size() - 2);
            if (obj == Opcodes.DOUBLE) {
                return this.getTmpLV(Type.DOUBLE_TYPE);
            }
            if (obj == Opcodes.LONG) {
                return this.getTmpLV(Type.LONG_TYPE);
            }
        }
        return this.getTmpLV(Type.getType("Ljava/lang/Object;"));
    }

    public int getTmpLV(Type t) {
        if (t.getDescriptor().equals("java/lang/Object;")) {
            throw new IllegalArgumentException();
        }
        for (TmpLV lv : this.tmpLVs) {
            if (lv.inUse || lv.type.getSize() != t.getSize()) continue;
            if (!lv.type.equals(t)) {
                Label lbl = new Label();
                super.visitLabel(lbl);
                LocalVariableNode newLVN = new LocalVariableNode("phosphorTempStack" + this.createdLVIdx, t.getDescriptor(), null, new LabelNode(lbl), new LabelNode(this.end), lv.idx);
                this.createdLVs.add(newLVN);
                this.curLocalIdxToLVNode.put(lv.idx, newLVN);
                ++this.createdLVIdx;
                this.remapLocal(lv.idx, t);
                if (this.analyzer.locals != null && lv.idx < this.analyzer.locals.size()) {
                    this.analyzer.locals.set(lv.idx, TaintUtils.getStackTypeForType(t));
                }
                lv.type = t;
            }
            lv.inUse = true;
            return lv.idx;
        }
        int idx = super.newLocal(t);
        Label lbl = new Label();
        super.visitLabel(lbl);
        LocalVariableNode newLVN = new LocalVariableNode("phosphorTempStack" + this.createdLVIdx, t.getDescriptor(), null, new LabelNode(lbl), new LabelNode(this.end), idx);
        this.createdLVs.add(newLVN);
        this.curLocalIdxToLVNode.put(idx, newLVN);
        ++this.createdLVIdx;
        TmpLV newLV = new TmpLV();
        newLV.idx = idx;
        newLV.type = t;
        newLV.inUse = true;
        this.tmpLVs.add(newLV);
        this.tmpLVIdices.add(newLV.idx);
        return newLV.idx;
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index);
        if (!this.createdLVs.isEmpty()) {
            if (!this.endVisited) {
                super.visitLabel(this.end);
                this.endVisited = true;
            }
            if (!Configuration.SKIP_LOCAL_VARIABLE_TABLE) {
                for (LocalVariableNode n : this.createdLVs) {
                    this.uninstMV.visitLocalVariable(n.name, n.desc, n.signature, n.start.getLabel(), n.end.getLabel(), n.index);
                }
            }
            this.createdLVs.clear();
        }
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (!this.endVisited) {
            super.visitLabel(this.end);
            this.endVisited = true;
        }
        if (this.generateExtraDebug && !Configuration.SKIP_LOCAL_VARIABLE_TABLE) {
            int n = 0;
            if (!this.isStatic) {
                super.visitLocalVariable("argidx" + n, "Ljava/lang/Object;", null, this.start, this.end, n);
                ++n;
            }
            for (Type t : this.args) {
                super.visitLocalVariable("argidx" + n, t.getDescriptor(), null, this.start, this.end, n);
                n += t.getSize();
            }
        }
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        for (TmpLV l : this.tmpLVs) {
            if (!l.inUse) continue;
            throw l.owner;
        }
    }

    @Override
    public void visitCode() {
        super.visitCode();
        super.visitLabel(this.start);
        if (this.primitiveArrayFixer != null) {
            for (Type t : this.primitiveArrayFixer.wrapperTypesToPreAlloc) {
                if (t.equals(this.returnType)) {
                    this.preAllocedReturnTypes.put(t, this.lastArg);
                    continue;
                }
                int lv = this.newPreAllocedReturnType(t);
                this.preAllocedReturnTypes.put(t, lv);
                super.visitTypeInsn(187, t.getInternalName());
                super.visitInsn(89);
                super.visitMethodInsn(183, t.getInternalName(), "<init>", "()V", false);
                this.mv.visitVarInsn(58, lv);
            }
        }
    }

    public void setPrimitiveArrayAnalyzer(PrimitiveArrayAnalyzer primitiveArrayFixer) {
        this.primitiveArrayFixer = primitiveArrayFixer;
    }

    public int getPreAllocedReturnTypeVar(Type newReturnType) {
        if (!this.preAllocedReturnTypes.containsKey(newReturnType)) {
            throw new IllegalArgumentException("Got " + newReturnType + " but have " + this.preAllocedReturnTypes);
        }
        return this.preAllocedReturnTypes.get(newReturnType);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        int number;
        if (type == 201) {
            this.mv.visitFrame(-1, nLocal, local, nStack, stack);
            return;
        }
        if (type != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (this.isInMethodThatsTooBig || !this.changed && !this.isFirstFrame) {
            this.mv.visitFrame(type, nLocal, local, nStack, stack);
            return;
        }
        this.isFirstFrame = false;
        Object[] oldLocals = new Object[this.newLocals.length];
        System.arraycopy(this.newLocals, 0, oldLocals, 0, oldLocals.length);
        this.updateNewLocals(this.newLocals);
        for (int i = 0; i < this.newLocals.length; ++i) {
            if (!this.tmpLVIdices.contains(i)) continue;
            this.newLocals[i] = Opcodes.TOP;
        }
        ArrayList<Object> locals = new ArrayList<Object>();
        for (int i = 0; i < nLocal; ++i) {
            Object o = local[i];
            locals.add(o);
            if (o != Opcodes.DOUBLE && o != Opcodes.LONG) continue;
            locals.add(Opcodes.TOP);
        }
        if (!this.disabled) {
            for (Map.Entry<Type, Integer> t : this.preAllocedReturnTypes.entrySet()) {
                int idx;
                if (t.getKey().getSort() != 10 || (idx = t.getValue().intValue()) < 0) continue;
                this.setFrameLocal(idx, t.getKey().getInternalName());
            }
        }
        int index = 0;
        for (number = 0; number < nLocal; ++number) {
            int size;
            Object t = local[number];
            boolean hasTaint = t instanceof TaggedValue;
            if (hasTaint) {
                t = ((TaggedValue)t).v;
            }
            int n = size = t == Opcodes.LONG || t == Opcodes.DOUBLE ? 2 : 1;
            if (t != Opcodes.TOP) {
                int shadowVar;
                Type _t;
                Type typ = OBJECT_TYPE;
                if (t == Opcodes.INTEGER) {
                    typ = Type.INT_TYPE;
                } else if (t == Opcodes.FLOAT) {
                    typ = Type.FLOAT_TYPE;
                } else if (t == Opcodes.LONG) {
                    typ = Type.LONG_TYPE;
                } else if (t == Opcodes.DOUBLE) {
                    typ = Type.DOUBLE_TYPE;
                } else if (t instanceof String) {
                    typ = Type.getObjectType((String)t);
                }
                this.setFrameLocal(this.remap(index, typ), t);
                Object shadowType = null;
                if (hasTaint && t instanceof Integer && t != Opcodes.NULL && t != Opcodes.UNINITIALIZED_THIS) {
                    shadowType = Configuration.TAINT_TAG_STACK_TYPE;
                } else if (hasTaint && t instanceof String && (_t = Type.getObjectType((String)t)).getSort() == 9 && _t.getDimensions() == 1 && _t.getElementType().getSort() != 10) {
                    shadowType = TaintUtils.getShadowTaintTypeForFrame(_t.getDescriptor());
                }
                if (!this.disabled && !hasTaint) {
                    int newVar = this.remap(index, typ);
                    shadowVar = 0;
                    if (newVar > this.lastArg && this.varToShadowVar.containsKey(newVar)) {
                        shadowVar = this.varToShadowVar.get(newVar);
                        this.setFrameLocal(shadowVar, Opcodes.TOP);
                    }
                }
                if (!this.disabled && shadowType != null) {
                    int newVar = this.remap(index, typ);
                    shadowVar = 0;
                    if (newVar > this.lastArg || newVar < this.lastArg && this.oldArgTypes.get(newVar).getDescriptor().equals("Ltop;")) {
                        shadowVar = !this.varToShadowVar.containsKey(newVar) ? this.newShadowLV(typ, newVar) : this.varToShadowVar.get(newVar).intValue();
                        this.setFrameLocal(shadowVar, shadowType);
                    } else {
                        Type oldT = this.oldArgTypes.get(index);
                        if (!(t instanceof Integer && oldT.getSort() != 10 && oldT.getSort() != 9 || t instanceof String && oldT.getSort() == 9 && oldT.getDimensions() == 1 && oldT.getElementType().getSort() != 10)) {
                            if (t instanceof Integer && oldT.getSort() == 9 && oldT.getDimensions() == 1 && oldT.getElementType().getSort() != 10) {
                                this.setFrameLocal(index - 1, Configuration.TAINT_TAG_STACK_TYPE);
                            } else if (t instanceof String && oldT.getSort() != 9 && oldT.getSort() != 10) {
                                this.setFrameLocal(index - 1, TaintUtils.getShadowTaintTypeForFrame((String)t));
                            } else {
                                shadowVar = !this.varToShadowVar.containsKey(newVar) ? this.newShadowLV(typ, newVar) : this.varToShadowVar.get(newVar).intValue();
                                this.setFrameLocal(shadowVar, shadowType);
                            }
                        }
                    }
                }
            }
            index += size;
        }
        for (int i : this.varToShadowVar.keySet()) {
            if (i < this.newLocals.length && this.newLocals[i] == null && this.varToShadowVar.get(i) < this.newLocals.length) {
                this.newLocals[this.varToShadowVar.get((Object)Integer.valueOf((int)i)).intValue()] = Opcodes.TOP;
                continue;
            }
            if (i >= this.newLocals.length || TaintAdapter.isPrimitiveStackType(this.newLocals[i]) || this.varToShadowVar.get(i) >= this.newLocals.length) continue;
            this.newLocals[this.varToShadowVar.get((Object)Integer.valueOf((int)i)).intValue()] = Opcodes.TOP;
        }
        index = 0;
        number = 0;
        int i = 0;
        while (index < this.newLocals.length) {
            Object t;
            if ((t = this.newLocals[index++]) != null && t != Opcodes.TOP) {
                this.newLocals[i] = t;
                number = i + 1;
                if (t == Opcodes.LONG || t == Opcodes.DOUBLE) {
                    ++index;
                }
            } else {
                this.newLocals[i] = Opcodes.TOP;
            }
            ++i;
        }
        for (i = 0; i < this.newLocals.length; ++i) {
            if (!(this.newLocals[i] instanceof TaggedValue)) continue;
            this.newLocals[i] = ((TaggedValue)this.newLocals[i]).v;
        }
        this.mv.visitFrame(type, number, this.newLocals, nStack, stack);
        this.newLocals = oldLocals;
    }

    public void disable() {
        this.disabled = true;
    }

    private class TmpLV {
        int idx;
        Type type;
        boolean inUse;
        IllegalStateException owner;

        private TmpLV() {
        }

        public String toString() {
            return "TmpLV [idx=" + this.idx + ", type=" + this.type + ", inUse=" + this.inUse + "]";
        }
    }
}

