/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;

public class EclipseCompilerCV
extends ClassVisitor {
    public EclipseCompilerCV(ClassVisitor cv) {
        super(Configuration.ASM_VERSION, cv);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<init>")) {
            mv = new ECJInitMV(mv, desc);
        }
        return mv;
    }

    public static boolean isEclipseCompilerClass(String className) {
        return className != null && className.equals("org/eclipse/jdt/internal/compiler/Compiler");
    }

    private static class ECJInitMV
    extends MethodVisitor {
        private final Type[] args;

        ECJInitMV(MethodVisitor mv, String desc) {
            super(Configuration.ASM_VERSION, mv);
            this.args = Type.getArgumentTypes(desc);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            int idx = 1;
            for (Type arg : this.args) {
                if (arg.getInternalName().equals("org/eclipse/jdt/internal/compiler/IErrorHandlingPolicy")) {
                    super.visitMethodInsn(184, "org/eclipse/jdt/internal/compiler/DefaultErrorHandlingPolicies", "ignoreAllProblems", "()Lorg/eclipse/jdt/internal/compiler/IErrorHandlingPolicy;", false);
                    super.visitVarInsn(58, idx);
                }
                idx += arg.getSize();
            }
        }
    }
}

