/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.SourceSinkTransformer;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;

public class ClinitRetransformMV
extends MethodVisitor {
    private final String className;
    private final boolean fixLdcClass;

    public ClinitRetransformMV(MethodVisitor mv, String className, boolean fixLdcClass) {
        super(Configuration.ASM_VERSION, mv);
        this.className = className;
        this.fixLdcClass = fixLdcClass;
    }

    @Override
    public void visitInsn(int opcode) {
        if (TaintUtils.isReturnOpcode(opcode)) {
            if (this.fixLdcClass) {
                super.visitLdcInsn(this.className.replace("/", "."));
                if (Configuration.IMPLICIT_TRACKING) {
                    super.visitMethodInsn(184, Type.getInternalName(ControlTaintTagStack.class), "factory", "()" + Type.getDescriptor(ControlTaintTagStack.class), false);
                    super.visitMethodInsn(184, "java/lang/Class", "forName$$PHOSPHORTAGGED", "(Ljava/lang/String;" + Type.getDescriptor(ControlTaintTagStack.class) + ")Ljava/lang/Class;", false);
                } else {
                    super.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                }
            } else {
                this.mv.visitLdcInsn(Type.getObjectType(this.className));
            }
            this.mv.visitMethodInsn(184, Type.getInternalName(SourceSinkTransformer.class), "retransform", "(Ljava/lang/Class;)V", false);
        }
        super.visitInsn(opcode);
    }
}

