/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.instrumenter.ClinitRetransformMV;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;

public class ClinitRetransformClassVisitor
extends ClassVisitor {
    private boolean visitedClassInitializer = false;
    private String className;
    private boolean fixLdcClass;

    public ClinitRetransformClassVisitor(ClassVisitor cv) {
        super(Configuration.ASM_VERSION, cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.fixLdcClass = (version & 0xFFFF) < 49;
        this.className = name;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("<clinit>")) {
            this.visitedClassInitializer = true;
            if (!this.className.contains("$$Lambda$")) {
                mv = new ClinitRetransformMV(mv, this.className, this.fixLdcClass);
            }
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        if (!this.visitedClassInitializer) {
            MethodVisitor mv = this.visitMethod(8, "<clinit>", "()V", null, null);
            mv.visitCode();
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        super.visitEnd();
    }
}

