/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor;

import edu.columbia.cs.psl.phosphor.BasicSourceSinkManager;
import edu.columbia.cs.psl.phosphor.PhosphorBaseTransformer;
import edu.columbia.cs.psl.phosphor.PreMain;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.SourceSinkTaintingClassVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassReader;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassWriter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.util.CheckClassAdapter;
import edu.columbia.cs.psl.phosphor.struct.LinkedList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;

public class SourceSinkTransformer
extends PhosphorBaseTransformer {
    private static LinkedList<Class<?>> retransformQueue = new LinkedList();
    private static boolean isBusyRetransforming = false;

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (classBeingRedefined == null) {
            return null;
        }
        try {
            ClassWriter cw;
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassVisitor cv = cw = new ClassWriter(1);
            if (PreMain.DEBUG || TaintUtils.VERIFY_CLASS_GENERATION) {
                cv = new CheckClassAdapter(cw, false);
            }
            cr.accept(new SourceSinkTaintingClassVisitor(cv), 8);
            if (PreMain.DEBUG) {
                try {
                    File f = new File("debug-source-sink/" + className + ".class");
                    f.getParentFile().mkdirs();
                    FileOutputStream fos = new FileOutputStream(f);
                    fos.write(cw.toByteArray());
                    fos.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return cw.toByteArray();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void retransform(Class<?> clazz) {
        Class<BasicSourceSinkManager> clazz2 = BasicSourceSinkManager.class;
        synchronized (BasicSourceSinkManager.class) {
            Class<SourceSinkTransformer> clazz3 = SourceSinkTransformer.class;
            synchronized (SourceSinkTransformer.class) {
                try {
                    Class<PhosphorBaseTransformer> clazz4 = PhosphorBaseTransformer.class;
                    synchronized (PhosphorBaseTransformer.class) {
                        int isBusyTransforming = PhosphorBaseTransformer.isBusyTransforming;
                        // ** MonitorExit[var4_3] (shouldn't be in output)
                        if (isBusyTransforming == 0 && !isBusyRetransforming && INITED && PreMain.getInstrumentation() != null) {
                            isBusyRetransforming = true;
                            retransformQueue.add(clazz);
                            while (!retransformQueue.isEmpty()) {
                                Class<?> poppedClazz = retransformQueue.pop();
                                BasicSourceSinkManager.recordClass(poppedClazz);
                                if (poppedClazz.getName() == null || !BasicSourceSinkManager.getInstance().isSourceOrSinkOrTaintThrough(poppedClazz) || poppedClazz.equals(PrintStream.class)) continue;
                                PreMain.getInstrumentation().retransformClasses(poppedClazz);
                            }
                            isBusyRetransforming = false;
                        } else {
                            retransformQueue.add(clazz);
                        }
                    }
                }
                catch (UnmodifiableClassException isBusyTransforming) {
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw e;
                }
                {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
                {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }
    }
}

