/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.Instrumenter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.MethodNode;
import edu.columbia.cs.psl.phosphor.struct.CallGraph;
import edu.columbia.cs.psl.phosphor.struct.MethodInformation;
import edu.columbia.cs.psl.phosphor.struct.MiniClassNode;

public class CallGraphBuildingClassVisitor
extends ClassVisitor {
    String className;
    final CallGraph graph;
    MiniClassNode thisCN;

    public CallGraphBuildingClassVisitor(ClassVisitor cv, CallGraph graph) {
        super(Configuration.ASM_VERSION, cv);
        this.graph = graph;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
        this.thisCN = this.graph.getClassNode(name);
        this.thisCN.interfaces = interfaces;
        this.thisCN.superName = superName;
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        final MethodInformation thisMIN = this.graph.getMethodNode(this.className, name, desc);
        Instrumenter.classes.get((Object)this.className).methods.add(new MethodNode(access, name, desc, signature, exceptions));
        thisMIN.setVisited(true);
        if ((access & 0x100) != 0) {
            thisMIN.setPure(false);
        }
        return new MethodVisitor(Configuration.ASM_VERSION, super.visitMethod(access, name, desc, signature, exceptions)){

            @Override
            public void visitMethodInsn(int opcode, String _owner, String _name, String _desc, boolean intfc) {
                super.visitMethodInsn(opcode, _owner, _name, _desc, intfc);
                if (opcode != 183 || !_owner.equals("java/lang/Object")) {
                    CallGraphBuildingClassVisitor.this.graph.addEdge(CallGraphBuildingClassVisitor.this.className, name, desc, _owner, _name, _desc);
                }
                if (_owner.equals("java/lang/reflect/Method") && name.equals("invoke")) {
                    thisMIN.setCallsTaintedMethods(true);
                }
                if (opcode == 184) {
                    CallGraphBuildingClassVisitor.this.graph.addEdge(CallGraphBuildingClassVisitor.this.className, name, desc, _owner, "<clinit>", "()V");
                }
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                super.visitFieldInsn(opcode, owner, name2, desc2);
                thisMIN.setPure(false);
                if (opcode == 178 || opcode == 179) {
                    CallGraphBuildingClassVisitor.this.graph.addEdge(CallGraphBuildingClassVisitor.this.className, name2, desc2, owner, "<clinit>", "()V");
                }
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                super.visitTypeInsn(opcode, type);
                if (opcode == 187) {
                    CallGraphBuildingClassVisitor.this.graph.addEdge(CallGraphBuildingClassVisitor.this.className, name, desc, type, "<clinit>", "()V");
                }
            }
        };
    }
}

