/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.Instrumenter;
import edu.columbia.cs.psl.phosphor.PreMain;
import edu.columbia.cs.psl.phosphor.SourceSinkManager;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.ClassNode;
import edu.columbia.cs.psl.phosphor.struct.LinkedList;
import edu.columbia.cs.psl.phosphor.struct.SimpleHashSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.UnmodifiableClassException;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;

public class BasicSourceSinkManager
extends SourceSinkManager {
    public static ConcurrentHashMap<String, Object> sourceLabels = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, SimpleHashSet<String>> sources = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, SimpleHashSet<String>> sinks = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, SimpleHashSet<String>> taintThrough = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, SimpleHashSet<String>> inheritedSources = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, SimpleHashSet<String>> inheritedSinks = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, SimpleHashSet<String>> inheritedTaintThrough = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, SimpleHashSet<Class<?>>> classMap = new ConcurrentHashMap();

    private BasicSourceSinkManager() {
    }

    public static BasicSourceSinkManager getInstance() {
        return BasicSourceSinkManagerSingleton.INSTANCE;
    }

    private static synchronized void readTaintMethods(InputStream src, AutoTaint type) {
        ConcurrentHashMap<String, SimpleHashSet<String>> baseMethods;
        Scanner s = null;
        String lastLine = null;
        switch (type) {
            case SOURCE: {
                baseMethods = sources;
                break;
            }
            case SINK: {
                baseMethods = sinks;
                break;
            }
            default: {
                baseMethods = taintThrough;
            }
        }
        try {
            if (src != null) {
                s = new Scanner(src);
                int i = 0;
                while (s.hasNextLine()) {
                    String line;
                    lastLine = line = s.nextLine();
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    String[] parsed = line.split("\\.");
                    if (!baseMethods.containsKey(parsed[0])) {
                        baseMethods.put(parsed[0], new SimpleHashSet());
                    }
                    baseMethods.get(parsed[0]).add(parsed[1]);
                    if (!type.equals((Object)AutoTaint.SOURCE)) continue;
                    if (Configuration.MULTI_TAINTING) {
                        sourceLabels.put(line, line);
                    } else {
                        if (i > 32) {
                            i = 0;
                        }
                        sourceLabels.put(line, 1 << i);
                    }
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            System.err.printf("Unable to parse %s file: %s\n", type.name, src);
            if (lastLine != null) {
                System.err.printf("Last line read: '%s'\n", lastLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    public static synchronized void recordClass(Class<?> clazz) {
        if (clazz.getName() != null) {
            String key = clazz.getName().replace(".", "/");
            classMap.putIfAbsent(key, new SimpleHashSet());
            classMap.get(key).add(clazz);
        }
    }

    public static synchronized java.util.LinkedList<String> replaceAutoTaintMethods(Iterable<String> src, AutoTaint type) {
        StringBuilder builder = new StringBuilder();
        for (String s : src) {
            builder.append(s).append("\n");
        }
        return BasicSourceSinkManager.replaceAutoTaintMethods(new ByteArrayInputStream(builder.toString().getBytes()), type);
    }

    public static synchronized java.util.LinkedList<String> replaceAutoTaintMethods(InputStream src, AutoTaint type) {
        ConcurrentHashMap<String, SimpleHashSet<String>> inheritedMethods;
        ConcurrentHashMap<String, SimpleHashSet<String>> prevInheritedMethods;
        ConcurrentHashMap<String, SimpleHashSet<String>> baseMethods;
        switch (type) {
            case SOURCE: {
                baseMethods = sources;
                prevInheritedMethods = inheritedSources;
                inheritedSources = new ConcurrentHashMap<String, SimpleHashSet<String>>();
                inheritedMethods = inheritedSources;
                break;
            }
            case SINK: {
                baseMethods = sinks;
                prevInheritedMethods = inheritedSinks;
                inheritedSinks = new ConcurrentHashMap();
                inheritedMethods = inheritedSinks;
                break;
            }
            default: {
                baseMethods = taintThrough;
                prevInheritedMethods = inheritedTaintThrough;
                inheritedTaintThrough = new ConcurrentHashMap();
                inheritedMethods = inheritedTaintThrough;
            }
        }
        java.util.LinkedList<String> prevBaseMethods = new java.util.LinkedList<String>();
        for (String className : baseMethods.keySet()) {
            for (String string : baseMethods.get(className)) {
                prevBaseMethods.add(className + "." + string);
            }
        }
        baseMethods.clear();
        BasicSourceSinkManager.readTaintMethods(src, type);
        for (String className : prevInheritedMethods.keySet()) {
            SimpleHashSet<String> autoTaintMethods = BasicSourceSinkManager.getAutoTaintMethods(className, baseMethods, inheritedMethods);
            if (autoTaintMethods.equals(prevInheritedMethods.get(className))) continue;
            try {
                if (!classMap.containsKey(className)) continue;
                for (Class<?> clazz : classMap.get(className)) {
                    PreMain.getInstrumentation().retransformClasses(clazz);
                }
            }
            catch (UnmodifiableClassException unmodifiableClassException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw throwable;
            }
        }
        return prevBaseMethods;
    }

    private static synchronized SimpleHashSet<String> getAutoTaintMethods(String className, ConcurrentHashMap<String, SimpleHashSet<String>> baseMethods, ConcurrentHashMap<String, SimpleHashSet<String>> inheritedMethods) {
        ClassNode cn;
        if (inheritedMethods.containsKey(className)) {
            return inheritedMethods.get(className);
        }
        SimpleHashSet<String> set = new SimpleHashSet<String>();
        if (baseMethods.containsKey(className)) {
            set.addAll((Iterable)baseMethods.get(className));
        }
        if ((cn = Instrumenter.getClassNode(className)) != null) {
            if (cn.interfaces != null) {
                for (String inter : cn.interfaces) {
                    set.addAll(BasicSourceSinkManager.getAutoTaintMethods(inter, baseMethods, inheritedMethods));
                }
            }
            if (cn.superName != null && !cn.superName.equals("java/lang/Object")) {
                set.addAll(BasicSourceSinkManager.getAutoTaintMethods(cn.superName, baseMethods, inheritedMethods));
            }
        }
        inheritedMethods.put(className, set);
        return set;
    }

    @Override
    public boolean isSourceOrSinkOrTaintThrough(Class<?> clazz) {
        if (clazz.getName() == null) {
            return false;
        }
        String className = clazz.getName().replace(".", "/");
        return !BasicSourceSinkManager.getAutoTaintMethods(className, sinks, inheritedSinks).isEmpty() || !BasicSourceSinkManager.getAutoTaintMethods(className, sources, inheritedSources).isEmpty() || !BasicSourceSinkManager.getAutoTaintMethods(className, taintThrough, inheritedTaintThrough).isEmpty();
    }

    @Override
    public Object getLabel(String str) {
        return sourceLabels.get(str);
    }

    private static synchronized String findSuperTypeAutoTaintProvider(String className, String methodName, ConcurrentHashMap<String, SimpleHashSet<String>> baseMethods, ConcurrentHashMap<String, SimpleHashSet<String>> inheritedMethods) {
        LinkedList<String> queue = new LinkedList<String>();
        queue.add(className);
        while (!queue.isEmpty()) {
            String curClassName = (String)queue.pop();
            if (!inheritedMethods.containsKey(curClassName) || !inheritedMethods.get(curClassName).contains(methodName)) continue;
            if (baseMethods.containsKey(curClassName) && baseMethods.get(curClassName).contains(methodName)) {
                return curClassName;
            }
            ClassNode cn = Instrumenter.getClassNode(curClassName);
            if (cn == null) continue;
            if (cn.interfaces != null) {
                for (String inter : cn.interfaces) {
                    queue.add(inter);
                }
            }
            if (cn.superName == null || cn.superName.equals("java/lang/Object")) continue;
            queue.add(cn.superName);
        }
        return null;
    }

    @Override
    public boolean isTaintThrough(String str) {
        if (str.startsWith("[")) {
            return false;
        }
        String[] parsed = str.split("\\.");
        return BasicSourceSinkManager.getAutoTaintMethods(parsed[0], taintThrough, inheritedTaintThrough).contains(parsed[1]);
    }

    @Override
    public boolean isSource(String str) {
        if (str.startsWith("[")) {
            return false;
        }
        String[] parsed = str.split("\\.");
        if (BasicSourceSinkManager.getAutoTaintMethods(parsed[0], sources, inheritedSources).contains(parsed[1])) {
            String baseSource = BasicSourceSinkManager.findSuperTypeAutoTaintProvider(parsed[0], parsed[1], sources, inheritedSources);
            if (!sourceLabels.containsKey(str)) {
                sourceLabels.put(str, sourceLabels.get(String.format("%s.%s", baseSource, parsed[1])));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSink(String str) {
        if (str.startsWith("[")) {
            return false;
        }
        String[] parsed = str.split("\\.");
        return BasicSourceSinkManager.getAutoTaintMethods(parsed[0], sinks, inheritedSinks).contains(parsed[1]);
    }

    @Override
    public String getBaseSink(String str) {
        String[] parsed = str.split("\\.");
        String baseSink = BasicSourceSinkManager.findSuperTypeAutoTaintProvider(parsed[0], parsed[1], sinks, inheritedSinks);
        return baseSink == null ? null : String.format("%s.%s", baseSink, parsed[1]);
    }

    static {
        BasicSourceSinkManager.readTaintMethods(Instrumenter.sourcesFile, AutoTaint.SOURCE);
        BasicSourceSinkManager.readTaintMethods(Instrumenter.sinksFile, AutoTaint.SINK);
        BasicSourceSinkManager.readTaintMethods(Instrumenter.taintThroughFile, AutoTaint.TAINT_THROUGH);
    }

    public static enum AutoTaint {
        SOURCE("sources"),
        SINK("sinks"),
        TAINT_THROUGH("taintThrough");

        public final String name;

        private AutoTaint(String name) {
            this.name = name;
        }
    }

    private static class BasicSourceSinkManagerSingleton {
        private static final BasicSourceSinkManager INSTANCE = new BasicSourceSinkManager();

        private BasicSourceSinkManagerSingleton() {
        }
    }
}

