package edu.columbia.cs.psl.phosphor;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;

public class UninstDebugPrinter {
    private UninstDebugPrinter(){

    }
    public static void main(String[] args) throws Exception {
        File clazz = new File(args[0]);
        ClassReader cr = new ClassReader(new FileInputStream(clazz));

        ClassWriter cw1 = new ClassWriter(ClassWriter.COMPUTE_FRAMES) {
            @Override
            protected String getCommonSuperClass(String arg0, String arg1) {
                try {
                    return super.getCommonSuperClass(arg0, arg1);
                } catch (Throwable t) {
                    return "java/lang/Object";
                }
            }
        };
        cr.accept(new ClassVisitor(Configuration.ASM_VERSION, cw1) {
            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                mv = new JSRInlinerAdapter(mv, access, name, desc, signature, exceptions);
                return mv;
            }
        }, ClassReader.EXPAND_FRAMES);
        cr = new ClassReader(cw1.toByteArray());

        PrintWriter pw = new PrintWriter(new FileWriter("z-uninst.txt"));


        TraceClassVisitor tcv = new TraceClassVisitor(new ClassVisitor(Configuration.ASM_VERSION, new ClassWriter(0)) {
            String className;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.className = name;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                // TODO Auto-generated method stub
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return mv;
            }
        }, pw);
        cr.accept(tcv, ClassReader.EXPAND_FRAMES);
        pw.flush();
    }
}
