/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient.internal;

import io.restassured.authentication.AuthenticationScheme;
import io.restassured.authentication.NoAuthScheme;
import io.restassured.builder.MultiPartSpecBuilder;
import io.restassured.filter.FilterContext;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.http.Cookies;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.http.Method;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.internal.ResponseParserRegistrar;
import io.restassured.internal.ResponseSpecificationImpl;
import io.restassured.internal.common.assertion.AssertParameter;
import io.restassured.internal.filter.FilterContextImpl;
import io.restassured.internal.log.LogRepository;
import io.restassured.internal.multipart.MultiPartInternal;
import io.restassured.internal.support.PathSupport;
import io.restassured.internal.util.SafeExceptionRethrower;
import io.restassured.module.spring.commons.BodyHelper;
import io.restassured.module.spring.commons.HeaderHelper;
import io.restassured.module.spring.commons.ParamApplier;
import io.restassured.module.spring.commons.RequestLogger;
import io.restassured.module.spring.commons.config.ConfigConverter;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import io.restassured.module.webtestclient.config.RestAssuredWebTestClientConfig;
import io.restassured.module.webtestclient.internal.ExchangeResultConverter;
import io.restassured.module.webtestclient.internal.ResponseConverter;
import io.restassured.module.webtestclient.internal.UriContainer;
import io.restassured.module.webtestclient.internal.WebTestClientRestAssuredResponseImpl;
import io.restassured.module.webtestclient.response.WebTestClientResponse;
import io.restassured.module.webtestclient.specification.WebTestClientRequestSender;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.codec.Charsets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.FluxExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class WebTestClientRequestSenderImpl
implements WebTestClientRequestSender {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final Pattern PATH_PARAM_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private static boolean isWebflux7OrAbove = Arrays.stream(WebTestClient.RequestBodySpec.class.getMethods()).anyMatch(method -> method.getName().equals(""));
    private final WebTestClient webTestClient;
    private final Map<String, Object> params;
    private final Map<String, Object> namedPathParams;
    private final Map<String, Object> queryParams;
    private final Map<String, Object> formParams;
    private final Map<String, Object> attributes;
    private final RestAssuredWebTestClientConfig config;
    private final Object requestBody;
    private final Cookies cookies;
    private final List<MultiPartInternal> multiParts;
    private final String basePath;
    private final ResponseSpecification responseSpecification;
    private final LogRepository logRepository;
    private Headers headers;
    private final RequestLoggingFilter requestLoggingFilter;
    private Consumer<EntityExchangeResult<byte[]>> consumer;

    @Override
    public WebTestClientResponse get(Function<UriBuilder, URI> uriFunction) {
        return this.sendRequest(HttpMethod.GET, uriFunction);
    }

    @Override
    public WebTestClientResponse post(Function<UriBuilder, URI> uriFunction) {
        return this.sendRequest(HttpMethod.POST, uriFunction);
    }

    @Override
    public WebTestClientResponse put(Function<UriBuilder, URI> uriFunction) {
        return this.sendRequest(HttpMethod.PUT, uriFunction);
    }

    @Override
    public WebTestClientResponse delete(Function<UriBuilder, URI> uriFunction) {
        return this.sendRequest(HttpMethod.DELETE, uriFunction);
    }

    @Override
    public WebTestClientResponse patch(Function<UriBuilder, URI> uriFunction) {
        return this.sendRequest(HttpMethod.PATCH, uriFunction);
    }

    @Override
    public WebTestClientResponse head(Function<UriBuilder, URI> uriFunction) {
        return this.sendRequest(HttpMethod.HEAD, uriFunction);
    }

    @Override
    public WebTestClientResponse options(Function<UriBuilder, URI> uriFunction) {
        return this.sendRequest(HttpMethod.OPTIONS, uriFunction);
    }

    @Override
    public WebTestClientResponse request(Method method, Function<UriBuilder, URI> uriFunction) {
        return this.request(((Method)AssertParameter.notNull((Object)method, Method.class)).name(), uriFunction);
    }

    @Override
    public WebTestClientResponse request(String method, Function<UriBuilder, URI> uriFunction) {
        return this.sendRequest(this.toValidHttpMethod(method), uriFunction);
    }

    private HttpMethod toValidHttpMethod(String method) {
        String httpMethodAsString = (String)AssertParameter.notNull((Object)StringUtils.trimToNull((String)method), (String)"HTTP Method");
        try {
            return HttpMethod.valueOf((String)httpMethodAsString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("HTTP method '%s' is not supported by WebTestClient", method));
        }
    }

    public WebTestClientResponse get(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.GET, path, pathParams);
    }

    public WebTestClientRequestSenderImpl(WebTestClient webTestClient, Map<String, Object> params, Map<String, Object> namedPathParams, Map<String, Object> queryParams, Map<String, Object> formParams, Map<String, Object> attributes, RestAssuredWebTestClientConfig config, Object requestBody, Headers headers, Cookies cookies, List<MultiPartInternal> multiParts, RequestLoggingFilter requestLoggingFilter, String basePath, ResponseSpecification responseSpecification, LogRepository logRepository) {
        this.webTestClient = webTestClient;
        this.params = params;
        this.namedPathParams = namedPathParams;
        this.queryParams = queryParams;
        this.formParams = formParams;
        this.attributes = attributes;
        this.config = config;
        this.requestBody = requestBody;
        this.headers = headers;
        this.cookies = cookies;
        this.multiParts = multiParts;
        this.basePath = basePath;
        this.responseSpecification = responseSpecification;
        this.logRepository = logRepository;
        this.requestLoggingFilter = requestLoggingFilter;
    }

    @Override
    public WebTestClientRequestSender consumeWith(Consumer<EntityExchangeResult<byte[]>> consumer) {
        this.consumer = consumer;
        return this;
    }

    public WebTestClientResponse get(String path, Map<String, ?> pathParams) {
        return this.get(path, HeaderHelper.mapToArray(pathParams));
    }

    public WebTestClientResponse post(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.POST, path, pathParams);
    }

    public WebTestClientResponse post(String path, Map<String, ?> pathParams) {
        return this.post(path, HeaderHelper.mapToArray(pathParams));
    }

    public WebTestClientResponse put(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.PUT, path, pathParams);
    }

    public WebTestClientResponse put(String path, Map<String, ?> pathParams) {
        return this.put(path, HeaderHelper.mapToArray(pathParams));
    }

    public WebTestClientResponse delete(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.DELETE, path, pathParams);
    }

    public WebTestClientResponse delete(String path, Map<String, ?> pathParams) {
        return this.delete(path, HeaderHelper.mapToArray(pathParams));
    }

    public WebTestClientResponse head(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.HEAD, path, pathParams);
    }

    public WebTestClientResponse head(String path, Map<String, ?> pathParams) {
        return this.head(path, HeaderHelper.mapToArray(pathParams));
    }

    public WebTestClientResponse patch(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.PATCH, path, pathParams);
    }

    public WebTestClientResponse patch(String path, Map<String, ?> pathParams) {
        return this.patch(path, HeaderHelper.mapToArray(pathParams));
    }

    public WebTestClientResponse options(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.OPTIONS, path, pathParams);
    }

    public WebTestClientResponse options(String path, Map<String, ?> pathParams) {
        return this.options(path, HeaderHelper.mapToArray(pathParams));
    }

    public WebTestClientResponse get(URI uri) {
        return this.get(uri.toString(), new Object[0]);
    }

    public WebTestClientResponse post(URI uri) {
        return this.post(uri.toString(), new Object[0]);
    }

    public WebTestClientResponse put(URI uri) {
        return this.put(uri.toString(), new Object[0]);
    }

    public WebTestClientResponse delete(URI uri) {
        return this.delete(uri.toString(), new Object[0]);
    }

    public WebTestClientResponse head(URI uri) {
        return this.head(uri.toString(), new Object[0]);
    }

    public WebTestClientResponse patch(URI uri) {
        return this.patch(uri.toString(), new Object[0]);
    }

    public WebTestClientResponse options(URI uri) {
        return this.options(uri.toString(), new Object[0]);
    }

    public WebTestClientResponse get(URL url) {
        return this.get(url.toString(), new Object[0]);
    }

    public WebTestClientResponse post(URL url) {
        return this.post(url.toString(), new Object[0]);
    }

    public WebTestClientResponse put(URL url) {
        return this.put(url.toString(), new Object[0]);
    }

    public WebTestClientResponse delete(URL url) {
        return this.delete(url.toString(), new Object[0]);
    }

    public WebTestClientResponse head(URL url) {
        return this.head(url.toString(), new Object[0]);
    }

    public WebTestClientResponse patch(URL url) {
        return this.patch(url.toString(), new Object[0]);
    }

    public WebTestClientResponse options(URL url) {
        return this.options(url.toString(), new Object[0]);
    }

    public WebTestClientResponse get() {
        return this.get("", new Object[0]);
    }

    public WebTestClientResponse post() {
        return this.post("", new Object[0]);
    }

    public WebTestClientResponse put() {
        return this.put("", new Object[0]);
    }

    public WebTestClientResponse delete() {
        return this.delete("", new Object[0]);
    }

    public WebTestClientResponse head() {
        return this.head("", new Object[0]);
    }

    public WebTestClientResponse patch() {
        return this.patch("", new Object[0]);
    }

    public WebTestClientResponse options() {
        return this.options("", new Object[0]);
    }

    public WebTestClientResponse request(Method method) {
        return this.request(method, "", new Object[0]);
    }

    public WebTestClientResponse request(String method) {
        return this.request(method, "", new Object[0]);
    }

    public WebTestClientResponse request(Method method, String path, Object ... pathParams) {
        return this.request(((Method)AssertParameter.notNull((Object)method, Method.class)).name(), path, pathParams);
    }

    public WebTestClientResponse request(String method, String path, Object ... pathParams) {
        return this.sendRequest(this.toValidHttpMethod(method), path, pathParams);
    }

    public WebTestClientResponse request(Method method, URI uri) {
        return this.request(method, ((URI)AssertParameter.notNull((Object)uri, URI.class)).toString(), new Object[0]);
    }

    public WebTestClientResponse request(Method method, URL url) {
        return this.request(method, ((URL)AssertParameter.notNull((Object)url, URL.class)).toString(), new Object[0]);
    }

    public WebTestClientResponse request(String method, URI uri) {
        return this.request(method, ((URI)AssertParameter.notNull((Object)uri, URI.class)).toString(), new Object[0]);
    }

    public WebTestClientResponse request(String method, URL url) {
        return this.request(method, ((URL)AssertParameter.notNull((Object)url, URL.class)).toString(), new Object[0]);
    }

    private WebTestClientResponse sendRequest(HttpMethod method, String path, Object[] unnamedPathParams) {
        String requestContentType = HeaderHelper.findContentType((Headers)this.headers, this.multiParts, (SpecificationConfig)this.config);
        WebTestClient.RequestBodySpec requestBodySpec = this.buildFromPath(method, requestContentType, path, unnamedPathParams);
        this.addRequestElements(method, requestContentType, requestBodySpec);
        this.logRequestIfApplicable(method, this.getBaseUri(path), path, unnamedPathParams);
        return this.performRequest(requestBodySpec);
    }

    private WebTestClient.RequestBodySpec buildFromPath(HttpMethod method, String requestContentType, String path, Object[] unnamedPathParams) {
        AssertParameter.notNull((Object)path, (String)"Path");
        String baseUri = this.getBaseUri(path);
        UriContainer uriContainer = this.buildUri(method, requestContentType, baseUri, unnamedPathParams);
        return (WebTestClient.RequestBodySpec)this.webTestClient.method(method).uri(uriContainer.getUri(), uriContainer.getUriVariables());
    }

    private void addRequestElements(HttpMethod method, String requestContentType, WebTestClient.RequestBodySpec requestBodySpec) {
        this.verifyNoBodyAndMultipartTogether();
        if (StringUtils.isNotBlank((CharSequence)requestContentType)) {
            requestBodySpec.contentType(MediaType.parseMediaType((String)requestContentType));
        }
        this.applyRequestBody(requestBodySpec);
        this.applyMultipartBody(method, requestBodySpec);
        this.applyAttributes(requestBodySpec);
        this.headers.forEach(header -> requestBodySpec.header(header.getName(), new String[]{header.getValue()}));
        this.cookies.asList().forEach(cookie -> requestBodySpec.cookie(cookie.getName(), cookie.getValue()));
    }

    private void logRequestIfApplicable(HttpMethod method, String uri, String originalPath, Object[] unnamedPathParams) {
        if (this.requestLoggingFilter == null) {
            return;
        }
        RequestSpecificationImpl reqSpec = new RequestSpecificationImpl("http://localhost", -1, "", (AuthenticationScheme)new NoAuthScheme(), Collections.emptyList(), null, true, ConfigConverter.convertToRestAssuredConfig((SpecificationConfig)this.config), this.logRepository, null, true, true);
        RequestLogger.logParamsAndHeaders((RequestSpecificationImpl)reqSpec, (String)method.toString(), (String)uri, (Object[])unnamedPathParams, this.params, this.namedPathParams, this.queryParams, this.formParams, (Headers)this.headers, (Cookies)this.cookies);
        RequestLogger.logRequestBody((RequestSpecificationImpl)reqSpec, (Object)this.requestBody, (Headers)this.headers, this.multiParts, (SpecificationConfig)this.config);
        Optional.ofNullable(this.multiParts).map(Collection::stream).orElseGet(Stream::empty).forEach(multiPart -> this.addMultipartToReqSpec((RequestSpecification)reqSpec, (MultiPartInternal)multiPart));
        String originalUriPath = PathSupport.getPath((String)originalPath);
        String uriPath = PathSupport.getPath((String)uri);
        this.requestLoggingFilter.filter((FilterableRequestSpecification)reqSpec, null, (FilterContext)new FilterContextImpl(uri, originalUriPath, uriPath, uri, uri, new Object[0], method.toString(), null, Collections.emptyList().iterator(), new HashMap()));
    }

    private String getBaseUri(String path) {
        String baseUri = StringUtils.isNotBlank((CharSequence)this.basePath) ? PathSupport.mergeAndRemoveDoubleSlash((String)this.basePath, (String)path) : path;
        return baseUri;
    }

    private WebTestClientResponse performRequest(WebTestClient.RequestBodySpec requestBuilder) {
        WebTestClientRestAssuredResponseImpl restAssuredResponse;
        try {
            long start = System.currentTimeMillis();
            WebTestClient.ResponseSpec responseSpec = requestBuilder.exchange();
            long responseTime = System.currentTimeMillis() - start;
            FluxExchangeResult result = responseSpec.returnResult(byte[].class);
            restAssuredResponse = new ExchangeResultConverter().toRestAssuredResponse((FluxExchangeResult<byte[]>)result, responseSpec, responseTime, this.logRepository, this.config, this.consumer, this.getRpr());
            if (this.responseSpecification != null) {
                this.responseSpecification.validate(ResponseConverter.toStandardResponse(restAssuredResponse));
            }
        }
        catch (Exception e) {
            return (WebTestClientResponse)SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        return restAssuredResponse;
    }

    private UriContainer buildUri(HttpMethod method, String requestContentType, String baseUri, Object[] unnamedPathParams) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)baseUri);
        UriContainer.Builder uriContainerBuilder = UriContainer.newBuilder(baseUri);
        this.applyQueryParams(uriComponentsBuilder);
        this.applyPathParams(uriContainerBuilder, baseUri, unnamedPathParams);
        this.applyParams(method, uriComponentsBuilder, requestContentType);
        this.applyFormParams(method, uriComponentsBuilder, requestContentType);
        String uriWithoutPathParams = uriComponentsBuilder.cloneBuilder().uriVariables(Collections.emptyMap()).build(false).toUriString();
        return uriContainerBuilder.uri(uriWithoutPathParams).build();
    }

    private void verifyNoBodyAndMultipartTogether() {
        if (this.requestBody != null && !this.multiParts.isEmpty()) {
            throw new IllegalStateException("You cannot specify a request body and a multi-part body in the same request. Perhaps you want to change the body to a multi part?");
        }
    }

    private void applyRequestBody(WebTestClient.RequestBodySpec requestBodySpec) {
        if (this.requestBody != null) {
            if (this.requestBody instanceof byte[]) {
                requestBodySpec.bodyValue(this.requestBody);
            } else if (this.requestBody instanceof File) {
                byte[] bytes = BodyHelper.toByteArray((File)((File)this.requestBody));
                requestBodySpec.bodyValue((Object)bytes);
            } else {
                requestBodySpec.bodyValue((Object)this.requestBody.toString());
            }
        }
    }

    private void applyMultipartBody(HttpMethod method, WebTestClient.RequestBodySpec requestBodySpec) {
        if (!this.multiParts.isEmpty()) {
            if (method != HttpMethod.POST && method != HttpMethod.PUT && method != HttpMethod.PATCH) {
                throw new IllegalArgumentException("Currently multi-part file data uploading only works for POST, PUT and PATCH method.");
            }
            requestBodySpec.bodyValue(this.getMultipartBody());
        }
    }

    private void applyAttributes(final WebTestClient.RequestBodySpec requestBodySpec) {
        if (!this.attributes.isEmpty()) {
            new ParamApplier(this.attributes){

                protected void applyParam(String paramName, String[] paramValues) {
                    requestBodySpec.attribute(paramName, (Object)paramValues[0]);
                }
            }.applyParams();
        }
    }

    private void addMultipartToReqSpec(RequestSpecification requestSpecification, MultiPartInternal multiPart) {
        requestSpecification.multiPart(new MultiPartSpecBuilder(multiPart.getContent()).controlName(multiPart.getControlName()).fileName(multiPart.getFileName()).mimeType(multiPart.getMimeType()).build());
    }

    private void applyQueryParams(final UriComponentsBuilder uriComponentsBuilder) {
        if (!this.queryParams.isEmpty()) {
            new ParamApplier(this.queryParams){

                protected void applyParam(String paramName, String[] paramValues) {
                    uriComponentsBuilder.queryParam(paramName, (Object[])paramValues);
                }
            }.applyParams();
        }
    }

    private void applyPathParams(UriContainer.Builder uriContainerBuilder, String baseUri, Object[] unnamedPathParams) {
        Matcher pathParamMatcher = PATH_PARAM_PATTERN.matcher(baseUri);
        if (!pathParamMatcher.find()) {
            return;
        }
        if (this.namedPathParams.isEmpty() && ArrayUtils.isEmpty((Object[])unnamedPathParams)) {
            throw new IllegalArgumentException("No values were found for the request's pathParams.");
        }
        AtomicInteger nextUnnamedPathParamIndex = new AtomicInteger(0);
        Function<String, Optional> getPathParamValueFunction = param -> {
            if (this.namedPathParams.containsKey(param)) {
                return Optional.of(this.namedPathParams.get(param));
            }
            if (unnamedPathParams.length > 0) {
                return Optional.of(unnamedPathParams[nextUnnamedPathParamIndex.getAndIncrement()]);
            }
            return Optional.empty();
        };
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        do {
            String paramName = pathParamMatcher.group(1);
            getPathParamValueFunction.apply(paramName).ifPresent(paramValue -> uriVariables.put(paramName, UriUtils.encode((String)((String)paramValue), (Charset)Charsets.UTF_8)));
        } while (pathParamMatcher.find());
        uriContainerBuilder.uriVariables(uriVariables);
    }

    private void applyParams(HttpMethod method, final UriComponentsBuilder uriComponentsBuilder, String requestContentType) {
        if (!this.params.isEmpty()) {
            new ParamApplier(this.params){

                protected void applyParam(String paramName, String[] paramValues) {
                    uriComponentsBuilder.queryParam(paramName, (Object[])paramValues);
                }
            }.applyParams();
            if (StringUtils.isBlank((CharSequence)requestContentType) && method == HttpMethod.POST && !this.isMultipartRequest()) {
                this.setContentTypeToApplicationFormUrlEncoded();
            }
        }
    }

    private void applyFormParams(HttpMethod method, final UriComponentsBuilder uriComponentsBuilder, String requestContentType) {
        if (!this.formParams.isEmpty()) {
            if (method == HttpMethod.GET) {
                throw new IllegalArgumentException("Cannot use form parameters in a GET request");
            }
            new ParamApplier(this.formParams){

                protected void applyParam(String paramName, String[] paramValues) {
                    uriComponentsBuilder.queryParam(paramName, (Object[])paramValues);
                }
            }.applyParams();
            if (StringUtils.isBlank((CharSequence)requestContentType) && !this.isMultipartRequest()) {
                this.setContentTypeToApplicationFormUrlEncoded();
            }
        }
    }

    private MultiValueMap<String, HttpEntity<?>> getMultipartBody() {
        MultipartBodyBuilder multipartBodyBuilder = new MultipartBodyBuilder();
        this.multiParts.stream().forEach(multipart -> multipartBodyBuilder.part(multipart.getFileName(), multipart.getContentBody()));
        return multipartBodyBuilder.build();
    }

    private boolean isMultipartRequest() {
        return !this.multiParts.isEmpty();
    }

    private void setContentTypeToApplicationFormUrlEncoded() {
        String requestContentType = MediaType.parseMediaType((String)HeaderHelper.buildApplicationFormEncodedContentType((SpecificationConfig)this.config, (String)"application/x-www-form-urlencoded")).toString();
        ArrayList<Header> newHeaders = new ArrayList<Header>(this.headers.asList());
        newHeaders.add(new Header(CONTENT_TYPE, requestContentType));
        this.headers = new Headers(newHeaders);
    }

    private WebTestClientResponse sendRequest(HttpMethod method, Function<UriBuilder, URI> uriFunction) {
        String requestContentType = HeaderHelper.findContentType((Headers)this.headers, this.multiParts, (SpecificationConfig)this.config);
        WebTestClient.RequestBodySpec requestBodySpec = this.buildFromUriFunction(method, uriFunction);
        this.addRequestElements(method, requestContentType, requestBodySpec);
        this.logRequestIfApplicable(method, uriFunction);
        return this.performRequest(requestBodySpec);
    }

    private WebTestClient.RequestBodySpec buildFromUriFunction(HttpMethod method, Function<UriBuilder, URI> uriFunction) {
        return (WebTestClient.RequestBodySpec)this.webTestClient.method(method).uri(uriFunction);
    }

    private void logRequestIfApplicable(HttpMethod method, Function<UriBuilder, URI> uriFunction) {
        if (this.requestLoggingFilter == null) {
            return;
        }
        RequestSpecificationImpl reqSpec = new RequestSpecificationImpl("http://localhost", -1, "", (AuthenticationScheme)new NoAuthScheme(), Collections.emptyList(), null, true, ConfigConverter.convertToRestAssuredConfig((SpecificationConfig)this.config), this.logRepository, null, true, true);
        RequestLogger.logParamsAndHeaders((RequestSpecificationImpl)reqSpec, (String)method.toString(), (String)("Request from uri function" + uriFunction.toString()), null, this.params, this.namedPathParams, this.queryParams, this.formParams, (Headers)this.headers, (Cookies)this.cookies);
        RequestLogger.logRequestBody((RequestSpecificationImpl)reqSpec, (Object)this.requestBody, (Headers)this.headers, this.multiParts, (SpecificationConfig)this.config);
        Optional.ofNullable(this.multiParts).map(Collection::stream).orElseGet(Stream::empty).forEach(multiPart -> this.addMultipartToReqSpec((RequestSpecification)reqSpec, (MultiPartInternal)multiPart));
        this.requestLoggingFilter.filter((FilterableRequestSpecification)reqSpec, null, (FilterContext)new FilterContextImpl("Request from uri function" + uriFunction.toString(), null, null, null, null, new Object[0], method.toString(), null, Collections.emptyList().iterator(), new HashMap()));
    }

    private ResponseParserRegistrar getRpr() {
        if (this.responseSpecification instanceof ResponseSpecificationImpl) {
            return ((ResponseSpecificationImpl)this.responseSpecification).getRpr();
        }
        return new ResponseParserRegistrar();
    }
}

