/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.spring.commons;

import io.restassured.config.EncoderConfig;
import io.restassured.config.ObjectMapperConfig;
import io.restassured.internal.http.CharsetExtractor;
import io.restassured.internal.mapping.ObjectMapping;
import io.restassured.internal.serialization.SerializationSupport;
import io.restassured.module.spring.commons.config.SpecificationConfig;

public class Serializer {
    private Serializer() {
    }

    public static String serializeIfNeeded(Object object, String contentType, SpecificationConfig config) {
        return SerializationSupport.isSerializableCandidate((Object)object) ? ObjectMapping.serialize((Object)object, (String)contentType, (String)Serializer.findEncoderCharsetOrReturnDefault(contentType, config), null, (ObjectMapperConfig)config.getObjectMapperConfig(), (EncoderConfig)config.getEncoderConfig()) : object.toString();
    }

    public static String findEncoderCharsetOrReturnDefault(String contentType, SpecificationConfig config) {
        String charset = CharsetExtractor.getCharsetFromContentType((String)contentType);
        if (charset == null) {
            EncoderConfig encoderConfig = config.getEncoderConfig();
            charset = encoderConfig.hasDefaultCharsetForContentType(contentType) ? encoderConfig.defaultCharsetForContentType(contentType) : encoderConfig.defaultContentCharset();
        }
        return charset;
    }
}

