/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class BehaviorProcessor<T>
extends FlowableProcessor<T> {
    final AtomicReference<BehaviorSubscription<T>[]> subscribers;
    static final Object[] EMPTY_ARRAY = new Object[0];
    static final BehaviorSubscription[] EMPTY = new BehaviorSubscription[0];
    static final BehaviorSubscription[] TERMINATED = new BehaviorSubscription[0];
    final ReadWriteLock lock;
    final Lock readLock;
    final Lock writeLock;
    final AtomicReference<Object> value = new AtomicReference();
    final AtomicReference<Throwable> terminalEvent;
    long index;

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorProcessor<T> create() {
        return new BehaviorProcessor<T>();
    }

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorProcessor<T> createDefault(T defaultValue) {
        ObjectHelper.requireNonNull(defaultValue, "defaultValue is null");
        return new BehaviorProcessor<T>(defaultValue);
    }

    BehaviorProcessor() {
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
        this.subscribers = new AtomicReference<BehaviorSubscription[]>(EMPTY);
        this.terminalEvent = new AtomicReference();
    }

    BehaviorProcessor(T defaultValue) {
        this();
        this.value.lazySet(ObjectHelper.requireNonNull(defaultValue, "defaultValue is null"));
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        BehaviorSubscription<T> bs = new BehaviorSubscription<T>(s, this);
        s.onSubscribe(bs);
        if (this.add(bs)) {
            if (bs.cancelled) {
                this.remove(bs);
            } else {
                bs.emitFirst();
            }
        } else {
            Throwable ex = this.terminalEvent.get();
            if (ex == ExceptionHelper.TERMINATED) {
                s.onComplete();
            } else {
                s.onError(ex);
            }
        }
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.terminalEvent.get() != null) {
            s.cancel();
            return;
        }
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        ObjectHelper.requireNonNull(t, "onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (this.terminalEvent.get() != null) {
            return;
        }
        Object o = NotificationLite.next(t);
        this.setCurrent(o);
        for (BehaviorSubscription<T> bs : this.subscribers.get()) {
            bs.emitNext(o, this.index);
        }
    }

    public void onError(Throwable t) {
        ObjectHelper.requireNonNull(t, "onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        if (!this.terminalEvent.compareAndSet(null, t)) {
            RxJavaPlugins.onError(t);
            return;
        }
        Object o = NotificationLite.error(t);
        for (BehaviorSubscription<T> bs : this.terminate(o)) {
            bs.emitNext(o, this.index);
        }
    }

    public void onComplete() {
        if (!this.terminalEvent.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            return;
        }
        Object o = NotificationLite.complete();
        for (BehaviorSubscription<T> bs : this.terminate(o)) {
            bs.emitNext(o, this.index);
        }
    }

    public boolean offer(T t) {
        BehaviorSubscription<T>[] array;
        if (t == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return true;
        }
        for (BehaviorSubscription<T> s : array = this.subscribers.get()) {
            if (!s.isFull()) continue;
            return false;
        }
        Object o = NotificationLite.next(t);
        this.setCurrent(o);
        for (BehaviorSubscription<T> bs : array) {
            bs.emitNext(o, this.index);
        }
        return true;
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        Object o = this.value.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    @Nullable
    public T getValue() {
        Object o = this.value.get();
        if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
            return null;
        }
        return NotificationLite.getValue(o);
    }

    @Deprecated
    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    @Deprecated
    public T[] getValues(T[] array) {
        Object o = this.value.get();
        if (o == null || NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
            if (array.length != 0) {
                array[0] = null;
            }
            return array;
        }
        Object v = NotificationLite.getValue(o);
        if (array.length != 0) {
            array[0] = v;
            if (array.length != 1) {
                array[1] = null;
            }
        } else {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), 1);
            array[0] = v;
        }
        return array;
    }

    @Override
    public boolean hasComplete() {
        Object o = this.value.get();
        return NotificationLite.isComplete(o);
    }

    @Override
    public boolean hasThrowable() {
        Object o = this.value.get();
        return NotificationLite.isError(o);
    }

    public boolean hasValue() {
        Object o = this.value.get();
        return o != null && !NotificationLite.isComplete(o) && !NotificationLite.isError(o);
    }

    boolean add(BehaviorSubscription<T> rs) {
        BehaviorSubscription[] b;
        BehaviorSubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a.length;
            b = new BehaviorSubscription[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(BehaviorSubscription<T> rs) {
        BehaviorSubscription[] b;
        BehaviorSubscription<T>[] a;
        do {
            int len;
            if ((len = (a = this.subscribers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new BehaviorSubscription[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    BehaviorSubscription<T>[] terminate(Object terminalValue) {
        BehaviorSubscription<T>[] a = this.subscribers.get();
        if (a != TERMINATED && (a = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
            this.setCurrent(terminalValue);
        }
        return a;
    }

    void setCurrent(Object o) {
        Lock wl = this.writeLock;
        wl.lock();
        ++this.index;
        this.value.lazySet(o);
        wl.unlock();
    }

    static final class BehaviorSubscription<T>
    extends AtomicLong
    implements Subscription,
    AppendOnlyLinkedArrayList.NonThrowingPredicate<Object> {
        private static final long serialVersionUID = 3293175281126227086L;
        final Subscriber<? super T> actual;
        final BehaviorProcessor<T> state;
        boolean next;
        boolean emitting;
        AppendOnlyLinkedArrayList<Object> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        BehaviorSubscription(Subscriber<? super T> actual, BehaviorProcessor<T> state) {
            this.actual = actual;
            this.state = state;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o;
            if (this.cancelled) {
                return;
            }
            BehaviorSubscription behaviorSubscription = this;
            synchronized (behaviorSubscription) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                BehaviorProcessor<T> s = this.state;
                Lock readLock = s.readLock;
                readLock.lock();
                this.index = s.index;
                o = s.value.get();
                readLock.unlock();
                this.emitting = o != null;
                this.next = true;
            }
            if (o != null) {
                if (this.test(o)) {
                    return;
                }
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(Object value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorSubscription behaviorSubscription = this;
                synchronized (behaviorSubscription) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q = this.queue;
                        if (q == null) {
                            this.queue = q = new AppendOnlyLinkedArrayList(4);
                        }
                        q.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(Object o) {
            if (this.cancelled) {
                return true;
            }
            if (NotificationLite.isComplete(o)) {
                this.actual.onComplete();
                return true;
            }
            if (NotificationLite.isError(o)) {
                this.actual.onError(NotificationLite.getError(o));
                return true;
            }
            long r = this.get();
            if (r != 0L) {
                this.actual.onNext(NotificationLite.getValue(o));
                if (r != Long.MAX_VALUE) {
                    this.decrementAndGet();
                }
                return false;
            }
            this.cancel();
            this.actual.onError((Throwable)new MissingBackpressureException("Could not deliver value due to lack of requests"));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<Object> q;
                BehaviorSubscription behaviorSubscription = this;
                synchronized (behaviorSubscription) {
                    q = this.queue;
                    if (q == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                q.forEachWhile(this);
            }
            return;
        }

        public boolean isFull() {
            return this.get() == 0L;
        }
    }
}

