/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.annotations.Nullable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableFromIterable;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableFlattenIterable<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    final int prefetch;

    public FlowableFlattenIterable(Flowable<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
        super(source);
        this.mapper = mapper;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s) {
        if (this.source instanceof Callable) {
            Iterator<? extends R> it;
            Object v;
            try {
                v = ((Callable)((Object)this.source)).call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(ex, s);
                return;
            }
            if (v == null) {
                EmptySubscription.complete(s);
                return;
            }
            try {
                Iterable<R> iterable = this.mapper.apply(v);
                it = iterable.iterator();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(ex, s);
                return;
            }
            FlowableFromIterable.subscribe(s, it);
            return;
        }
        this.source.subscribe(new FlattenIterableSubscriber<T, R>(s, this.mapper, this.prefetch));
    }

    static final class FlattenIterableSubscriber<T, R>
    extends BasicIntQueueSubscription<R>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -3096000382929934955L;
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        final int prefetch;
        final int limit;
        final AtomicLong requested;
        Subscription s;
        SimpleQueue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicReference<Throwable> error;
        Iterator<? extends R> current;
        int consumed;
        int fusionMode;

        FlattenIterableSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch) {
            this.actual = actual;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.error = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.actual.onSubscribe((Subscription)this);
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.actual.onSubscribe((Subscription)this);
                        s.request((long)this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.fusionMode == 0 && !this.queue.offer(t)) {
                this.onError(new MissingBackpressureException("Queue is full?!"));
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (!this.done && ExceptionHelper.addThrowable(this.error, t)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<? super R> a = this.actual;
            SimpleQueue<T> q = this.queue;
            boolean replenish = this.fusionMode != 1;
            int missed = 1;
            Iterator<R> it = this.current;
            while (true) {
                if (it == null) {
                    boolean empty;
                    T t;
                    boolean d = this.done;
                    try {
                        t = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.s.cancel();
                        ExceptionHelper.addThrowable(this.error, ex);
                        ex = ExceptionHelper.terminate(this.error);
                        this.current = null;
                        q.clear();
                        a.onError(ex);
                        return;
                    }
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (t != null) {
                        boolean b;
                        try {
                            Iterable<R> iterable = this.mapper.apply(t);
                            it = iterable.iterator();
                            b = it.hasNext();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.s.cancel();
                            it = null;
                            ExceptionHelper.addThrowable(this.error, ex);
                            ex = ExceptionHelper.terminate(this.error);
                            a.onError(ex);
                            return;
                        }
                        if (!b) {
                            it = null;
                            this.consumedOne(replenish);
                            continue;
                        }
                        this.current = it;
                    }
                }
                if (it != null) {
                    long e;
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        R v;
                        if (this.checkTerminated(this.done, false, a, q)) {
                            return;
                        }
                        try {
                            v = it.next();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.current = null;
                            this.s.cancel();
                            ExceptionHelper.addThrowable(this.error, ex);
                            ex = ExceptionHelper.terminate(this.error);
                            a.onError(ex);
                            return;
                        }
                        a.onNext(v);
                        if (this.checkTerminated(this.done, false, a, q)) {
                            return;
                        }
                        try {
                            boolean b = it.hasNext();
                            continue;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.current = null;
                            this.s.cancel();
                            ExceptionHelper.addThrowable(this.error, ex);
                            ex = ExceptionHelper.terminate(this.error);
                            a.onError(ex);
                            return;
                        }
                    }
                    if (e == r) {
                        boolean empty;
                        boolean d = this.done;
                        boolean bl = empty = q.isEmpty() && it == null;
                        if (this.checkTerminated(d, empty, a, q)) {
                            return;
                        }
                    }
                    if (e != 0L && r != Long.MAX_VALUE) {
                        this.requested.addAndGet(-e);
                    }
                    if (it == null) continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void consumedOne(boolean enabled) {
            if (enabled) {
                int c = this.consumed + 1;
                if (c == this.limit) {
                    this.consumed = 0;
                    this.s.request((long)c);
                } else {
                    this.consumed = c;
                }
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, SimpleQueue<?> q) {
            if (this.cancelled) {
                this.current = null;
                q.clear();
                return true;
            }
            if (d) {
                Throwable ex = this.error.get();
                if (ex != null) {
                    ex = ExceptionHelper.terminate(this.error);
                    this.current = null;
                    q.clear();
                    a.onError(ex);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            this.current = null;
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            Iterator<R> it = this.current;
            return it != null && !it.hasNext() || this.queue.isEmpty();
        }

        @Override
        @Nullable
        public R poll() throws Exception {
            Iterator<R> it = this.current;
            while (it == null) {
                T v = this.queue.poll();
                if (v == null) {
                    return null;
                }
                it = this.mapper.apply(v).iterator();
                if (!it.hasNext()) {
                    it = null;
                    continue;
                }
                this.current = it;
                break;
            }
            R r = it.next();
            if (!it.hasNext()) {
                this.current = null;
            }
            return r;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0 && this.fusionMode == 1) {
                return 1;
            }
            return 0;
        }
    }
}

