/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.Scheduler;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ReplayProcessor<T>
extends FlowableProcessor<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    final ReplayBuffer<T> buffer;
    boolean done;
    final AtomicReference<ReplaySubscription<T>[]> subscribers;
    static final ReplaySubscription[] EMPTY = new ReplaySubscription[0];
    static final ReplaySubscription[] TERMINATED = new ReplaySubscription[0];

    public static <T> ReplayProcessor<T> create() {
        return new ReplayProcessor(new UnboundedReplayBuffer(16));
    }

    public static <T> ReplayProcessor<T> create(int capacityHint) {
        return new ReplayProcessor(new UnboundedReplayBuffer(capacityHint));
    }

    public static <T> ReplayProcessor<T> createWithSize(int maxSize) {
        return new ReplayProcessor(new SizeBoundReplayBuffer(maxSize));
    }

    static <T> ReplayProcessor<T> createUnbounded() {
        return new ReplayProcessor(new SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    public static <T> ReplayProcessor<T> createWithTime(long maxAge, TimeUnit unit, Scheduler scheduler) {
        return new ReplayProcessor(new SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    public static <T> ReplayProcessor<T> createWithTimeAndSize(long maxAge, TimeUnit unit, Scheduler scheduler, int maxSize) {
        return new ReplayProcessor(new SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplayProcessor(ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.subscribers = new AtomicReference<ReplaySubscription[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        ReplaySubscription<? super T> rs = new ReplaySubscription<T>(s, this);
        s.onSubscribe(rs);
        if (!rs.cancelled) {
            if (this.add(rs) && rs.cancelled) {
                this.remove(rs);
                return;
            }
            this.buffer.replay(rs);
        }
    }

    public void onSubscribe(Subscription s) {
        if (this.done) {
            s.cancel();
            return;
        }
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        if (t == null) {
            this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
            return;
        }
        if (this.done) {
            return;
        }
        ReplayBuffer<T> b = this.buffer;
        b.add(t);
        for (ReplaySubscription<T> rs : this.subscribers.get()) {
            b.replay(rs);
        }
    }

    public void onError(Throwable t) {
        if (t == null) {
            t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        Object o = NotificationLite.error(t);
        ReplayBuffer<T> b = this.buffer;
        b.addFinal(o);
        for (ReplaySubscription<T> rs : this.terminate(o)) {
            b.replay(rs);
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        Object o = NotificationLite.complete();
        ReplayBuffer<T> b = this.buffer;
        b.addFinal(o);
        for (ReplaySubscription<T> rs : this.terminate(o)) {
            b.replay(rs);
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    public Throwable getThrowable() {
        Object o = this.buffer.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    public T getValue() {
        return this.buffer.getValue();
    }

    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    public T[] getValues(T[] array) {
        return this.buffer.getValues(array);
    }

    @Override
    public boolean hasComplete() {
        Object o = this.buffer.get();
        return NotificationLite.isComplete(o);
    }

    @Override
    public boolean hasThrowable() {
        Object o = this.buffer.get();
        return NotificationLite.isError(o);
    }

    public boolean hasValue() {
        return this.buffer.size() != 0;
    }

    int size() {
        return this.buffer.size();
    }

    boolean add(ReplaySubscription<T> rs) {
        ReplaySubscription[] b;
        ReplaySubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a.length;
            b = new ReplaySubscription[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(ReplaySubscription<T> rs) {
        ReplaySubscription[] b;
        ReplaySubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new ReplaySubscription[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    ReplaySubscription<T>[] terminate(Object terminalValue) {
        if (this.buffer.compareAndSet(null, terminalValue)) {
            return this.subscribers.getAndSet(TERMINATED);
        }
        return TERMINATED;
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 1242561386470847675L;
        final int maxSize;
        final long maxAge;
        final TimeUnit unit;
        final Scheduler scheduler;
        int size;
        volatile TimedNode<Object> head;
        TimedNode<Object> tail;
        volatile boolean done;

        SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
            this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
            this.maxAge = ObjectHelper.verifyPositive(maxAge, "maxAge");
            this.unit = ObjectHelper.requireNonNull(unit, "unit is null");
            this.scheduler = ObjectHelper.requireNonNull(scheduler, "scheduler is null");
            TimedNode<Object> h = new TimedNode<Object>(null, 0L);
            this.tail = h;
            this.head = h;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                TimedNode<Object> h = this.head;
                this.head = (TimedNode)h.get();
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h.get()) == null) {
                    this.head = h;
                    break;
                }
                if (next.time > limit) {
                    this.head = h;
                    break;
                }
                h = next;
            }
        }

        void trimFinal() {
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h.get()).get() == null) {
                    this.head = h;
                    break;
                }
                if (next.time > limit) {
                    this.head = h;
                    break;
                }
                h = next;
            }
        }

        @Override
        public void add(T value) {
            TimedNode<T> n = new TimedNode<T>(value, this.scheduler.now(this.unit));
            TimedNode<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            TimedNode<Object> n = new TimedNode<Object>(notificationLite, Long.MAX_VALUE);
            TimedNode<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trimFinal();
            this.done = true;
        }

        @Override
        public T getValue() {
            TimedNode next;
            TimedNode prev = null;
            TimedNode h = this.head;
            while ((next = (TimedNode)h.get()) != null) {
                prev = h;
                h = next;
            }
            Object v = h.value;
            if (v == null) {
                return null;
            }
            if (NotificationLite.isComplete(v) || NotificationLite.isError(v)) {
                return prev.value;
            }
            return v;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h = this.head;
            int s = this.size();
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
                }
                for (int i = 0; i != s; ++i) {
                    TimedNode next = (TimedNode)h.get();
                    array[i] = next.value;
                    h = next;
                }
                if (array.length > s) {
                    array[s] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = rs.actual;
            TimedNode index = (TimedNode)rs.index;
            if (index == null) {
                index = this.head;
                if (!this.done) {
                    long ts;
                    long limit = this.scheduler.now(this.unit) - this.maxAge;
                    TimedNode next = (TimedNode)index.get();
                    while (next != null && (ts = next.time) <= limit) {
                        index = next;
                        next = (TimedNode)index.get();
                    }
                }
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                long r = rs.requested.get();
                long e = 0L;
                while (true) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    TimedNode n = (TimedNode)index.get();
                    if (n == null) break;
                    Object o = n.value;
                    if (this.done && n.get() == null) {
                        if (NotificationLite.isComplete(o)) {
                            a.onComplete();
                        } else {
                            a.onError(NotificationLite.getError(o));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    if (r == 0L && (r = rs.requested.get() + e) == 0L) break;
                    a.onNext(o);
                    --r;
                    --e;
                    index = n;
                }
                if (e != 0L && rs.requested.get() != Long.MAX_VALUE) {
                    r = rs.requested.addAndGet(e);
                }
                if (index.get() != null && r != 0L) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s;
            TimedNode h = this.head;
            for (s = 0; s != Integer.MAX_VALUE; ++s) {
                TimedNode next = (TimedNode)h.get();
                if (next == null) {
                    Object o = h.value;
                    if (!NotificationLite.isComplete(o) && !NotificationLite.isError(o)) break;
                    --s;
                    break;
                }
                h = next;
            }
            return s;
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 3027920763113911982L;
        final int maxSize;
        int size;
        volatile Node<Object> head;
        Node<Object> tail;
        volatile boolean done;

        SizeBoundReplayBuffer(int maxSize) {
            this.maxSize = ObjectHelper.verifyPositive(maxSize, "maxSize");
            Node<Object> h = new Node<Object>(null);
            this.tail = h;
            this.head = h;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                Node<Object> h = this.head;
                this.head = (Node)h.get();
            }
        }

        @Override
        public void add(T value) {
            Node<T> n = new Node<T>(value);
            Node<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void addFinal(Object notificationLite) {
            Node<Object> n = new Node<Object>(notificationLite);
            Node<Object> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.done = true;
        }

        @Override
        public T getValue() {
            Node next;
            Node prev = null;
            Node h = this.head;
            while ((next = (Node)h.get()) != null) {
                prev = h;
                h = next;
            }
            Object v = h.value;
            if (v == null) {
                return null;
            }
            if (NotificationLite.isComplete(v) || NotificationLite.isError(v)) {
                return prev.value;
            }
            return v;
        }

        @Override
        public T[] getValues(T[] array) {
            Node h = this.head;
            int s = this.size();
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
                }
                for (int i = 0; i != s; ++i) {
                    Node next = (Node)h.get();
                    array[i] = next.value;
                    h = next;
                }
                if (array.length > s) {
                    array[s] = null;
                }
            }
            return array;
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = rs.actual;
            Node index = (Node)rs.index;
            if (index == null) {
                index = this.head;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                long r = rs.requested.get();
                long e = 0L;
                while (true) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    Node n = (Node)index.get();
                    if (n == null) break;
                    Object o = n.value;
                    if (this.done && n.get() == null) {
                        if (NotificationLite.isComplete(o)) {
                            a.onComplete();
                        } else {
                            a.onError(NotificationLite.getError(o));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    if (r == 0L && (r = rs.requested.get() + e) == 0L) break;
                    a.onNext(o);
                    --r;
                    --e;
                    index = n;
                }
                if (e != 0L && rs.requested.get() != Long.MAX_VALUE) {
                    r = rs.requested.addAndGet(e);
                }
                if (index.get() != null && r != 0L) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s;
            Node h = this.head;
            for (s = 0; s != Integer.MAX_VALUE; ++s) {
                Node next = (Node)h.get();
                if (next == null) {
                    Object o = h.value;
                    if (!NotificationLite.isComplete(o) && !NotificationLite.isError(o)) break;
                    --s;
                    break;
                }
                h = next;
            }
            return s;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        Node(T value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends AtomicReference<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = -4457200895834877300L;
        final List<Object> buffer;
        volatile boolean done;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            this.buffer = new ArrayList<Object>(ObjectHelper.verifyPositive(capacityHint, "capacityHint"));
        }

        @Override
        public void add(T value) {
            this.buffer.add(value);
            ++this.size;
        }

        @Override
        public void addFinal(Object notificationLite) {
            this.buffer.add(notificationLite);
            ++this.size;
            this.done = true;
        }

        @Override
        public T getValue() {
            int s = this.size;
            if (s != 0) {
                List<Object> b = this.buffer;
                Object o = b.get(s - 1);
                if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
                    if (s == 1) {
                        return null;
                    }
                    return (T)b.get(s - 2);
                }
                return (T)o;
            }
            return null;
        }

        @Override
        public T[] getValues(T[] array) {
            int s = this.size;
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            List<Object> b = this.buffer;
            Object o = b.get(s - 1);
            if ((NotificationLite.isComplete(o) || NotificationLite.isError(o)) && --s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            if (array.length < s) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
            }
            for (int i = 0; i < s; ++i) {
                array[i] = b.get(i);
            }
            if (array.length > s) {
                array[s] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            int index;
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<Object> b = this.buffer;
            Subscriber a = rs.actual;
            Integer indexObject = (Integer)rs.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs.index = 0;
            }
            while (true) {
                if (rs.cancelled) {
                    rs.index = null;
                    return;
                }
                int s = this.size;
                long r = rs.requested.get();
                long e = 0L;
                while (s != index) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    Object o = b.get(index);
                    if (this.done && index + 1 == s && index + 1 == (s = this.size)) {
                        if (NotificationLite.isComplete(o)) {
                            a.onComplete();
                        } else {
                            a.onError(NotificationLite.getError(o));
                        }
                        rs.index = null;
                        rs.cancelled = true;
                        return;
                    }
                    if (r == 0L && (r = rs.requested.get() + e) == 0L) break;
                    a.onNext(o);
                    --r;
                    --e;
                    ++index;
                }
                if (e != 0L && rs.requested.get() != Long.MAX_VALUE) {
                    r = rs.requested.addAndGet(e);
                }
                if (index != this.size && r != 0L) continue;
                rs.index = index;
                if ((missed = rs.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public int size() {
            int s = this.size;
            if (s != 0) {
                Object o = this.buffer.get(s - 1);
                if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
                    return s - 1;
                }
                return s;
            }
            return 0;
        }
    }

    static final class ReplaySubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 466549804534799122L;
        final Subscriber<? super T> actual;
        final ReplayProcessor<T> state;
        Object index;
        final AtomicLong requested;
        volatile boolean cancelled;

        ReplaySubscription(Subscriber<? super T> actual, ReplayProcessor<T> state) {
            this.actual = actual;
            this.state = state;
            this.requested = new AtomicLong();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.state.buffer.replay(this);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }
    }

    static interface ReplayBuffer<T> {
        public void add(T var1);

        public void addFinal(Object var1);

        public void replay(ReplaySubscription<T> var1);

        public int size();

        public T getValue();

        public T[] getValues(T[] var1);

        public Object get();

        public boolean compareAndSet(Object var1, Object var2);
    }
}

