/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.observers;

import io.reactivex.Notification;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class BaseTestConsumer<T, U extends BaseTestConsumer<T, U>>
implements Disposable {
    protected final CountDownLatch done;
    protected final List<T> values = new ArrayList<T>();
    protected final List<Throwable> errors = new ArrayList<Throwable>();
    protected long completions;
    protected Thread lastThread;
    protected boolean checkSubscriptionOnce;
    protected int initialFusionMode;
    protected int establishedFusionMode;

    public BaseTestConsumer() {
        this.done = new CountDownLatch(1);
    }

    public final Thread lastThread() {
        return this.lastThread;
    }

    public final List<T> values() {
        return this.values;
    }

    public final List<Throwable> errors() {
        return this.errors;
    }

    public final long completions() {
        return this.completions;
    }

    public final boolean isTerminated() {
        return this.done.getCount() == 0L;
    }

    public final int valueCount() {
        return this.values.size();
    }

    public final int errorCount() {
        return this.errors.size();
    }

    protected final AssertionError fail(String message) {
        StringBuilder b = new StringBuilder(64 + message.length());
        b.append(message);
        b.append(" (").append("latch = ").append(this.done.getCount()).append(", ").append("values = ").append(this.values.size()).append(", ").append("errors = ").append(this.errors.size()).append(", ").append("completions = ").append(this.completions).append(')');
        AssertionError ae = new AssertionError((Object)b.toString());
        if (!this.errors.isEmpty()) {
            if (this.errors.size() == 1) {
                ((Throwable)((Object)ae)).initCause(this.errors.get(0));
            } else {
                CompositeException ce = new CompositeException(this.errors);
                ((Throwable)((Object)ae)).initCause(ce);
            }
        }
        return ae;
    }

    public final U await() throws InterruptedException {
        if (this.done.getCount() == 0L) {
            return (U)this;
        }
        this.done.await();
        return (U)this;
    }

    public final boolean await(long time, TimeUnit unit) throws InterruptedException {
        return this.done.getCount() == 0L || this.done.await(time, unit);
    }

    public final U assertComplete() {
        long c = this.completions;
        if (c == 0L) {
            throw this.fail("Not completed");
        }
        if (c > 1L) {
            throw this.fail("Multiple completions: " + c);
        }
        return (U)this;
    }

    public final U assertNotComplete() {
        long c = this.completions;
        if (c == 1L) {
            throw this.fail("Completed!");
        }
        if (c > 1L) {
            throw this.fail("Multiple completions: " + c);
        }
        return (U)this;
    }

    public final U assertNoErrors() {
        int s = this.errors.size();
        if (s != 0) {
            throw this.fail("Error(s) present: " + this.errors);
        }
        return (U)this;
    }

    public final U assertError(Throwable error) {
        return this.assertError(Functions.equalsWith(error));
    }

    public final U assertError(Class<? extends Throwable> errorClass) {
        return this.assertError(Functions.isInstanceOf(errorClass));
    }

    public final U assertError(Predicate<Throwable> errorPredicate) {
        int s = this.errors.size();
        if (s == 0) {
            throw this.fail("No errors");
        }
        boolean found = false;
        for (Throwable e : this.errors) {
            try {
                if (!errorPredicate.test(e)) continue;
                found = true;
                break;
            }
            catch (Exception ex) {
                throw ExceptionHelper.wrapOrThrow(ex);
            }
        }
        if (found) {
            if (s != 1) {
                throw this.fail("Error present but other errors as well");
            }
        } else {
            throw this.fail("Error not present");
        }
        return (U)this;
    }

    public final U assertValue(T value) {
        int s = this.values.size();
        if (s != 1) {
            throw this.fail("Expected: " + BaseTestConsumer.valueAndClass(value) + ", Actual: " + this.values);
        }
        T v = this.values.get(0);
        if (!ObjectHelper.equals(value, v)) {
            throw this.fail("Expected: " + BaseTestConsumer.valueAndClass(value) + ", Actual: " + BaseTestConsumer.valueAndClass(v));
        }
        return (U)this;
    }

    public final U assertValue(Predicate<T> valuePredicate) {
        int s = this.values.size();
        if (s == 0) {
            throw this.fail("No values");
        }
        boolean found = false;
        try {
            if (valuePredicate.test(this.values.get(0))) {
                found = true;
            }
        }
        catch (Exception ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (found) {
            if (s != 1) {
                throw this.fail("Value present but other values as well");
            }
        } else {
            throw this.fail("Value not present");
        }
        return (U)this;
    }

    public static String valueAndClass(Object o) {
        if (o != null) {
            return o + " (class: " + o.getClass().getSimpleName() + ")";
        }
        return "null";
    }

    public final U assertValueCount(int count) {
        int s = this.values.size();
        if (s != count) {
            throw this.fail("Value counts differ; Expected: " + count + ", Actual: " + s);
        }
        return (U)this;
    }

    public final U assertNoValues() {
        return this.assertValueCount(0);
    }

    public final U assertValues(T ... values) {
        int s = this.values.size();
        if (s != values.length) {
            throw this.fail("Value count differs; Expected: " + values.length + " " + Arrays.toString(values) + ", Actual: " + s + " " + this.values);
        }
        for (int i = 0; i < s; ++i) {
            T u = values[i];
            T v = this.values.get(i);
            if (ObjectHelper.equals(u, v)) continue;
            throw this.fail("Values at position " + i + " differ; Expected: " + BaseTestConsumer.valueAndClass(u) + ", Actual: " + BaseTestConsumer.valueAndClass(v));
        }
        return (U)this;
    }

    public final U assertValueSet(Collection<? extends T> expected) {
        if (expected.isEmpty()) {
            this.assertNoValues();
            return (U)this;
        }
        for (T v : this.values) {
            if (expected.contains(v)) continue;
            throw this.fail("Value not in the expected collection: " + BaseTestConsumer.valueAndClass(v));
        }
        return (U)this;
    }

    public final U assertValueSequence(Iterable<? extends T> sequence) {
        boolean expectedNext;
        boolean actualNext;
        int i = 0;
        Iterator<T> vit = this.values.iterator();
        Iterator<T> it = sequence.iterator();
        while (true) {
            actualNext = it.hasNext();
            expectedNext = vit.hasNext();
            if (!actualNext || !expectedNext) break;
            T v = it.next();
            T u = vit.next();
            if (!ObjectHelper.equals(u, v)) {
                throw this.fail("Values at position " + i + " differ; Expected: " + BaseTestConsumer.valueAndClass(u) + ", Actual: " + BaseTestConsumer.valueAndClass(v));
            }
            ++i;
        }
        if (actualNext) {
            throw this.fail("More values received than expected (" + i + ")");
        }
        if (expectedNext) {
            throw this.fail("Fever values received than expected (" + i + ")");
        }
        return (U)this;
    }

    public final U assertTerminated() {
        if (this.done.getCount() != 0L) {
            throw this.fail("Subscriber still running!");
        }
        long c = this.completions;
        if (c > 1L) {
            throw this.fail("Terminated with multiple completions: " + c);
        }
        int s = this.errors.size();
        if (s > 1) {
            throw this.fail("Terminated with multiple errors: " + s);
        }
        if (c != 0L && s != 0) {
            throw this.fail("Terminated with multiple completions and errors: " + c);
        }
        return (U)this;
    }

    public final U assertNotTerminated() {
        if (this.done.getCount() == 0L) {
            throw this.fail("Subscriber terminated!");
        }
        return (U)this;
    }

    public final boolean awaitTerminalEvent() {
        try {
            this.await();
            return true;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final boolean awaitTerminalEvent(long duration, TimeUnit unit) {
        try {
            return this.await(duration, unit);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public final U assertErrorMessage(String message) {
        int s = this.errors.size();
        if (s == 0) {
            throw this.fail("No errors");
        }
        if (s == 1) {
            Throwable e = this.errors.get(0);
            String errorMessage = e.getMessage();
            if (!ObjectHelper.equals(message, errorMessage)) {
                throw this.fail("Error message differs; Expected: " + message + ", Actual: " + errorMessage);
            }
        } else {
            throw this.fail("Multiple errors");
        }
        return (U)this;
    }

    public final List<List<Object>> getEvents() {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        result.add(this.values());
        result.add(this.errors());
        ArrayList completeList = new ArrayList();
        for (long i = 0L; i < this.completions; ++i) {
            completeList.add(Notification.createOnComplete());
        }
        result.add(completeList);
        return result;
    }

    public abstract U assertSubscribed();

    public abstract U assertNotSubscribed();

    public final U assertResult(T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertNoErrors()).assertComplete();
    }

    public final U assertFailure(Class<? extends Throwable> error, T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertError(error)).assertNotComplete();
    }

    public final U assertFailure(Predicate<Throwable> errorPredicate, T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertError(errorPredicate)).assertNotComplete();
    }

    public final U assertFailureAndMessage(Class<? extends Throwable> error, String message, T ... values) {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertValues(values)).assertError(error)).assertErrorMessage(message)).assertNotComplete();
    }

    public final U awaitDone(long time, TimeUnit unit) {
        try {
            if (!this.done.await(time, unit)) {
                this.dispose();
            }
        }
        catch (InterruptedException ex) {
            this.dispose();
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return (U)this;
    }

    public final U assertEmpty() {
        return ((BaseTestConsumer)((BaseTestConsumer)((BaseTestConsumer)this.assertSubscribed()).assertNoValues()).assertNoErrors()).assertNotComplete();
    }
}

