/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.internal.disposables.DisposableContainer;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.schedulers.ScheduledRunnable;
import io.reactivex.internal.schedulers.SchedulerPoolFactory;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class NewThreadWorker
extends Scheduler.Worker
implements Disposable {
    private final ScheduledExecutorService executor;
    volatile boolean disposed;

    public NewThreadWorker(ThreadFactory threadFactory) {
        this.executor = SchedulerPoolFactory.create(threadFactory);
    }

    @Override
    public Disposable schedule(Runnable run) {
        return this.schedule(run, 0L, null);
    }

    @Override
    public Disposable schedule(Runnable action, long delayTime, TimeUnit unit) {
        if (this.disposed) {
            return EmptyDisposable.INSTANCE;
        }
        return this.scheduleActual(action, delayTime, unit, null);
    }

    public Disposable scheduleDirect(Runnable run, long delayTime, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        try {
            Future<?> f = delayTime <= 0L ? this.executor.submit(decoratedRun) : this.executor.schedule(decoratedRun, delayTime, unit);
            return Disposables.fromFuture(f);
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    public Disposable schedulePeriodicallyDirect(Runnable run, long initialDelay, long period, TimeUnit unit) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        try {
            ScheduledFuture<?> f = this.executor.scheduleAtFixedRate(decoratedRun, initialDelay, period, unit);
            return Disposables.fromFuture(f);
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
            return EmptyDisposable.INSTANCE;
        }
    }

    public ScheduledRunnable scheduleActual(Runnable run, long delayTime, TimeUnit unit, DisposableContainer parent) {
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        ScheduledRunnable sr = new ScheduledRunnable(decoratedRun, parent);
        if (parent != null && !parent.add(sr)) {
            return sr;
        }
        try {
            Future<Object> f = delayTime <= 0L ? this.executor.submit(sr) : this.executor.schedule(sr, delayTime, unit);
            sr.setFuture(f);
        }
        catch (RejectedExecutionException ex) {
            RxJavaPlugins.onError(ex);
        }
        return sr;
    }

    @Override
    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.executor.shutdownNow();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }
}

