/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;

public final class SingleObserveOn<T>
extends Single<T> {
    final SingleSource<T> source;
    final Scheduler scheduler;

    public SingleObserveOn(SingleSource<T> source, Scheduler scheduler) {
        this.source = source;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        final CompositeDisposable mad = new CompositeDisposable();
        s.onSubscribe(mad);
        this.source.subscribe(new SingleObserver<T>(){

            @Override
            public void onError(final Throwable e) {
                mad.add(SingleObserveOn.this.scheduler.scheduleDirect(new Runnable(){

                    @Override
                    public void run() {
                        s.onError(e);
                    }
                }));
            }

            @Override
            public void onSubscribe(Disposable d) {
                mad.add(d);
            }

            @Override
            public void onSuccess(final T value) {
                mad.add(SingleObserveOn.this.scheduler.scheduleDirect(new Runnable(){

                    @Override
                    public void run() {
                        s.onSuccess(value);
                    }
                }));
            }
        });
    }
}

