/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.operators.observable.ObservableMap;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.HalfSerializer;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class ObservableWithLatestFromMany<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final ObservableSource<?>[] otherArray;
    final Iterable<? extends ObservableSource<?>> otherIterable;
    final Function<? super Object[], R> combiner;

    public ObservableWithLatestFromMany(ObservableSource<T> source, ObservableSource<?>[] otherArray, Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = otherArray;
        this.otherIterable = null;
        this.combiner = combiner;
    }

    public ObservableWithLatestFromMany(ObservableSource<T> source, Iterable<? extends ObservableSource<?>> otherIterable, Function<? super Object[], R> combiner) {
        super(source);
        this.otherArray = null;
        this.otherIterable = otherIterable;
        this.combiner = combiner;
    }

    @Override
    protected void subscribeActual(Observer<? super R> s) {
        ObservableSource<?>[] others = this.otherArray;
        int n = 0;
        if (others == null) {
            others = new ObservableSource[8];
            try {
                for (ObservableSource<?> p : this.otherIterable) {
                    if (n == others.length) {
                        others = Arrays.copyOf(others, n + (n >> 1));
                    }
                    others[n++] = p;
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error(ex, s);
                return;
            }
        } else {
            n = others.length;
        }
        if (n == 0) {
            new ObservableMap(this.source, new Function<T, R>(){

                @Override
                public R apply(T t) throws Exception {
                    return ObservableWithLatestFromMany.this.combiner.apply((Object[])new Object[]{t});
                }
            }).subscribeActual(s);
            return;
        }
        WithLatestFromObserver parent = new WithLatestFromObserver(s, this.combiner, n);
        s.onSubscribe(parent);
        parent.subscribe(others, n);
        this.source.subscribe(parent);
    }

    static final class WithLatestInnerObserver
    extends AtomicReference<Disposable>
    implements Observer<Object>,
    Disposable {
        private static final long serialVersionUID = 3256684027868224024L;
        final WithLatestFromObserver<?, ?> parent;
        final int index;
        boolean hasValue;

        WithLatestInnerObserver(WithLatestFromObserver<?, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onNext(Object t) {
            if (!this.hasValue) {
                this.hasValue = true;
            }
            this.parent.innerNext(this.index, t);
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerError(this.index, t);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index, this.hasValue);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class WithLatestFromObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 1577321883966341961L;
        final Observer<? super R> actual;
        final Function<? super Object[], R> combiner;
        final WithLatestInnerObserver[] observers;
        final AtomicReferenceArray<Object> values;
        final AtomicReference<Disposable> d;
        final AtomicThrowable error;
        volatile boolean done;

        WithLatestFromObserver(Observer<? super R> actual, Function<? super Object[], R> combiner, int n) {
            this.actual = actual;
            this.combiner = combiner;
            WithLatestInnerObserver[] s = new WithLatestInnerObserver[n];
            for (int i = 0; i < n; ++i) {
                s[i] = new WithLatestInnerObserver(this, i);
            }
            this.observers = s;
            this.values = new AtomicReferenceArray(n);
            this.d = new AtomicReference();
            this.error = new AtomicThrowable();
        }

        void subscribe(ObservableSource<?>[] others, int n) {
            WithLatestInnerObserver[] observers = this.observers;
            AtomicReference<Disposable> s = this.d;
            for (int i = 0; i < n; ++i) {
                if (DisposableHelper.isDisposed(s.get()) || this.done) {
                    return;
                }
                others[i].subscribe(observers[i]);
            }
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this.d, d);
        }

        @Override
        public void onNext(T t) {
            R v;
            if (this.done) {
                return;
            }
            AtomicReferenceArray<Object> ara = this.values;
            int n = ara.length();
            Object[] objects = new Object[n + 1];
            objects[0] = t;
            for (int i = 0; i < n; ++i) {
                Object o = ara.get(i);
                if (o == null) {
                    return;
                }
                objects[i + 1] = o;
            }
            try {
                v = ObjectHelper.requireNonNull(this.combiner.apply((Object[])objects), "combiner returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.dispose();
                this.onError(ex);
                return;
            }
            HalfSerializer.onNext(this.actual, v, (AtomicInteger)this, this.error);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.cancelAllBut(-1);
            HalfSerializer.onError(this.actual, t, (AtomicInteger)this, this.error);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.cancelAllBut(-1);
                HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
            }
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed(this.d.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.d);
            for (WithLatestInnerObserver s : this.observers) {
                s.dispose();
            }
        }

        void innerNext(int index, Object o) {
            this.values.set(index, o);
        }

        void innerError(int index, Throwable t) {
            this.done = true;
            DisposableHelper.dispose(this.d);
            this.cancelAllBut(index);
            HalfSerializer.onError(this.actual, t, (AtomicInteger)this, this.error);
        }

        void innerComplete(int index, boolean nonEmpty) {
            if (!nonEmpty) {
                this.done = true;
                this.cancelAllBut(index);
                HalfSerializer.onComplete(this.actual, (AtomicInteger)this, this.error);
            }
        }

        void cancelAllBut(int index) {
            WithLatestInnerObserver[] observers = this.observers;
            for (int i = 0; i < observers.length; ++i) {
                if (i == index) continue;
                observers[i].dispose();
            }
        }
    }
}

