/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.observers.QueueDrainObserver;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.subjects.UnicastSubject;
import java.nio.channels.CancelledKeyException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWindowTimed<T>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final long maxSize;
    final int bufferSize;
    final boolean restartTimerOnMaxSize;

    public ObservableWindowTimed(ObservableSource<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, long maxSize, int bufferSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.maxSize = maxSize;
        this.bufferSize = bufferSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    public void subscribeActual(Observer<? super Observable<T>> t) {
        SerializedObserver<? super Observable<T>> actual = new SerializedObserver<Observable<T>>(t);
        if (this.timespan == this.timeskip) {
            if (this.maxSize == Long.MAX_VALUE) {
                this.source.subscribe(new WindowExactUnboundedObserver(actual, this.timespan, this.unit, this.scheduler, this.bufferSize));
                return;
            }
            this.source.subscribe(new WindowExactBoundedObserver(actual, this.timespan, this.unit, this.scheduler, this.bufferSize, this.maxSize, this.restartTimerOnMaxSize));
            return;
        }
        this.source.subscribe(new WindowSkipObserver(actual, this.timespan, this.timeskip, this.unit, this.scheduler.createWorker(), this.bufferSize));
    }

    static final class WindowSkipObserver<T>
    extends QueueDrainObserver<T, Object, Observable<T>>
    implements Disposable,
    Runnable {
        final long timespan;
        final long timeskip;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final int bufferSize;
        final List<UnicastSubject<T>> windows;
        Disposable s;
        volatile boolean terminated;

        WindowSkipObserver(Observer<? super Observable<T>> actual, long timespan, long timeskip, TimeUnit unit, Scheduler.Worker worker, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.timespan = timespan;
            this.timeskip = timeskip;
            this.unit = unit;
            this.worker = worker;
            this.bufferSize = bufferSize;
            this.windows = new LinkedList<UnicastSubject<T>>();
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                if (this.cancelled) {
                    return;
                }
                final UnicastSubject w = UnicastSubject.create(this.bufferSize);
                this.windows.add(w);
                this.actual.onNext(w);
                this.worker.schedule(new Runnable(){

                    @Override
                    public void run() {
                        WindowSkipObserver.this.complete(w);
                    }
                }, this.timespan, this.unit);
                this.worker.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.fastEnter()) {
                for (UnicastSubject<T> w : this.windows) {
                    w.onNext(t);
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.disposeWorker();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.disposeWorker();
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeWorker() {
            this.worker.dispose();
        }

        @Override
        public void accept(Observer<? super Observable<T>> a, Object v) {
        }

        void complete(UnicastSubject<T> w) {
            this.queue.offer(new SubjectWork<T>(w, false));
            if (this.enter()) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            SimpleQueue q = this.queue;
            Observer a = this.actual;
            List<UnicastSubject<T>> ws = this.windows;
            int missed = 1;
            block2: while (true) {
                Object v;
                if (this.terminated) {
                    this.s.dispose();
                    this.disposeWorker();
                    q.clear();
                    ws.clear();
                    return;
                }
                boolean d = this.done;
                try {
                    v = q.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.disposeWorker();
                    for (UnicastSubject<T> w : ws) {
                        w.onError(ex);
                    }
                    return;
                }
                boolean empty = v == null;
                boolean sw = v instanceof SubjectWork;
                if (d && (empty || sw)) {
                    q.clear();
                    this.disposeWorker();
                    Throwable e = this.error;
                    if (e != null) {
                        for (UnicastSubject<T> w : ws) {
                            w.onError(e);
                        }
                    } else {
                        for (UnicastSubject<T> w : ws) {
                            w.onComplete();
                        }
                    }
                    ws.clear();
                    return;
                }
                if (!empty) {
                    UnicastSubject w;
                    if (sw) {
                        SubjectWork work = (SubjectWork)v;
                        if (work.open) {
                            if (this.cancelled) continue;
                            w = UnicastSubject.create(this.bufferSize);
                            ws.add(w);
                            a.onNext(w);
                            this.worker.schedule(new Runnable(){

                                @Override
                                public void run() {
                                    WindowSkipObserver.this.complete(w);
                                }
                            }, this.timespan, this.unit);
                        } else {
                            ws.remove(work.w);
                            work.w.onComplete();
                            if (!ws.isEmpty() || !this.cancelled) continue;
                            this.terminated = true;
                            continue;
                        }
                    }
                    Iterator<UnicastSubject<T>> i$ = ws.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block2;
                        w = i$.next();
                        w.onNext(NotificationLite.getValue(v));
                    }
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        @Override
        public void run() {
            UnicastSubject w = UnicastSubject.create(this.bufferSize);
            SubjectWork sw = new SubjectWork(w, true);
            if (!this.cancelled) {
                this.queue.offer(sw);
            }
            if (this.enter()) {
                this.drainLoop();
            }
        }

        static final class SubjectWork<T> {
            final UnicastSubject<T> w;
            final boolean open;

            SubjectWork(UnicastSubject<T> w, boolean open) {
                this.w = w;
                this.open = open;
            }
        }
    }

    static final class WindowExactBoundedObserver<T>
    extends QueueDrainObserver<T, Object, Observable<T>>
    implements Disposable {
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        final int bufferSize;
        final boolean restartTimerOnMaxSize;
        final long maxSize;
        boolean selfCancel;
        long count;
        long producerIndex;
        Disposable s;
        UnicastSubject<T> window;
        Scheduler.Worker worker;
        volatile boolean terminated;
        final AtomicReference<Disposable> timer = new AtomicReference();

        WindowExactBoundedObserver(Observer<? super Observable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize, long maxSize, boolean restartTimerOnMaxSize) {
            super(actual, new MpscLinkedQueue());
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
            this.bufferSize = bufferSize;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartTimerOnMaxSize;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                Disposable d;
                this.s = s;
                Observer a = this.actual;
                a.onSubscribe(this);
                if (this.cancelled) {
                    return;
                }
                UnicastSubject w = UnicastSubject.create(this.bufferSize);
                this.window = w;
                a.onNext(w);
                ConsumerIndexHolder consumerIndexHolder = new ConsumerIndexHolder(this.producerIndex, this);
                if (this.restartTimerOnMaxSize) {
                    Scheduler.Worker sw = this.scheduler.createWorker();
                    sw.schedulePeriodically(consumerIndexHolder, this.timespan, this.timespan, this.unit);
                    d = sw;
                } else {
                    d = this.scheduler.schedulePeriodicallyDirect(consumerIndexHolder, this.timespan, this.timespan, this.unit);
                }
                if (!this.timer.compareAndSet(null, d)) {
                    d.dispose();
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (this.terminated) {
                return;
            }
            if (this.fastEnter()) {
                UnicastSubject<T> w = this.window;
                w.onNext(t);
                long c = this.count + 1L;
                if (c >= this.maxSize) {
                    ++this.producerIndex;
                    this.count = 0L;
                    w.onComplete();
                    w = UnicastSubject.create(this.bufferSize);
                    this.window = w;
                    this.actual.onNext(w);
                    if (this.restartTimerOnMaxSize) {
                        Disposable tm = this.timer.get();
                        tm.dispose();
                        Disposable task = this.worker.schedulePeriodically(new ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                        if (!this.timer.compareAndSet(tm, task)) {
                            task.dispose();
                        }
                    }
                } else {
                    this.count = c;
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.disposeTimer();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.disposeTimer();
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeTimer() {
            this.selfCancel = true;
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void accept(Observer<? super Observable<T>> a, Object v) {
        }

        void drainLoop() {
            SimpleQueue q = this.queue;
            Observer a = this.actual;
            UnicastSubject w = this.window;
            int missed = 1;
            while (true) {
                Object o;
                if (this.terminated) {
                    this.s.dispose();
                    q.clear();
                    this.disposeTimer();
                    return;
                }
                boolean d = this.done;
                try {
                    o = q.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.disposeTimer();
                    w.onError(ex);
                    return;
                }
                boolean empty = o == null;
                boolean isHolder = o instanceof ConsumerIndexHolder;
                if (d && (empty || isHolder)) {
                    this.window = null;
                    q.clear();
                    this.disposeTimer();
                    Throwable err = this.error;
                    if (err != null) {
                        w.onError(err);
                    } else {
                        w.onComplete();
                    }
                    return;
                }
                if (!empty) {
                    if (isHolder) {
                        ConsumerIndexHolder consumerIndexHolder = (ConsumerIndexHolder)o;
                        if (this.producerIndex != consumerIndexHolder.index) continue;
                        w = UnicastSubject.create(this.bufferSize);
                        this.window = w;
                        a.onNext(w);
                        continue;
                    }
                    w.onNext(NotificationLite.getValue(o));
                    long c = this.count + 1L;
                    if (c >= this.maxSize) {
                        ++this.producerIndex;
                        this.count = 0L;
                        w.onComplete();
                        w = UnicastSubject.create(this.bufferSize);
                        this.window = w;
                        this.actual.onNext(w);
                        if (!this.restartTimerOnMaxSize) continue;
                        Disposable tm = this.timer.get();
                        tm.dispose();
                        Disposable task = this.worker.schedulePeriodically(new ConsumerIndexHolder(this.producerIndex, this), this.timespan, this.timespan, this.unit);
                        if (this.timer.compareAndSet(tm, task)) continue;
                        task.dispose();
                        continue;
                    }
                    this.count = c;
                    continue;
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        static final class ConsumerIndexHolder
        implements Runnable {
            final long index;
            final WindowExactBoundedObserver<?> parent;

            ConsumerIndexHolder(long index, WindowExactBoundedObserver<?> parent) {
                this.index = index;
                this.parent = parent;
            }

            @Override
            public void run() {
                WindowExactBoundedObserver<?> p = this.parent;
                if (p.selfCancel) {
                    throw new CancelledKeyException();
                }
                if (!((WindowExactBoundedObserver)p).cancelled) {
                    ((WindowExactBoundedObserver)p).queue.offer(this);
                } else {
                    p.terminated = true;
                    p.disposeTimer();
                }
                if (p.enter()) {
                    p.drainLoop();
                }
            }
        }
    }

    static final class WindowExactUnboundedObserver<T>
    extends QueueDrainObserver<T, Object, Observable<T>>
    implements Observer<T>,
    Disposable,
    Runnable {
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        final int bufferSize;
        Disposable s;
        boolean selfCancel;
        UnicastSubject<T> window;
        final AtomicReference<Disposable> timer = new AtomicReference();
        static final Object NEXT = new Object();
        volatile boolean terminated;

        WindowExactUnboundedObserver(Observer<? super Observable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize) {
            super(actual, new MpscLinkedQueue());
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                Disposable d;
                this.s = s;
                this.window = UnicastSubject.create(this.bufferSize);
                Observer a = this.actual;
                a.onSubscribe(this);
                a.onNext(this.window);
                if (!this.cancelled && !this.timer.compareAndSet(null, d = this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit))) {
                    d.dispose();
                }
            }
        }

        @Override
        public void onNext(T t) {
            if (this.terminated) {
                return;
            }
            if (this.fastEnter()) {
                this.window.onNext(t);
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                this.queue.offer(NotificationLite.next(t));
                if (!this.enter()) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.disposeTimer();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.enter()) {
                this.drainLoop();
            }
            this.disposeTimer();
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeTimer() {
            this.selfCancel = true;
            DisposableHelper.dispose(this.timer);
        }

        @Override
        public void run() {
            if (this.selfCancel) {
                throw new CancelledKeyException();
            }
            if (this.cancelled) {
                this.terminated = true;
                this.disposeTimer();
            }
            this.queue.offer(NEXT);
            if (this.enter()) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            SimpleQueue q = this.queue;
            Observer a = this.actual;
            UnicastSubject w = this.window;
            int missed = 1;
            while (true) {
                Object o;
                boolean term = this.terminated;
                boolean d = this.done;
                try {
                    o = q.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.disposeTimer();
                    w.onError(ex);
                    return;
                }
                if (d && (o == null || o == NEXT)) {
                    this.window = null;
                    q.clear();
                    this.disposeTimer();
                    Throwable err = this.error;
                    if (err != null) {
                        w.onError(err);
                    } else {
                        w.onComplete();
                    }
                    return;
                }
                if (o != null) {
                    if (o == NEXT) {
                        w.onComplete();
                        if (!term) {
                            w = UnicastSubject.create(this.bufferSize);
                            this.window = w;
                            a.onNext(w);
                            continue;
                        }
                        this.s.dispose();
                        continue;
                    }
                    w.onNext(NotificationLite.getValue(o));
                    continue;
                }
                if ((missed = this.leave(-missed)) == 0) break;
            }
        }

        @Override
        public void accept(Observer<? super Observable<T>> a, Object v) {
        }
    }
}

