/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.schedulers.TrampolineScheduler;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableObserveOn<T>
extends AbstractObservableWithUpstream<T, T> {
    final Scheduler scheduler;
    final boolean delayError;
    final int bufferSize;

    public ObservableObserveOn(ObservableSource<T> source, Scheduler scheduler, boolean delayError, int bufferSize) {
        super(source);
        this.scheduler = scheduler;
        this.delayError = delayError;
        this.bufferSize = bufferSize;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        if (this.scheduler instanceof TrampolineScheduler) {
            this.source.subscribe(observer);
        } else {
            Scheduler.Worker w = this.scheduler.createWorker();
            this.source.subscribe(new ObserveOnObserver<T>(observer, w, this.delayError, this.bufferSize));
        }
    }

    static final class ObserveOnObserver<T>
    extends Padding0
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 6576896619930983584L;
        final Observer<? super T> actual;
        final Scheduler.Worker worker;
        final boolean delayError;
        final SpscLinkedArrayQueue<T> queue;
        Disposable s;
        Throwable error;
        volatile boolean done;
        volatile boolean cancelled;

        ObserveOnObserver(Observer<? super T> actual, Scheduler.Worker worker, boolean delayError, int bufferSize) {
            this.actual = actual;
            this.worker = worker;
            this.delayError = delayError;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (!this.queue.offer(t)) {
                this.s.dispose();
                this.onError(new MissingBackpressureException("Queue full?!"));
                return;
            }
            this.schedule();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.schedule();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.schedule();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.dispose();
                this.worker.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule(this);
            }
        }

        @Override
        public void run() {
            int missed = 1;
            SpscLinkedArrayQueue<T> q = this.queue;
            Observer<T> a = this.actual;
            block0: do {
                if (this.checkTerminated(this.done, q.isEmpty(), a)) {
                    return;
                }
                while (true) {
                    boolean empty;
                    boolean d = this.done;
                    T v = q.poll();
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) continue block0;
                    a.onNext(v);
                }
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Observer<? super T> a) {
            if (this.cancelled) {
                this.s.dispose();
                this.worker.dispose();
                return true;
            }
            if (d) {
                Throwable e = this.error;
                if (this.delayError) {
                    if (empty) {
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        this.worker.dispose();
                        return true;
                    }
                } else {
                    if (e != null) {
                        a.onError(e);
                        this.worker.dispose();
                        return true;
                    }
                    if (empty) {
                        a.onComplete();
                        this.worker.dispose();
                        return true;
                    }
                }
            }
            return false;
        }
    }

    static class Padding0
    extends AtomicInteger {
        private static final long serialVersionUID = 3172843496016154809L;
        volatile long p01;
        volatile long p02;
        volatile long p03;
        volatile long p04;
        volatile long p05;
        volatile long p06;
        volatile long p07;
        volatile long p08;
        volatile long p09;
        volatile long p0A;
        volatile long p0B;
        volatile long p0C;
        volatile long p0D;
        volatile long p0E;
        volatile long p0F;

        Padding0() {
        }
    }
}

