/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.NoSuchElementException;

public final class ObservableLastSingle<T>
extends Single<T> {
    final ObservableSource<T> source;
    final T defaultItem;

    public ObservableLastSingle(ObservableSource<T> source, T defaultItem) {
        this.source = source;
        this.defaultItem = defaultItem;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new LastObserver<T>(observer, this.defaultItem));
    }

    static final class LastObserver<T>
    implements Observer<T>,
    Disposable {
        final SingleObserver<? super T> actual;
        final T defaultItem;
        Disposable s;
        T item;

        LastObserver(SingleObserver<? super T> actual, T defaultItem) {
            this.actual = actual;
            this.defaultItem = defaultItem;
        }

        @Override
        public void dispose() {
            this.s.dispose();
            this.s = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.s == DisposableHelper.DISPOSED;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.item = t;
        }

        @Override
        public void onError(Throwable t) {
            this.s = DisposableHelper.DISPOSED;
            this.item = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.s = DisposableHelper.DISPOSED;
            T v = this.item;
            if (v != null) {
                this.item = null;
                this.actual.onSuccess(v);
            } else {
                v = this.defaultItem;
                if (v == null) {
                    this.actual.onError(new NoSuchElementException());
                } else {
                    this.actual.onSuccess(v);
                }
            }
        }
    }
}

