/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueDisposable;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.observers.InnerQueuedObserver;
import io.reactivex.internal.observers.InnerQueuedObserverSupport;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableConcatMapEager<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
    final ErrorMode errorMode;
    final int maxConcurrency;
    final int prefetch;

    public ObservableConcatMapEager(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends R>> mapper, ErrorMode errorMode, int maxConcurrency, int prefetch) {
        super(source);
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new ConcatMapEagerMainObserver<T, R>(observer, this.mapper, this.maxConcurrency, this.prefetch, this.errorMode));
    }

    static final class ConcatMapEagerMainObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    InnerQueuedObserverSupport<R> {
        private static final long serialVersionUID = 8080567949447303262L;
        final Observer<? super R> actual;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final int maxConcurrency;
        final int prefetch;
        final ErrorMode errorMode;
        final AtomicThrowable error;
        final ArrayDeque<InnerQueuedObserver<R>> observers;
        SimpleQueue<T> queue;
        Disposable d;
        volatile boolean done;
        int sourceMode;
        volatile boolean cancelled;
        InnerQueuedObserver<R> current;
        int activeCount;

        ConcatMapEagerMainObserver(Observer<? super R> actual, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int maxConcurrency, int prefetch, ErrorMode errorMode) {
            this.actual = actual;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.prefetch = prefetch;
            this.errorMode = errorMode;
            this.error = new AtomicThrowable();
            this.observers = new ArrayDeque();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                if (d instanceof QueueDisposable) {
                    QueueDisposable qd = (QueueDisposable)d;
                    int m = qd.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qd;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qd;
                        this.actual.onSubscribe(this);
                        return;
                    }
                }
                this.queue = QueueDrainHelper.createQueue(this.prefetch);
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            if (this.sourceMode == 0) {
                this.queue.offer(value);
            }
            this.drain();
        }

        @Override
        public void onError(Throwable e) {
            if (this.error.addThrowable(e)) {
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
                this.disposeAll();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeAll() {
            InnerQueuedObserver<R> inner = this.current;
            if (inner != null) {
                inner.dispose();
            }
            while (true) {
                try {
                    inner = this.observers.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    throw ExceptionHelper.wrapOrThrow(ex);
                }
                if (inner == null) {
                    return;
                }
                inner.dispose();
            }
        }

        @Override
        public void innerNext(InnerQueuedObserver<R> inner, R value) {
            inner.queue().offer(value);
            this.drain();
        }

        @Override
        public void innerError(InnerQueuedObserver<R> inner, Throwable e) {
            if (this.error.addThrowable(e)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.d.dispose();
                }
                inner.setDone();
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void innerComplete(InnerQueuedObserver<R> inner) {
            inner.setDone();
            this.drain();
        }

        @Override
        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimpleQueue<T> q = this.queue;
            ArrayDeque<InnerQueuedObserver<R>> observers = this.observers;
            Observer<R> a = this.actual;
            ErrorMode errorMode = this.errorMode;
            block6: while (true) {
                Throwable ex;
                Throwable ex2;
                int ac = --this.activeCount;
                while (ac != this.maxConcurrency) {
                    ObservableSource<R> source;
                    if (this.cancelled) {
                        q.clear();
                        this.disposeAll();
                        return;
                    }
                    if (errorMode == ErrorMode.IMMEDIATE && (ex2 = (Throwable)this.error.get()) != null) {
                        q.clear();
                        this.disposeAll();
                        a.onError(this.error.terminate());
                        return;
                    }
                    try {
                        T v = q.poll();
                        if (v == null) break;
                        source = ObjectHelper.requireNonNull(this.mapper.apply(v), "The mapper returned a null ObservableSource");
                    }
                    catch (Throwable ex3) {
                        Exceptions.throwIfFatal(ex3);
                        this.d.dispose();
                        q.clear();
                        this.disposeAll();
                        this.error.addThrowable(ex3);
                        a.onError(this.error.terminate());
                        return;
                    }
                    if (source instanceof Callable) {
                        Object w;
                        try {
                            w = ((Callable)((Object)source)).call();
                        }
                        catch (Throwable ex4) {
                            Exceptions.throwIfFatal(ex4);
                            this.error.addThrowable(ex4);
                            continue;
                        }
                        if (w == null) continue;
                        a.onNext(w);
                        continue;
                    }
                    InnerQueuedObserver inner = new InnerQueuedObserver(this, this.prefetch);
                    observers.offer(inner);
                    source.subscribe(inner);
                    ++ac;
                }
                this.activeCount = ac;
                if (this.cancelled) {
                    q.clear();
                    this.disposeAll();
                    return;
                }
                if (errorMode == ErrorMode.IMMEDIATE && (ex2 = (Throwable)this.error.get()) != null) {
                    q.clear();
                    this.disposeAll();
                    a.onError(this.error.terminate());
                    return;
                }
                InnerQueuedObserver<R> active = this.current;
                if (active == null) {
                    boolean empty;
                    Throwable ex5;
                    if (errorMode == ErrorMode.BOUNDARY && (ex5 = (Throwable)this.error.get()) != null) {
                        q.clear();
                        this.disposeAll();
                        a.onError(this.error.terminate());
                        return;
                    }
                    boolean d = this.done;
                    active = observers.poll();
                    boolean bl = empty = active == null;
                    if (d && empty) {
                        ex = (Throwable)this.error.get();
                        if (ex != null) {
                            q.clear();
                            this.disposeAll();
                            a.onError(this.error.terminate());
                        } else {
                            a.onComplete();
                        }
                        return;
                    }
                    if (!empty) {
                        this.current = active;
                    }
                }
                if (active != null) {
                    SimpleQueue<R> aq = active.queue();
                    while (true) {
                        boolean empty;
                        R w;
                        if (this.cancelled) {
                            q.clear();
                            this.disposeAll();
                            return;
                        }
                        boolean d = active.isDone();
                        if (errorMode == ErrorMode.IMMEDIATE && (ex = (Throwable)this.error.get()) != null) {
                            q.clear();
                            this.disposeAll();
                            a.onError(this.error.terminate());
                            return;
                        }
                        try {
                            w = aq.poll();
                        }
                        catch (Throwable ex6) {
                            Exceptions.throwIfFatal(ex6);
                            this.error.addThrowable(ex6);
                            this.current = null;
                            active = null;
                            continue block6;
                        }
                        boolean bl = empty = w == null;
                        if (d && empty) {
                            this.current = null;
                            active = null;
                            --this.activeCount;
                            continue block6;
                        }
                        if (empty) break;
                        a.onNext(w);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

