/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex;

import io.reactivex.BackpressureOverflowStrategy;
import io.reactivex.Completable;
import io.reactivex.Emitter;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.FlowableOperator;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.Notification;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.annotations.BackpressureKind;
import io.reactivex.annotations.BackpressureSupport;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.flowables.GroupedFlowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.BiPredicate;
import io.reactivex.functions.BooleanSupplier;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function3;
import io.reactivex.functions.Function4;
import io.reactivex.functions.Function5;
import io.reactivex.functions.Function6;
import io.reactivex.functions.Function7;
import io.reactivex.functions.Function8;
import io.reactivex.functions.Function9;
import io.reactivex.functions.LongConsumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.functions.Functions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.ScalarCallable;
import io.reactivex.internal.operators.flowable.BlockingFlowableIterable;
import io.reactivex.internal.operators.flowable.BlockingFlowableLatest;
import io.reactivex.internal.operators.flowable.BlockingFlowableMostRecent;
import io.reactivex.internal.operators.flowable.BlockingFlowableNext;
import io.reactivex.internal.operators.flowable.FlowableAllSingle;
import io.reactivex.internal.operators.flowable.FlowableAmb;
import io.reactivex.internal.operators.flowable.FlowableAnySingle;
import io.reactivex.internal.operators.flowable.FlowableBlockingSubscribe;
import io.reactivex.internal.operators.flowable.FlowableBuffer;
import io.reactivex.internal.operators.flowable.FlowableBufferBoundary;
import io.reactivex.internal.operators.flowable.FlowableBufferBoundarySupplier;
import io.reactivex.internal.operators.flowable.FlowableBufferExactBoundary;
import io.reactivex.internal.operators.flowable.FlowableBufferTimed;
import io.reactivex.internal.operators.flowable.FlowableCache;
import io.reactivex.internal.operators.flowable.FlowableCollectSingle;
import io.reactivex.internal.operators.flowable.FlowableCombineLatest;
import io.reactivex.internal.operators.flowable.FlowableConcatArray;
import io.reactivex.internal.operators.flowable.FlowableConcatMap;
import io.reactivex.internal.operators.flowable.FlowableConcatMapEager;
import io.reactivex.internal.operators.flowable.FlowableCountSingle;
import io.reactivex.internal.operators.flowable.FlowableCreate;
import io.reactivex.internal.operators.flowable.FlowableDebounce;
import io.reactivex.internal.operators.flowable.FlowableDebounceTimed;
import io.reactivex.internal.operators.flowable.FlowableDefer;
import io.reactivex.internal.operators.flowable.FlowableDelay;
import io.reactivex.internal.operators.flowable.FlowableDelaySubscriptionOther;
import io.reactivex.internal.operators.flowable.FlowableDematerialize;
import io.reactivex.internal.operators.flowable.FlowableDetach;
import io.reactivex.internal.operators.flowable.FlowableDistinct;
import io.reactivex.internal.operators.flowable.FlowableDistinctUntilChanged;
import io.reactivex.internal.operators.flowable.FlowableDoOnEach;
import io.reactivex.internal.operators.flowable.FlowableDoOnLifecycle;
import io.reactivex.internal.operators.flowable.FlowableElementAtMaybe;
import io.reactivex.internal.operators.flowable.FlowableElementAtSingle;
import io.reactivex.internal.operators.flowable.FlowableEmpty;
import io.reactivex.internal.operators.flowable.FlowableError;
import io.reactivex.internal.operators.flowable.FlowableFilter;
import io.reactivex.internal.operators.flowable.FlowableFlatMap;
import io.reactivex.internal.operators.flowable.FlowableFlattenIterable;
import io.reactivex.internal.operators.flowable.FlowableFromArray;
import io.reactivex.internal.operators.flowable.FlowableFromCallable;
import io.reactivex.internal.operators.flowable.FlowableFromFuture;
import io.reactivex.internal.operators.flowable.FlowableFromIterable;
import io.reactivex.internal.operators.flowable.FlowableFromPublisher;
import io.reactivex.internal.operators.flowable.FlowableGenerate;
import io.reactivex.internal.operators.flowable.FlowableGroupBy;
import io.reactivex.internal.operators.flowable.FlowableGroupJoin;
import io.reactivex.internal.operators.flowable.FlowableHide;
import io.reactivex.internal.operators.flowable.FlowableIgnoreElements;
import io.reactivex.internal.operators.flowable.FlowableIgnoreElementsCompletable;
import io.reactivex.internal.operators.flowable.FlowableInternalHelper;
import io.reactivex.internal.operators.flowable.FlowableInterval;
import io.reactivex.internal.operators.flowable.FlowableIntervalRange;
import io.reactivex.internal.operators.flowable.FlowableJoin;
import io.reactivex.internal.operators.flowable.FlowableJust;
import io.reactivex.internal.operators.flowable.FlowableLastMaybe;
import io.reactivex.internal.operators.flowable.FlowableLastSingle;
import io.reactivex.internal.operators.flowable.FlowableLift;
import io.reactivex.internal.operators.flowable.FlowableMap;
import io.reactivex.internal.operators.flowable.FlowableMapNotification;
import io.reactivex.internal.operators.flowable.FlowableMaterialize;
import io.reactivex.internal.operators.flowable.FlowableNever;
import io.reactivex.internal.operators.flowable.FlowableObserveOn;
import io.reactivex.internal.operators.flowable.FlowableOnBackpressureBuffer;
import io.reactivex.internal.operators.flowable.FlowableOnBackpressureBufferStrategy;
import io.reactivex.internal.operators.flowable.FlowableOnBackpressureDrop;
import io.reactivex.internal.operators.flowable.FlowableOnBackpressureLatest;
import io.reactivex.internal.operators.flowable.FlowableOnErrorNext;
import io.reactivex.internal.operators.flowable.FlowableOnErrorReturn;
import io.reactivex.internal.operators.flowable.FlowablePublish;
import io.reactivex.internal.operators.flowable.FlowablePublishMulticast;
import io.reactivex.internal.operators.flowable.FlowableRange;
import io.reactivex.internal.operators.flowable.FlowableReduceMaybe;
import io.reactivex.internal.operators.flowable.FlowableRepeat;
import io.reactivex.internal.operators.flowable.FlowableRepeatUntil;
import io.reactivex.internal.operators.flowable.FlowableRepeatWhen;
import io.reactivex.internal.operators.flowable.FlowableReplay;
import io.reactivex.internal.operators.flowable.FlowableRetryBiPredicate;
import io.reactivex.internal.operators.flowable.FlowableRetryPredicate;
import io.reactivex.internal.operators.flowable.FlowableRetryWhen;
import io.reactivex.internal.operators.flowable.FlowableSamplePublisher;
import io.reactivex.internal.operators.flowable.FlowableSampleTimed;
import io.reactivex.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.internal.operators.flowable.FlowableScan;
import io.reactivex.internal.operators.flowable.FlowableScanSeed;
import io.reactivex.internal.operators.flowable.FlowableSequenceEqual;
import io.reactivex.internal.operators.flowable.FlowableSerialized;
import io.reactivex.internal.operators.flowable.FlowableSingleMaybe;
import io.reactivex.internal.operators.flowable.FlowableSingleSingle;
import io.reactivex.internal.operators.flowable.FlowableSkip;
import io.reactivex.internal.operators.flowable.FlowableSkipLast;
import io.reactivex.internal.operators.flowable.FlowableSkipLastTimed;
import io.reactivex.internal.operators.flowable.FlowableSkipUntil;
import io.reactivex.internal.operators.flowable.FlowableSkipWhile;
import io.reactivex.internal.operators.flowable.FlowableSubscribeOn;
import io.reactivex.internal.operators.flowable.FlowableSwitchIfEmpty;
import io.reactivex.internal.operators.flowable.FlowableSwitchMap;
import io.reactivex.internal.operators.flowable.FlowableTake;
import io.reactivex.internal.operators.flowable.FlowableTakeLast;
import io.reactivex.internal.operators.flowable.FlowableTakeLastOne;
import io.reactivex.internal.operators.flowable.FlowableTakeLastTimed;
import io.reactivex.internal.operators.flowable.FlowableTakeUntil;
import io.reactivex.internal.operators.flowable.FlowableTakeUntilPredicate;
import io.reactivex.internal.operators.flowable.FlowableTakeWhile;
import io.reactivex.internal.operators.flowable.FlowableThrottleFirstTimed;
import io.reactivex.internal.operators.flowable.FlowableTimeInterval;
import io.reactivex.internal.operators.flowable.FlowableTimeout;
import io.reactivex.internal.operators.flowable.FlowableTimeoutTimed;
import io.reactivex.internal.operators.flowable.FlowableTimer;
import io.reactivex.internal.operators.flowable.FlowableToList;
import io.reactivex.internal.operators.flowable.FlowableToListSingle;
import io.reactivex.internal.operators.flowable.FlowableUnsubscribeOn;
import io.reactivex.internal.operators.flowable.FlowableUsing;
import io.reactivex.internal.operators.flowable.FlowableWindow;
import io.reactivex.internal.operators.flowable.FlowableWindowBoundary;
import io.reactivex.internal.operators.flowable.FlowableWindowBoundarySelector;
import io.reactivex.internal.operators.flowable.FlowableWindowBoundarySupplier;
import io.reactivex.internal.operators.flowable.FlowableWindowTimed;
import io.reactivex.internal.operators.flowable.FlowableWithLatestFrom;
import io.reactivex.internal.operators.flowable.FlowableWithLatestFromMany;
import io.reactivex.internal.operators.flowable.FlowableZip;
import io.reactivex.internal.operators.flowable.FlowableZipIterable;
import io.reactivex.internal.operators.observable.ObservableFromPublisher;
import io.reactivex.internal.schedulers.ImmediateThinScheduler;
import io.reactivex.internal.subscribers.BlockingFirstSubscriber;
import io.reactivex.internal.subscribers.BlockingLastSubscriber;
import io.reactivex.internal.subscribers.ForEachWhileSubscriber;
import io.reactivex.internal.subscribers.FutureSubscriber;
import io.reactivex.internal.subscribers.LambdaSubscriber;
import io.reactivex.internal.util.ArrayListSupplier;
import io.reactivex.internal.util.ErrorMode;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.HashMapSupplier;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.schedulers.Timed;
import io.reactivex.subscribers.SafeSubscriber;
import io.reactivex.subscribers.TestSubscriber;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class Flowable<T>
implements Publisher<T> {
    static final int BUFFER_SIZE = Math.max(16, Integer.getInteger("rx2.buffer-size", 128));

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> amb(Iterable<? extends Publisher<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableAmb(null, sources));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> ambArray(Publisher<? extends T> ... sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        int len = sources.length;
        if (len == 0) {
            return Flowable.empty();
        }
        if (len == 1) {
            return Flowable.fromPublisher(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new FlowableAmb<T>(sources, null));
    }

    public static int bufferSize() {
        return BUFFER_SIZE;
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Publisher<? extends T>[] sources, Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatest(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Function<? super Object[], ? extends R> combiner, Publisher<? extends T> ... sources) {
        return Flowable.combineLatest(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Publisher<? extends T>[] sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        if (sources.length == 0) {
            return Flowable.empty();
        }
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableCombineLatest<T, R>(sources, combiner, bufferSize, false));
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatest(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatest(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableCombineLatest(sources, combiner, bufferSize, false));
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Publisher<? extends T>[] sources, Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatestDelayError(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Function<? super Object[], ? extends R> combiner, Publisher<? extends T> ... sources) {
        return Flowable.combineLatestDelayError(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Function<? super Object[], ? extends R> combiner, int bufferSize, Publisher<? extends T> ... sources) {
        return Flowable.combineLatestDelayError(sources, combiner, bufferSize);
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Publisher<? extends T>[] sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (sources.length == 0) {
            return Flowable.empty();
        }
        return RxJavaPlugins.onAssembly(new FlowableCombineLatest<T, R>(sources, combiner, bufferSize, true));
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner) {
        return Flowable.combineLatestDelayError(sources, combiner, Flowable.bufferSize());
    }

    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.FULL)
    public static <T, R> Flowable<R> combineLatestDelayError(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> combiner, int bufferSize) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableCombineLatest(sources, combiner, bufferSize, true));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        Function<Object[], ? extends R> f = Functions.toFunction(combiner);
        return Flowable.combineLatest(f, source1, source2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Function3<? super T1, ? super T2, ? super T3, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5, source6);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        ObjectHelper.requireNonNull(source7, "source7 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5, source6, source7);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Publisher<? extends T8> source8, Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        ObjectHelper.requireNonNull(source7, "source7 is null");
        ObjectHelper.requireNonNull(source8, "source8 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Flowable<R> combineLatest(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Publisher<? extends T8> source8, Publisher<? extends T9> source9, Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> combiner) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        ObjectHelper.requireNonNull(source7, "source7 is null");
        ObjectHelper.requireNonNull(source8, "source8 is null");
        ObjectHelper.requireNonNull(source9, "source9 is null");
        return Flowable.combineLatest(Functions.toFunction(combiner), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Iterable<? extends Publisher<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return Flowable.fromIterable(sources).concatMapDelayError(Functions.identity(), 2, false);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.concat(sources, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends Publisher<? extends T>> sources, int prefetch) {
        return Flowable.fromPublisher(sources).concatMap(Functions.identity(), prefetch);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends T> source1, Publisher<? extends T> source2) {
        return Flowable.concatArray(source1, source2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3) {
        return Flowable.concatArray(source1, source2, source3);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concat(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3, Publisher<? extends T> source4) {
        return Flowable.concatArray(source1, source2, source3, source4);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatArray(Publisher<? extends T> ... sources) {
        if (sources.length == 0) {
            return Flowable.empty();
        }
        if (sources.length == 1) {
            return Flowable.fromPublisher(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new FlowableConcatArray<T>(sources, false));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatArrayDelayError(Publisher<? extends T> ... sources) {
        if (sources.length == 0) {
            return Flowable.empty();
        }
        if (sources.length == 1) {
            return Flowable.fromPublisher(sources[0]);
        }
        return RxJavaPlugins.onAssembly(new FlowableConcatArray<T>(sources, true));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatArrayEager(Publisher<? extends T> ... sources) {
        return Flowable.concatArrayEager(Flowable.bufferSize(), Flowable.bufferSize(), sources);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatArrayEager(int maxConcurrency, int prefetch, Publisher<? extends T> ... sources) {
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEager(new FlowableFromArray<Publisher<? extends T>>(sources), Functions.identity(), maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatDelayError(Iterable<? extends Publisher<? extends T>> sources) {
        ObjectHelper.requireNonNull(sources, "sources is null");
        return Flowable.fromIterable(sources).concatMapDelayError(Functions.identity());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatDelayError(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.concatDelayError(sources, Flowable.bufferSize(), true);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatDelayError(Publisher<? extends Publisher<? extends T>> sources, int prefetch, boolean tillTheEnd) {
        return Flowable.fromPublisher(sources).concatMapDelayError(Functions.identity(), prefetch, tillTheEnd);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatEager(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.concatEager(sources, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatEager(Publisher<? extends Publisher<? extends T>> sources, int maxConcurrency, int prefetch) {
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEager(sources, Functions.identity(), maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatEager(Iterable<? extends Publisher<? extends T>> sources) {
        return Flowable.concatEager(sources, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> concatEager(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency, int prefetch) {
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEager(new FlowableFromIterable<Publisher<? extends T>>(sources), Functions.identity(), maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> create(FlowableOnSubscribe<T> source, FlowableEmitter.BackpressureMode mode) {
        ObjectHelper.requireNonNull(source, "source is null");
        ObjectHelper.requireNonNull(mode, "mode is null");
        return RxJavaPlugins.onAssembly(new FlowableCreate<T>(source, mode));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> defer(Callable<? extends Publisher<? extends T>> supplier) {
        ObjectHelper.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new FlowableDefer(supplier));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> empty() {
        return RxJavaPlugins.onAssembly(FlowableEmpty.INSTANCE);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> error(Callable<? extends Throwable> supplier) {
        ObjectHelper.requireNonNull(supplier, "errorSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableError(supplier));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> error(Throwable throwable) {
        ObjectHelper.requireNonNull(throwable, "throwable is null");
        return Flowable.error(Functions.justCallable(throwable));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromArray(T ... items) {
        ObjectHelper.requireNonNull(items, "items is null");
        if (items.length == 0) {
            return Flowable.empty();
        }
        if (items.length == 1) {
            return Flowable.just(items[0]);
        }
        return RxJavaPlugins.onAssembly(new FlowableFromArray<T>(items));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromCallable(Callable<? extends T> supplier) {
        ObjectHelper.requireNonNull(supplier, "supplier is null");
        return RxJavaPlugins.onAssembly(new FlowableFromCallable<T>(supplier));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromFuture(Future<? extends T> future) {
        ObjectHelper.requireNonNull(future, "future is null");
        return RxJavaPlugins.onAssembly(new FlowableFromFuture<T>(future, 0L, null));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        ObjectHelper.requireNonNull(future, "future is null");
        ObjectHelper.requireNonNull(unit, "unit is null");
        return RxJavaPlugins.onAssembly(new FlowableFromFuture<T>(future, timeout, unit));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public static <T> Flowable<T> fromFuture(Future<? extends T> future, long timeout, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return Flowable.fromFuture(future, timeout, unit).subscribeOn(scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public static <T> Flowable<T> fromFuture(Future<? extends T> future, Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return Flowable.fromFuture(future).subscribeOn(scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromIterable(Iterable<? extends T> source) {
        ObjectHelper.requireNonNull(source, "source is null");
        return RxJavaPlugins.onAssembly(new FlowableFromIterable<T>(source));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> fromPublisher(Publisher<? extends T> source) {
        if (source instanceof Flowable) {
            return RxJavaPlugins.onAssembly((Flowable)source);
        }
        ObjectHelper.requireNonNull(source, "publisher is null");
        return RxJavaPlugins.onAssembly(new FlowableFromPublisher<T>(source));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> generate(Consumer<Emitter<T>> generator) {
        ObjectHelper.requireNonNull(generator, "generator is null");
        return Flowable.generate(Functions.nullSupplier(), FlowableInternalHelper.simpleGenerator(generator), Functions.emptyConsumer());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, S> Flowable<T> generate(Callable<S> initialState, BiConsumer<S, Emitter<T>> generator) {
        ObjectHelper.requireNonNull(generator, "generator is null");
        return Flowable.generate(initialState, FlowableInternalHelper.simpleBiGenerator(generator), Functions.emptyConsumer());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, S> Flowable<T> generate(Callable<S> initialState, BiConsumer<S, Emitter<T>> generator, Consumer<? super S> disposeState) {
        ObjectHelper.requireNonNull(generator, "generator is null");
        return Flowable.generate(initialState, FlowableInternalHelper.simpleBiGenerator(generator), disposeState);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, S> Flowable<T> generate(Callable<S> initialState, BiFunction<S, Emitter<T>, S> generator) {
        return Flowable.generate(initialState, generator, Functions.emptyConsumer());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, S> Flowable<T> generate(Callable<S> initialState, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        ObjectHelper.requireNonNull(initialState, "initialState is null");
        ObjectHelper.requireNonNull(generator, "generator is null");
        ObjectHelper.requireNonNull(disposeState, "disposeState is null");
        return RxJavaPlugins.onAssembly(new FlowableGenerate<T, S>(initialState, generator, disposeState));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> interval(long initialDelay, long period, TimeUnit unit) {
        return Flowable.interval(initialDelay, period, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> interval(long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableInterval(Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> interval(long period, TimeUnit unit) {
        return Flowable.interval(period, period, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> interval(long period, TimeUnit unit, Scheduler scheduler) {
        return Flowable.interval(period, period, unit, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> intervalRange(long start, long count, long initialDelay, long period, TimeUnit unit) {
        return Flowable.intervalRange(start, count, initialDelay, period, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> intervalRange(long start, long count, long initialDelay, long period, TimeUnit unit, Scheduler scheduler) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0L) {
            return Flowable.empty().delay(initialDelay, unit, scheduler);
        }
        long end = start + (count - 1L);
        if (start > 0L && end < 0L) {
            throw new IllegalArgumentException("Overflow! start + count is bigger than Long.MAX_VALUE");
        }
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableIntervalRange(start, end, Math.max(0L, initialDelay), Math.max(0L, period), unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item) {
        ObjectHelper.requireNonNull(item, "item is null");
        return RxJavaPlugins.onAssembly(new FlowableJust<T>(item));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        return Flowable.fromArray(item1, item2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        return Flowable.fromArray(item1, item2, item3);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        return Flowable.fromArray(item1, item2, item3, item4);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        ObjectHelper.requireNonNull(item7, "The seventh item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        ObjectHelper.requireNonNull(item7, "The seventh item is null");
        ObjectHelper.requireNonNull(item8, "The eighth item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8, T item9) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        ObjectHelper.requireNonNull(item7, "The seventh item is null");
        ObjectHelper.requireNonNull(item8, "The eighth item is null");
        ObjectHelper.requireNonNull(item9, "The ninth is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> just(T item1, T item2, T item3, T item4, T item5, T item6, T item7, T item8, T item9, T item10) {
        ObjectHelper.requireNonNull(item1, "The first item is null");
        ObjectHelper.requireNonNull(item2, "The second item is null");
        ObjectHelper.requireNonNull(item3, "The third item is null");
        ObjectHelper.requireNonNull(item4, "The fourth item is null");
        ObjectHelper.requireNonNull(item5, "The fifth item is null");
        ObjectHelper.requireNonNull(item6, "The sixth item is null");
        ObjectHelper.requireNonNull(item7, "The seventh item is null");
        ObjectHelper.requireNonNull(item8, "The eighth item is null");
        ObjectHelper.requireNonNull(item9, "The ninth item is null");
        ObjectHelper.requireNonNull(item10, "The tenth item is null");
        return Flowable.fromArray(item1, item2, item3, item4, item5, item6, item7, item8, item9, item10);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeArray(int maxConcurrency, int bufferSize, Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), false, maxConcurrency, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Iterable<? extends Publisher<? extends T>> sources) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), maxConcurrency);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.merge(sources, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends Publisher<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromPublisher(sources).flatMap(Functions.identity(), maxConcurrency);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeArray(Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), sources.length);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends T> source1, Publisher<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Flowable.fromArray(source1, source2).flatMap(Functions.identity(), false, 2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Flowable.fromArray(source1, source2, source3).flatMap(Functions.identity(), false, 3);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> merge(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3, Publisher<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Flowable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), false, 4);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Iterable<? extends Publisher<? extends T>> sources) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), true);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency, int bufferSize) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeArrayDelayError(int maxConcurrency, int bufferSize, Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), true, maxConcurrency, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Iterable<? extends Publisher<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromIterable(sources).flatMap(Functions.identity(), true, maxConcurrency);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.mergeDelayError(sources, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends Publisher<? extends T>> sources, int maxConcurrency) {
        return Flowable.fromPublisher(sources).flatMap(Functions.identity(), true, maxConcurrency);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeArrayDelayError(Publisher<? extends T> ... sources) {
        return Flowable.fromArray(sources).flatMap(Functions.identity(), true, sources.length);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends T> source1, Publisher<? extends T> source2) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Flowable.fromArray(source1, source2).flatMap(Functions.identity(), true, 2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Flowable.fromArray(source1, source2, source3).flatMap(Functions.identity(), true, 3);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> mergeDelayError(Publisher<? extends T> source1, Publisher<? extends T> source2, Publisher<? extends T> source3, Publisher<? extends T> source4) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Flowable.fromArray(source1, source2, source3, source4).flatMap(Functions.identity(), true, 4);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> never() {
        return RxJavaPlugins.onAssembly(FlowableNever.INSTANCE);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static Flowable<Integer> range(int start, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return Flowable.empty();
        }
        if (count == 1) {
            return Flowable.just(start);
        }
        if ((long)start + (long)(count - 1) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer overflow");
        }
        return RxJavaPlugins.onAssembly(new FlowableRange(start, count));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2) {
        return Flowable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2, BiPredicate<? super T, ? super T> isEqual) {
        return Flowable.sequenceEqual(source1, source2, isEqual, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2, BiPredicate<? super T, ? super T> isEqual, int bufferSize) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(isEqual, "isEqual is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableSequenceEqual<T>(source1, source2, isEqual, bufferSize));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<Boolean> sequenceEqual(Publisher<? extends T> source1, Publisher<? extends T> source2, int bufferSize) {
        return Flowable.sequenceEqual(source1, source2, ObjectHelper.equalsPredicate(), bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> switchOnNext(Publisher<? extends Publisher<? extends T>> sources, int bufferSize) {
        return Flowable.fromPublisher(sources).switchMap(Functions.identity(), bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> switchOnNext(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.fromPublisher(sources).switchMap(Functions.identity());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> switchOnNextDelayError(Publisher<? extends Publisher<? extends T>> sources) {
        return Flowable.switchOnNextDelayError(sources, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> switchOnNextDelayError(Publisher<? extends Publisher<? extends T>> sources, int prefetch) {
        return Flowable.fromPublisher(sources).switchMapDelayError(Functions.identity(), prefetch);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public static Flowable<Long> timer(long delay, TimeUnit unit) {
        return Flowable.timer(delay, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public static Flowable<Long> timer(long delay, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableTimer(Math.max(0L, delay), unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public static <T> Flowable<T> unsafeCreate(Publisher<T> onSubscribe) {
        ObjectHelper.requireNonNull(onSubscribe, "onSubscribe is null");
        if (onSubscribe instanceof Flowable) {
            throw new IllegalArgumentException("unsafeCreate(Flowable) should be upgraded");
        }
        return RxJavaPlugins.onAssembly(new FlowableFromPublisher<T>(onSubscribe));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T, D> Flowable<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> resourceDisposer) {
        return Flowable.using(resourceSupplier, sourceSupplier, resourceDisposer, true);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public static <T, D> Flowable<T> using(Callable<? extends D> resourceSupplier, Function<? super D, ? extends Publisher<? extends T>> sourceSupplier, Consumer<? super D> resourceDisposer, boolean eager) {
        ObjectHelper.requireNonNull(resourceSupplier, "resourceSupplier is null");
        ObjectHelper.requireNonNull(sourceSupplier, "sourceSupplier is null");
        ObjectHelper.requireNonNull(resourceDisposer, "disposer is null");
        return RxJavaPlugins.onAssembly(new FlowableUsing(resourceSupplier, sourceSupplier, resourceDisposer, eager));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, R> Flowable<R> zip(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        ObjectHelper.requireNonNull(sources, "sources is null");
        return RxJavaPlugins.onAssembly(new FlowableZip(null, sources, zipper, Flowable.bufferSize(), false));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, R> Flowable<R> zip(Publisher<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        return Flowable.fromPublisher(sources).toList().flatMapPublisher(FlowableInternalHelper.zipIterable(zipper));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), delayError, Flowable.bufferSize(), source1, source2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, BiFunction<? super T1, ? super T2, ? extends R> zipper, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), delayError, bufferSize, source1, source2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Function3<? super T1, ? super T2, ? super T3, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Function4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Function5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Function6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Function7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        ObjectHelper.requireNonNull(source7, "source7 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6, source7);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Publisher<? extends T8> source8, Function8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        ObjectHelper.requireNonNull(source7, "source7 is null");
        ObjectHelper.requireNonNull(source8, "source8 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Flowable<R> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6, Publisher<? extends T7> source7, Publisher<? extends T8> source8, Publisher<? extends T9> source9, Function9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipper) {
        ObjectHelper.requireNonNull(source1, "source1 is null");
        ObjectHelper.requireNonNull(source2, "source2 is null");
        ObjectHelper.requireNonNull(source3, "source3 is null");
        ObjectHelper.requireNonNull(source4, "source4 is null");
        ObjectHelper.requireNonNull(source5, "source5 is null");
        ObjectHelper.requireNonNull(source6, "source6 is null");
        ObjectHelper.requireNonNull(source7, "source7 is null");
        ObjectHelper.requireNonNull(source8, "source8 is null");
        ObjectHelper.requireNonNull(source9, "source9 is null");
        return Flowable.zipArray(Functions.toFunction(zipper), false, Flowable.bufferSize(), source1, source2, source3, source4, source5, source6, source7, source8, source9);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, R> Flowable<R> zipArray(Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize, Publisher<? extends T> ... sources) {
        if (sources.length == 0) {
            return Flowable.empty();
        }
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableZip<T, R>(sources, null, zipper, bufferSize, delayError));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public static <T, R> Flowable<R> zipIterable(Iterable<? extends Publisher<? extends T>> sources, Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        ObjectHelper.requireNonNull(sources, "sources is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableZip(null, sources, zipper, bufferSize, delayError));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<Boolean> all(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableAllSingle<T>(this, predicate));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> ambWith(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Flowable.ambArray(this, other);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<Boolean> any(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableAnySingle<T>(this, predicate));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingFirst() {
        BlockingFirstSubscriber s = new BlockingFirstSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingFirst(T defaultItem) {
        BlockingFirstSubscriber s = new BlockingFirstSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        return v != null ? v : defaultItem;
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingForEach(Consumer<? super T> onNext) {
        Iterator<T> it = this.blockingIterable().iterator();
        while (it.hasNext()) {
            try {
                onNext.accept(it.next());
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                ((Disposable)((Object)it)).dispose();
                throw ExceptionHelper.wrapOrThrow(e);
            }
        }
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingIterable() {
        return this.blockingIterable(Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingIterable(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return new BlockingFlowableIterable(this, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingLast() {
        BlockingLastSubscriber s = new BlockingLastSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException();
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingLast(T defaultItem) {
        BlockingLastSubscriber s = new BlockingLastSubscriber();
        this.subscribe(s);
        Object v = s.blockingGet();
        return v != null ? v : defaultItem;
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingLatest() {
        return BlockingFlowableLatest.latest(this);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingMostRecent(T initialItem) {
        return BlockingFlowableMostRecent.mostRecent(this, initialItem);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Iterable<T> blockingNext() {
        return BlockingFlowableNext.next(this);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingSingle() {
        return this.singleElement().blockingGet();
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final T blockingSingle(T defaultItem) {
        return this.single(defaultItem).blockingGet();
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Future<T> toFuture() {
        return this.subscribeWith(new FutureSubscriber());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe() {
        FlowableBlockingSubscribe.subscribe(this);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Consumer<? super T> onNext) {
        FlowableBlockingSubscribe.subscribe(this, onNext, Functions.ERROR_CONSUMER, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError) {
        FlowableBlockingSubscribe.subscribe(this, onNext, onError, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        FlowableBlockingSubscribe.subscribe(this, onNext, onError, onComplete);
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final void blockingSubscribe(Subscriber<? super T> subscriber) {
        FlowableBlockingSubscribe.subscribe(this, subscriber);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> buffer(int count) {
        return this.buffer(count, count);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<List<T>> buffer(int count, int skip) {
        return this.buffer(count, skip, ArrayListSupplier.asCallable());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U extends Collection<? super T>> Flowable<U> buffer(int count, int skip, Callable<U> bufferSupplier) {
        ObjectHelper.verifyPositive(count, "count");
        ObjectHelper.verifyPositive(skip, "skip");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableBuffer(this, count, skip, bufferSupplier));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U extends Collection<? super T>> Flowable<U> buffer(int count, Callable<U> bufferSupplier) {
        return this.buffer(count, count, bufferSupplier);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<List<T>> buffer(long timespan, long timeskip, TimeUnit unit) {
        return this.buffer(timespan, timeskip, unit, Schedulers.computation(), ArrayListSupplier.asCallable());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<List<T>> buffer(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler) {
        return this.buffer(timespan, timeskip, unit, scheduler, ArrayListSupplier.asCallable());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final <U extends Collection<? super T>> Flowable<U> buffer(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableBufferTimed(this, timespan, timeskip, unit, scheduler, bufferSupplier, Integer.MAX_VALUE, false));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<List<T>> buffer(long timespan, TimeUnit unit) {
        return this.buffer(timespan, unit, Integer.MAX_VALUE, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<List<T>> buffer(long timespan, TimeUnit unit, int count) {
        return this.buffer(timespan, unit, count, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<List<T>> buffer(long timespan, TimeUnit unit, int count, Scheduler scheduler) {
        return this.buffer(timespan, unit, count, scheduler, ArrayListSupplier.asCallable(), false);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final <U extends Collection<? super T>> Flowable<U> buffer(long timespan, TimeUnit unit, int count, Scheduler scheduler, Callable<U> bufferSupplier, boolean restartTimerOnMaxSize) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        ObjectHelper.verifyPositive(count, "count");
        return RxJavaPlugins.onAssembly(new FlowableBufferTimed(this, timespan, timespan, unit, scheduler, bufferSupplier, count, restartTimerOnMaxSize));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<List<T>> buffer(long timespan, TimeUnit unit, Scheduler scheduler) {
        return this.buffer(timespan, unit, Integer.MAX_VALUE, scheduler, ArrayListSupplier.asCallable(), false);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <TOpening, TClosing> Flowable<List<T>> buffer(Flowable<? extends TOpening> openingIndicator, Function<? super TOpening, ? extends Publisher<? extends TClosing>> closingIndicator) {
        return this.buffer(openingIndicator, closingIndicator, ArrayListSupplier.asCallable());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <TOpening, TClosing, U extends Collection<? super T>> Flowable<U> buffer(Flowable<? extends TOpening> openingIndicator, Function<? super TOpening, ? extends Publisher<? extends TClosing>> closingIndicator, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(openingIndicator, "openingIndicator is null");
        ObjectHelper.requireNonNull(closingIndicator, "closingIndicator is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableBufferBoundary(this, openingIndicator, closingIndicator, bufferSupplier));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<List<T>> buffer(Publisher<B> boundaryIndicator) {
        return this.buffer(boundaryIndicator, ArrayListSupplier.asCallable());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<List<T>> buffer(Publisher<B> boundaryIndicator, int initialCapacity) {
        return this.buffer(boundaryIndicator, Functions.createArrayList(initialCapacity));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B, U extends Collection<? super T>> Flowable<U> buffer(Publisher<B> boundaryIndicator, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(boundaryIndicator, "boundaryIndicator is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableBufferExactBoundary(this, boundaryIndicator, bufferSupplier));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<List<T>> buffer(Callable<? extends Publisher<B>> boundaryIndicatorSupplier) {
        return this.buffer(boundaryIndicatorSupplier, ArrayListSupplier.asCallable());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B, U extends Collection<? super T>> Flowable<U> buffer(Callable<? extends Publisher<B>> boundaryIndicatorSupplier, Callable<U> bufferSupplier) {
        ObjectHelper.requireNonNull(boundaryIndicatorSupplier, "boundaryIndicatorSupplier is null");
        ObjectHelper.requireNonNull(bufferSupplier, "bufferSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableBufferBoundarySupplier(this, boundaryIndicatorSupplier, bufferSupplier));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> cache() {
        return FlowableCache.from(this);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> cacheWithInitialCapacity(int initialCapacity) {
        ObjectHelper.verifyPositive(initialCapacity, "initialCapacity");
        return FlowableCache.from(this, initialCapacity);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> cast(Class<U> clazz) {
        ObjectHelper.requireNonNull(clazz, "clazz is null");
        return this.map(Functions.castFunction(clazz));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <U> Single<U> collect(Callable<? extends U> initialItemSupplier, BiConsumer<? super U, ? super T> collector) {
        ObjectHelper.requireNonNull(initialItemSupplier, "initialItemSupplier is null");
        ObjectHelper.requireNonNull(collector, "collector is null");
        return RxJavaPlugins.onAssembly(new FlowableCollectSingle<T, U>(this, initialItemSupplier, collector));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <U> Single<U> collectInto(U initialItem, BiConsumer<? super U, ? super T> collector) {
        ObjectHelper.requireNonNull(initialItem, "initialItem is null");
        return this.collect(Functions.justCallable(initialItem), collector);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> compose(FlowableTransformer<T, R> composer) {
        return Flowable.fromPublisher((Publisher)this.to(composer));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.concatMap(mapper, 2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        if (this instanceof ScalarCallable) {
            Object v = ((ScalarCallable)((Object)this)).call();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMap(this, mapper, prefetch, ErrorMode.IMMEDIATE));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.concatMapDelayError(mapper, 2, true);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, boolean tillTheEnd) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        if (this instanceof ScalarCallable) {
            Object v = ((ScalarCallable)((Object)this)).call();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMap(this, mapper, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.IMMEDIATE));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapEager(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.concatMapEager(mapper, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapEager(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch) {
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEager(this, mapper, maxConcurrency, prefetch, ErrorMode.IMMEDIATE));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapEagerDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean tillTheEnd) {
        return this.concatMapEagerDelayError(mapper, Flowable.bufferSize(), Flowable.bufferSize(), tillTheEnd);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> concatMapEagerDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency, int prefetch, boolean tillTheEnd) {
        return RxJavaPlugins.onAssembly(new FlowableConcatMapEager(this, mapper, maxConcurrency, prefetch, tillTheEnd ? ErrorMode.END : ErrorMode.BOUNDARY));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> concatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return this.concatMapIterable(mapper, 2);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> concatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, int prefetch) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowableFlattenIterable(this, mapper, prefetch));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> concatWith(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Flowable.concat(this, other);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<Boolean> contains(Object item) {
        ObjectHelper.requireNonNull(item, "item is null");
        return this.any(Functions.equalsWith(item));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<Long> count() {
        return RxJavaPlugins.onAssembly(new FlowableCountSingle(this));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> debounce(Function<? super T, ? extends Publisher<U>> debounceIndicator) {
        ObjectHelper.requireNonNull(debounceIndicator, "debounceIndicator is null");
        return RxJavaPlugins.onAssembly(new FlowableDebounce(this, debounceIndicator));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> debounce(long timeout, TimeUnit unit) {
        return this.debounce(timeout, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> debounce(long timeout, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableDebounceTimed(this, timeout, unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> defaultIfEmpty(T defaultItem) {
        ObjectHelper.requireNonNull(defaultItem, "item is null");
        return this.switchIfEmpty(Flowable.just(defaultItem));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> delay(Function<? super T, ? extends Publisher<U>> itemDelayIndicator) {
        ObjectHelper.requireNonNull(itemDelayIndicator, "itemDelayIndicator is null");
        return this.flatMap(FlowableInternalHelper.itemDelay(itemDelayIndicator));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> delay(long delay, TimeUnit unit) {
        return this.delay(delay, unit, Schedulers.computation(), false);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> delay(long delay, TimeUnit unit, boolean delayError) {
        return this.delay(delay, unit, Schedulers.computation(), delayError);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> delay(long delay, TimeUnit unit, Scheduler scheduler) {
        return this.delay(delay, unit, scheduler, false);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> delay(long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableDelay(this, Math.max(0L, delay), unit, scheduler, delayError));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<T> delay(Publisher<U> subscriptionIndicator, Function<? super T, ? extends Publisher<V>> itemDelayIndicator) {
        return this.delaySubscription(subscriptionIndicator).delay(itemDelayIndicator);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> delaySubscription(Publisher<U> subscriptionIndicator) {
        ObjectHelper.requireNonNull(subscriptionIndicator, "subscriptionIndicator is null");
        return RxJavaPlugins.onAssembly(new FlowableDelaySubscriptionOther(this, subscriptionIndicator));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> delaySubscription(long delay, TimeUnit unit) {
        return this.delaySubscription(delay, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> delaySubscription(long delay, TimeUnit unit, Scheduler scheduler) {
        return this.delaySubscription(Flowable.timer(delay, unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <T2> Flowable<T2> dematerialize() {
        Flowable m = this;
        return RxJavaPlugins.onAssembly(new FlowableDematerialize(m));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> distinct() {
        return this.distinct(Functions.identity(), Functions.createHashSet());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<T> distinct(Function<? super T, K> keySelector) {
        return this.distinct(keySelector, Functions.createHashSet());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<T> distinct(Function<? super T, K> keySelector, Callable<? extends Collection<? super K>> collectionSupplier) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        ObjectHelper.requireNonNull(collectionSupplier, "collectionSupplier is null");
        return FlowableDistinct.withCollection(this, keySelector, collectionSupplier);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> distinctUntilChanged() {
        return FlowableDistinct.untilChanged(this);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<T> distinctUntilChanged(Function<? super T, K> keySelector) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        return FlowableDistinct.untilChanged(this, keySelector);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> distinctUntilChanged(BiPredicate<? super T, ? super T> comparer) {
        ObjectHelper.requireNonNull(comparer, "comparer is null");
        return RxJavaPlugins.onAssembly(new FlowableDistinctUntilChanged<T>(this, comparer));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doAfterTerminate(Action onAfterTerminate) {
        return this.doOnEach(Functions.emptyConsumer(), Functions.emptyConsumer(), Functions.EMPTY_ACTION, onAfterTerminate);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnCancel(Action onCancel) {
        return this.doOnLifecycle(Functions.emptyConsumer(), Functions.EMPTY_LONG_CONSUMER, onCancel);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnComplete(Action onComplete) {
        return this.doOnEach(Functions.emptyConsumer(), Functions.emptyConsumer(), onComplete, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    private Flowable<T> doOnEach(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        ObjectHelper.requireNonNull(onAfterTerminate, "onAfterTerminate is null");
        return RxJavaPlugins.onAssembly(new FlowableDoOnEach<T>(this, onNext, onError, onComplete, onAfterTerminate));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnEach(Consumer<? super Notification<T>> onNotification) {
        ObjectHelper.requireNonNull(onNotification, "consumer is null");
        return this.doOnEach(Functions.notificationOnNext(onNotification), Functions.notificationOnError(onNotification), Functions.notificationOnComplete(onNotification), Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnEach(Subscriber<? super T> subscriber) {
        ObjectHelper.requireNonNull(subscriber, "subscriber is null");
        return this.doOnEach(FlowableInternalHelper.subscriberOnNext(subscriber), FlowableInternalHelper.subscriberOnError(subscriber), FlowableInternalHelper.subscriberOnComplete(subscriber), Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnError(Consumer<? super Throwable> onError) {
        return this.doOnEach(Functions.emptyConsumer(), onError, Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnLifecycle(Consumer<? super Subscription> onSubscribe, LongConsumer onRequest, Action onCancel) {
        ObjectHelper.requireNonNull(onSubscribe, "onSubscribe is null");
        ObjectHelper.requireNonNull(onRequest, "onRequest is null");
        ObjectHelper.requireNonNull(onCancel, "onCancel is null");
        return RxJavaPlugins.onAssembly(new FlowableDoOnLifecycle(this, onSubscribe, onRequest, onCancel));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnNext(Consumer<? super T> onNext) {
        return this.doOnEach(onNext, Functions.emptyConsumer(), Functions.EMPTY_ACTION, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnRequest(LongConsumer onRequest) {
        return this.doOnLifecycle(Functions.emptyConsumer(), onRequest, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnSubscribe(Consumer<? super Subscription> onSubscribe) {
        return this.doOnLifecycle(onSubscribe, Functions.EMPTY_LONG_CONSUMER, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> doOnTerminate(Action onTerminate) {
        return this.doOnEach(Functions.emptyConsumer(), Functions.actionConsumer(onTerminate), onTerminate, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Maybe<T> elementAt(long index) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        return RxJavaPlugins.onAssembly(new FlowableElementAtMaybe(this, index));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<T> elementAt(long index, T defaultItem) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index >= 0 required but it was " + index);
        }
        ObjectHelper.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new FlowableElementAtSingle<T>(this, index, defaultItem));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> filter(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableFilter<T>(this, predicate));
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Maybe<T> firstElement() {
        return this.elementAt(0L);
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Single<T> first(T defaultItem) {
        return this.elementAt(0L, defaultItem);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.flatMap(mapper, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayErrors) {
        return this.flatMap(mapper, delayErrors, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, int maxConcurrency) {
        return this.flatMap(mapper, false, maxConcurrency, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, delayErrors, maxConcurrency, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        if (this instanceof ScalarCallable) {
            Object v = ((ScalarCallable)((Object)this)).call();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        ObjectHelper.verifyPositive(maxConcurrency, "maxConcurrency");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableFlatMap(this, mapper, delayErrors, maxConcurrency, bufferSize));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> onNextMapper, Function<? super Throwable, ? extends Publisher<? extends R>> onErrorMapper, Callable<? extends Publisher<? extends R>> onCompleteSupplier) {
        ObjectHelper.requireNonNull(onNextMapper, "onNextMapper is null");
        ObjectHelper.requireNonNull(onErrorMapper, "onErrorMapper is null");
        ObjectHelper.requireNonNull(onCompleteSupplier, "onCompleteSupplier is null");
        return Flowable.merge(new FlowableMapNotification<T, Publisher<? extends R>>(this, onNextMapper, onErrorMapper, onCompleteSupplier));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends R>> onNextMapper, Function<Throwable, ? extends Publisher<? extends R>> onErrorMapper, Callable<? extends Publisher<? extends R>> onCompleteSupplier, int maxConcurrency) {
        ObjectHelper.requireNonNull(onNextMapper, "onNextMapper is null");
        ObjectHelper.requireNonNull(onErrorMapper, "onErrorMapper is null");
        ObjectHelper.requireNonNull(onCompleteSupplier, "onCompleteSupplier is null");
        return Flowable.merge(new FlowableMapNotification<T, Publisher<? extends R>>(this, onNextMapper, onErrorMapper, onCompleteSupplier), maxConcurrency);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
        return this.flatMap(mapper, resultSelector, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors) {
        return this.flatMap(mapper, combiner, delayErrors, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency) {
        return this.flatMap(mapper, combiner, delayErrors, maxConcurrency, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, boolean delayErrors, int maxConcurrency, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        return this.flatMap(FlowableInternalHelper.flatMapWithCombiner(mapper, combiner), delayErrors, maxConcurrency, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> flatMap(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner, int maxConcurrency) {
        return this.flatMap(mapper, combiner, false, maxConcurrency, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return this.flatMapIterable(mapper, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, int bufferSize) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableFlattenIterable(this, mapper, bufferSize));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<V> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends V> resultSelector) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.requireNonNull(resultSelector, "resultSelector is null");
        return this.flatMap(FlowableInternalHelper.flatMapIntoIterable(mapper), resultSelector, false, Flowable.bufferSize(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<V> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends V> resultSelector, int prefetch) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        ObjectHelper.requireNonNull(resultSelector, "resultSelector is null");
        return this.flatMap(FlowableInternalHelper.flatMapIntoIterable(mapper), resultSelector, false, Flowable.bufferSize(), prefetch);
    }

    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public final Disposable forEach(Consumer<? super T> onNext) {
        return this.subscribe(onNext);
    }

    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public final Disposable forEachWhile(Predicate<? super T> onNext) {
        return this.forEachWhile(onNext, Functions.ERROR_CONSUMER, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public final Disposable forEachWhile(Predicate<? super T> onNext, Consumer<? super Throwable> onError) {
        return this.forEachWhile(onNext, onError, Functions.EMPTY_ACTION);
    }

    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public final Disposable forEachWhile(Predicate<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        ForEachWhileSubscriber<? super T> s = new ForEachWhileSubscriber<T>(onNext, onError, onComplete);
        this.subscribe(s);
        return s;
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<GroupedFlowable<K, T>> groupBy(Function<? super T, ? extends K> keySelector) {
        return this.groupBy(keySelector, Functions.identity(), false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K> Flowable<GroupedFlowable<K, T>> groupBy(Function<? super T, ? extends K> keySelector, boolean delayError) {
        return this.groupBy(keySelector, Functions.identity(), delayError, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        return this.groupBy(keySelector, valueSelector, false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, boolean delayError) {
        return this.groupBy(keySelector, valueSelector, delayError, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <K, V> Flowable<GroupedFlowable<K, V>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, "valueSelector is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableGroupBy<T, K, V>(this, keySelector, valueSelector, bufferSize, delayError));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <TRight, TLeftEnd, TRightEnd, R> Flowable<R> groupJoin(Publisher<? extends TRight> other, Function<? super T, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super T, ? super Flowable<TRight>, ? extends R> resultSelector) {
        return RxJavaPlugins.onAssembly(new FlowableGroupJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> hide() {
        return RxJavaPlugins.onAssembly(new FlowableHide(this));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Completable ignoreElements() {
        return RxJavaPlugins.onAssembly(new FlowableIgnoreElementsCompletable(this));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<Boolean> isEmpty() {
        return this.all(Functions.alwaysFalse());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <TRight, TLeftEnd, TRightEnd, R> Flowable<R> join(Publisher<? extends TRight> other, Function<? super T, ? extends Publisher<TLeftEnd>> leftEnd, Function<? super TRight, ? extends Publisher<TRightEnd>> rightEnd, BiFunction<? super T, ? super TRight, ? extends R> resultSelector) {
        return RxJavaPlugins.onAssembly(new FlowableJoin(this, other, leftEnd, rightEnd, resultSelector));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Maybe<T> lastElement() {
        return RxJavaPlugins.onAssembly(new FlowableLastMaybe(this));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<T> last(T defaultItem) {
        ObjectHelper.requireNonNull(defaultItem, "defaultItem");
        return RxJavaPlugins.onAssembly(new FlowableLastSingle<T>(this, defaultItem));
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> lift(FlowableOperator<? extends R, ? super T> lifter) {
        ObjectHelper.requireNonNull(lifter, "lifter is null");
        return RxJavaPlugins.onAssembly(new FlowableLift<R, T>(this, lifter));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> map(Function<? super T, ? extends R> mapper) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        return RxJavaPlugins.onAssembly(new FlowableMap<T, R>(this, mapper));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<Notification<T>> materialize() {
        return RxJavaPlugins.onAssembly(new FlowableMaterialize(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> mergeWith(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Flowable.merge(this, other);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> observeOn(Scheduler scheduler) {
        return this.observeOn(scheduler, false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> observeOn(Scheduler scheduler, boolean delayError) {
        return this.observeOn(scheduler, delayError, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> observeOn(Scheduler scheduler, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableObserveOn(this, scheduler, delayError, bufferSize));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U> Flowable<U> ofType(Class<U> clazz) {
        ObjectHelper.requireNonNull(clazz, "clazz is null");
        return this.filter(Functions.isInstanceOf(clazz)).cast(clazz);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer() {
        return this.onBackpressureBuffer(Flowable.bufferSize(), false, true);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(boolean delayError) {
        return this.onBackpressureBuffer(Flowable.bufferSize(), delayError, true);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity) {
        return this.onBackpressureBuffer(capacity, false, false);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity, boolean delayError) {
        return this.onBackpressureBuffer(capacity, delayError, false);
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity, boolean delayError, boolean unbounded) {
        ObjectHelper.verifyPositive(capacity, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureBuffer(this, capacity, unbounded, delayError, Functions.EMPTY_ACTION));
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity, boolean delayError, boolean unbounded, Action onOverflow) {
        ObjectHelper.requireNonNull(onOverflow, "onOverflow is null");
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureBuffer(this, capacity, unbounded, delayError, onOverflow));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureBuffer(int capacity, Action onOverflow) {
        return this.onBackpressureBuffer(capacity, false, false, onOverflow);
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Publisher<T> onBackpressureBuffer(long capacity, Action onOverflow, BackpressureOverflowStrategy overflowStrategy) {
        ObjectHelper.requireNonNull(overflowStrategy, "strategy is null");
        ObjectHelper.verifyPositive(capacity, "capacity");
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureBufferStrategy(this, capacity, onOverflow, overflowStrategy));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureDrop() {
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureDrop(this));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureDrop(Consumer<? super T> onDrop) {
        ObjectHelper.requireNonNull(onDrop, "onDrop is null");
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureDrop<T>(this, onDrop));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> onBackpressureLatest() {
        return RxJavaPlugins.onAssembly(new FlowableOnBackpressureLatest(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onErrorResumeNext(Function<? super Throwable, ? extends Publisher<? extends T>> resumeFunction) {
        ObjectHelper.requireNonNull(resumeFunction, "resumeFunction is null");
        return RxJavaPlugins.onAssembly(new FlowableOnErrorNext(this, resumeFunction, false));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onErrorResumeNext(Publisher<? extends T> next) {
        ObjectHelper.requireNonNull(next, "next is null");
        return this.onErrorResumeNext(Functions.justFunction(next));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onErrorReturn(Function<? super Throwable, ? extends T> valueSupplier) {
        ObjectHelper.requireNonNull(valueSupplier, "valueSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableOnErrorReturn<T>(this, valueSupplier));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onErrorReturnItem(T item) {
        ObjectHelper.requireNonNull(item, "item is null");
        return this.onErrorReturn(Functions.justFunction(item));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> onExceptionResumeNext(Publisher<? extends T> next) {
        ObjectHelper.requireNonNull(next, "next is null");
        return RxJavaPlugins.onAssembly(new FlowableOnErrorNext<T>(this, Functions.justFunction(next), true));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> onTerminateDetach() {
        return RxJavaPlugins.onAssembly(new FlowableDetach(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final ConnectableFlowable<T> publish() {
        return this.publish(Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> publish(Function<? super Flowable<T>, ? extends Publisher<R>> selector) {
        return this.publish(selector, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> publish(Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector, int prefetch) {
        ObjectHelper.requireNonNull(selector, "selector is null");
        ObjectHelper.verifyPositive(prefetch, "prefetch");
        return RxJavaPlugins.onAssembly(new FlowablePublishMulticast(this, selector, prefetch, false));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final ConnectableFlowable<T> publish(int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return FlowablePublish.create(this, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> rebatchRequests(int n) {
        return this.observeOn(ImmediateThinScheduler.INSTANCE, true, n);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Maybe<T> reduce(BiFunction<T, T, T> reducer) {
        ObjectHelper.requireNonNull(reducer, "reducer is null");
        return RxJavaPlugins.onAssembly(new FlowableReduceMaybe<T>(this, reducer));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <R> Single<R> reduce(R seed, BiFunction<R, ? super T, R> reducer) {
        return RxJavaPlugins.onAssembly(new FlowableSingleSingle<Object>(this.scan(seed, reducer).takeLast(1), null));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <R> Single<R> reduceWith(Callable<R> seedSupplier, BiFunction<R, ? super T, R> reducer) {
        return RxJavaPlugins.onAssembly(new FlowableSingleSingle<Object>(this.scanWith(seedSupplier, reducer).takeLast(1), null));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> repeat() {
        return this.repeat(Long.MAX_VALUE);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> repeat(long times) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        if (times == 0L) {
            return Flowable.empty();
        }
        return RxJavaPlugins.onAssembly(new FlowableRepeat(this, times));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> repeatUntil(BooleanSupplier stop) {
        ObjectHelper.requireNonNull(stop, "stop is null");
        return RxJavaPlugins.onAssembly(new FlowableRepeatUntil(this, stop));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> repeatWhen(Function<? super Flowable<Object>, ? extends Publisher<?>> handler) {
        ObjectHelper.requireNonNull(handler, "handler is null");
        return RxJavaPlugins.onAssembly(new FlowableRepeatWhen(this, handler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final ConnectableFlowable<T> replay() {
        return FlowableReplay.createFrom(this);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector) {
        ObjectHelper.requireNonNull(selector, "selector is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this), selector);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize) {
        ObjectHelper.requireNonNull(selector, "selector is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this, bufferSize), selector);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, long time, TimeUnit unit) {
        return this.replay(selector, bufferSize, time, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.requireNonNull(selector, "selector is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this, bufferSize, time, unit, scheduler), selector);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, int bufferSize, Scheduler scheduler) {
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this, bufferSize), FlowableInternalHelper.replayFunction(selector, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, long time, TimeUnit unit) {
        return this.replay(selector, time, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(selector, "selector is null");
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this, time, unit, scheduler), selector);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final <R> Flowable<R> replay(Function<? super Flowable<T>, ? extends Publisher<R>> selector, Scheduler scheduler) {
        ObjectHelper.requireNonNull(selector, "selector is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.multicastSelector(FlowableInternalHelper.replayCallable(this), FlowableInternalHelper.replayFunction(selector, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final ConnectableFlowable<T> replay(int bufferSize) {
        return FlowableReplay.create(this, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final ConnectableFlowable<T> replay(int bufferSize, long time, TimeUnit unit) {
        return this.replay(bufferSize, time, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final ConnectableFlowable<T> replay(int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return FlowableReplay.create(this, time, unit, scheduler, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final ConnectableFlowable<T> replay(int bufferSize, Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.observeOn(this.replay(bufferSize), scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final ConnectableFlowable<T> replay(long time, TimeUnit unit) {
        return this.replay(time, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final ConnectableFlowable<T> replay(long time, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.create(this, time, unit, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final ConnectableFlowable<T> replay(Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return FlowableReplay.observeOn(this.replay(), scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry() {
        return this.retry(Long.MAX_VALUE, Functions.alwaysTrue());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry(BiPredicate<? super Integer, ? super Throwable> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableRetryBiPredicate(this, predicate));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry(long count) {
        return this.retry(count, Functions.alwaysTrue());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry(long times, Predicate<? super Throwable> predicate) {
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableRetryPredicate(this, times, predicate));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retry(Predicate<? super Throwable> predicate) {
        return this.retry(Long.MAX_VALUE, predicate);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retryUntil(BooleanSupplier stop) {
        ObjectHelper.requireNonNull(stop, "stop is null");
        return this.retry(Long.MAX_VALUE, Functions.predicateReverseFor(stop));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> retryWhen(Function<? super Flowable<? extends Throwable>, ? extends Publisher<?>> handler) {
        ObjectHelper.requireNonNull(handler, "handler is null");
        return RxJavaPlugins.onAssembly(new FlowableRetryWhen(this, handler));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final void safeSubscribe(Subscriber<? super T> s) {
        ObjectHelper.requireNonNull(s, "s is null");
        if (s instanceof SafeSubscriber) {
            this.subscribe(s);
        } else {
            this.subscribe(new SafeSubscriber<T>(s));
        }
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> sample(long period, TimeUnit unit) {
        return this.sample(period, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> sample(long period, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableSampleTimed(this, period, unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> sample(Publisher<U> sampler) {
        ObjectHelper.requireNonNull(sampler, "sampler is null");
        return RxJavaPlugins.onAssembly(new FlowableSamplePublisher(this, sampler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> scan(BiFunction<T, T, T> accumulator) {
        ObjectHelper.requireNonNull(accumulator, "accumulator is null");
        return RxJavaPlugins.onAssembly(new FlowableScan<T>(this, accumulator));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> scan(R initialValue, BiFunction<R, ? super T, R> accumulator) {
        ObjectHelper.requireNonNull(initialValue, "seed is null");
        return this.scanWith(Functions.justCallable(initialValue), accumulator);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> scanWith(Callable<R> seedSupplier, BiFunction<R, ? super T, R> accumulator) {
        ObjectHelper.requireNonNull(seedSupplier, "seedSupplier is null");
        ObjectHelper.requireNonNull(accumulator, "accumulator is null");
        return RxJavaPlugins.onAssembly(new FlowableScanSeed<T, R>(this, seedSupplier, accumulator));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> serialize() {
        return RxJavaPlugins.onAssembly(new FlowableSerialized(this));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> share() {
        return this.publish().refCount();
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Maybe<T> singleElement() {
        return RxJavaPlugins.onAssembly(new FlowableSingleMaybe(this));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<T> single(T defaultItem) {
        ObjectHelper.requireNonNull(defaultItem, "defaultItem is null");
        return RxJavaPlugins.onAssembly(new FlowableSingleSingle<T>(this, defaultItem));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> skip(long count) {
        if (count <= 0L) {
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new FlowableSkip(this, count));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> skip(long time, TimeUnit unit) {
        return this.skipUntil(Flowable.timer(time, unit));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> skip(long time, TimeUnit unit, Scheduler scheduler) {
        return this.skipUntil(Flowable.timer(time, unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> skipLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new FlowableSkipLast(this, count));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> skipLast(long time, TimeUnit unit) {
        return this.skipLast(time, unit, Schedulers.computation(), false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Flowable<T> skipLast(long time, TimeUnit unit, boolean delayError) {
        return this.skipLast(time, unit, Schedulers.computation(), delayError, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public final Flowable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler) {
        return this.skipLast(time, unit, scheduler, false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public final Flowable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        return this.skipLast(time, unit, scheduler, delayError, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="custom")
    public final Flowable<T> skipLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        int s = bufferSize << 1;
        return RxJavaPlugins.onAssembly(new FlowableSkipLastTimed(this, time, unit, scheduler, s, delayError));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> skipUntil(Publisher<U> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableSkipUntil(this, other));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> skipWhile(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableSkipWhile<T>(this, predicate));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> sorted() {
        return this.toList().toFlowable().map(Functions.listSorter(Functions.naturalComparator())).flatMapIterable(Functions.identity());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> sorted(Comparator<? super T> sortFunction) {
        return this.toList().toFlowable().map(Functions.listSorter(sortFunction)).flatMapIterable(Functions.identity());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> startWith(Iterable<? extends T> items) {
        return Flowable.concatArray(Flowable.fromIterable(items), this);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> startWith(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Flowable.concatArray(other, this);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> startWith(T value) {
        ObjectHelper.requireNonNull(value, "item is null");
        return Flowable.concatArray(Flowable.just(value), this);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> startWithArray(T ... items) {
        Flowable<T> fromArray = Flowable.fromArray(items);
        if (fromArray == Flowable.empty()) {
            return RxJavaPlugins.onAssembly(this);
        }
        return Flowable.concatArray(fromArray, this);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Disposable subscribe() {
        return this.subscribe(Functions.emptyConsumer(), Functions.ERROR_CONSUMER, Functions.EMPTY_ACTION, FlowableInternalHelper.requestMax());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext) {
        return this.subscribe(onNext, Functions.ERROR_CONSUMER, Functions.EMPTY_ACTION, FlowableInternalHelper.requestMax());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError) {
        return this.subscribe(onNext, onError, Functions.EMPTY_ACTION, FlowableInternalHelper.requestMax());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        return this.subscribe(onNext, onError, onComplete, FlowableInternalHelper.requestMax());
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Disposable subscribe(Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Consumer<? super Subscription> onSubscribe) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        ObjectHelper.requireNonNull(onSubscribe, "onSubscribe is null");
        LambdaSubscriber<? super T> ls = new LambdaSubscriber<T>(onNext, onError, onComplete, onSubscribe);
        this.subscribe(ls);
        return ls;
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final void subscribe(Subscriber<? super T> s) {
        ObjectHelper.requireNonNull(s, "s is null");
        try {
            s = RxJavaPlugins.onSubscribe(this, s);
            ObjectHelper.requireNonNull(s, "Plugin returned null Subscriber");
            this.subscribeActual(s);
        }
        catch (NullPointerException e) {
            throw e;
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
            NullPointerException npe = new NullPointerException("Actually not, but can't throw other exceptions due to RS");
            npe.initCause(e);
            throw npe;
        }
    }

    protected abstract void subscribeActual(Subscriber<? super T> var1);

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <E extends Subscriber<? super T>> E subscribeWith(E subscriber) {
        this.subscribe(subscriber);
        return subscriber;
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public final Flowable<T> subscribeOn(Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableSubscribeOn(this, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> switchIfEmpty(Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableSwitchIfEmpty<T>(this, other));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> switchMap(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.switchMap(mapper, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> switchMap(Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize) {
        return this.switchMap0(mapper, bufferSize, false);
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> switchMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper) {
        return this.switchMapDelayError(mapper, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> switchMapDelayError(Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize) {
        return this.switchMap0(mapper, bufferSize, true);
    }

    <R> Flowable<R> switchMap0(Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayError) {
        ObjectHelper.requireNonNull(mapper, "mapper is null");
        if (this instanceof ScalarCallable) {
            Object v = ((ScalarCallable)((Object)this)).call();
            if (v == null) {
                return Flowable.empty();
            }
            return FlowableScalarXMap.scalarXMap(v, mapper);
        }
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableSwitchMap(this, mapper, bufferSize, delayError));
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> take(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0 required but it was " + count);
        }
        return RxJavaPlugins.onAssembly(new FlowableTake(this, count));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> take(long time, TimeUnit unit) {
        return this.takeUntil(Flowable.timer(time, unit));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public final Flowable<T> take(long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeUntil(Flowable.timer(time, unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final Flowable<T> takeFirst(Predicate<? super T> predicate) {
        return this.filter(predicate).take(1L);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> takeLast(int count) {
        if (count < 0) {
            throw new IndexOutOfBoundsException("count >= 0 required but it was " + count);
        }
        if (count == 0) {
            return RxJavaPlugins.onAssembly(new FlowableIgnoreElements(this));
        }
        if (count == 1) {
            return RxJavaPlugins.onAssembly(new FlowableTakeLastOne(this));
        }
        return RxJavaPlugins.onAssembly(new FlowableTakeLast(this, count));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<T> takeLast(long count, long time, TimeUnit unit) {
        return this.takeLast(count, time, unit, Schedulers.computation(), false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long count, long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(count, time, unit, scheduler, false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long count, long time, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        if (count < 0L) {
            throw new IndexOutOfBoundsException("count >= 0 required but it was " + count);
        }
        return RxJavaPlugins.onAssembly(new FlowableTakeLastTimed(this, count, time, unit, scheduler, bufferSize, delayError));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> takeLast(long time, TimeUnit unit) {
        return this.takeLast(time, unit, Schedulers.computation(), false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> takeLast(long time, TimeUnit unit, boolean delayError) {
        return this.takeLast(time, unit, Schedulers.computation(), delayError, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler) {
        return this.takeLast(time, unit, scheduler, false, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        return this.takeLast(time, unit, scheduler, delayError, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> takeLast(long time, TimeUnit unit, Scheduler scheduler, boolean delayError, int bufferSize) {
        return this.takeLast(Long.MAX_VALUE, time, unit, scheduler, delayError, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> takeUntil(Predicate<? super T> stopPredicate) {
        ObjectHelper.requireNonNull(stopPredicate, "stopPredicate is null");
        return RxJavaPlugins.onAssembly(new FlowableTakeUntilPredicate<T>(this, stopPredicate));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U> Flowable<T> takeUntil(Publisher<U> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return RxJavaPlugins.onAssembly(new FlowableTakeUntil(this, other));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<T> takeWhile(Predicate<? super T> predicate) {
        ObjectHelper.requireNonNull(predicate, "predicate is null");
        return RxJavaPlugins.onAssembly(new FlowableTakeWhile<T>(this, predicate));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> throttleFirst(long windowDuration, TimeUnit unit) {
        return this.throttleFirst(windowDuration, unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> throttleFirst(long skipDuration, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableThrottleFirstTimed(this, skipDuration, unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> throttleLast(long intervalDuration, TimeUnit unit) {
        return this.sample(intervalDuration, unit);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> throttleLast(long intervalDuration, TimeUnit unit, Scheduler scheduler) {
        return this.sample(intervalDuration, unit, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> throttleWithTimeout(long timeout, TimeUnit unit) {
        return this.debounce(timeout, unit);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<T> throttleWithTimeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return this.debounce(timeout, unit, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timeInterval() {
        return this.timeInterval(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timeInterval(Scheduler scheduler) {
        return this.timeInterval(TimeUnit.MILLISECONDS, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timeInterval(TimeUnit unit) {
        return this.timeInterval(unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timeInterval(TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableTimeInterval(this, unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <V> Flowable<T> timeout(Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator) {
        return this.timeout0(null, itemTimeoutIndicator, null);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <V> Flowable<T> timeout(Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, Flowable<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(null, itemTimeoutIndicator, other);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> timeout(long timeout, TimeUnit timeUnit) {
        return this.timeout0(timeout, timeUnit, null, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<T> timeout(long timeout, TimeUnit timeUnit, Flowable<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(timeout, timeUnit, other, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="custom")
    public final Flowable<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler, Flowable<? extends T> other) {
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(timeout, timeUnit, other, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public final Flowable<T> timeout(long timeout, TimeUnit timeUnit, Scheduler scheduler) {
        return this.timeout0(timeout, timeUnit, null, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<T> timeout(Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator) {
        ObjectHelper.requireNonNull(firstTimeoutIndicator, "firstTimeoutIndicator is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, null);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<T> timeout(Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(firstTimeoutIndicator, "firstTimeoutSelector is null");
        ObjectHelper.requireNonNull(other, "other is null");
        return this.timeout0(firstTimeoutIndicator, itemTimeoutIndicator, other);
    }

    private Flowable<T> timeout0(long timeout, TimeUnit timeUnit, Flowable<? extends T> other, Scheduler scheduler) {
        ObjectHelper.requireNonNull(timeUnit, "timeUnit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableTimeoutTimed<T>(this, timeout, timeUnit, scheduler, other));
    }

    private <U, V> Flowable<T> timeout0(Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, Publisher<? extends T> other) {
        ObjectHelper.requireNonNull(itemTimeoutIndicator, "itemTimeoutIndicator is null");
        return RxJavaPlugins.onAssembly(new FlowableTimeout(this, firstTimeoutIndicator, itemTimeoutIndicator, other));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timestamp() {
        return this.timestamp(TimeUnit.MILLISECONDS, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timestamp(Scheduler scheduler) {
        return this.timestamp(TimeUnit.MILLISECONDS, scheduler);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timestamp(TimeUnit unit) {
        return this.timestamp(unit, Schedulers.computation());
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final Flowable<Timed<T>> timestamp(TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return this.map(Functions.timestampWith(unit, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.SPECIAL)
    @SchedulerSupport(value="none")
    public final <R> R to(Function<? super Flowable<T>, R> converter) {
        try {
            return converter.apply(this);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<List<T>> toList() {
        return RxJavaPlugins.onAssembly(new FlowableToListSingle(this));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<List<T>> toList(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return RxJavaPlugins.onAssembly(new FlowableToListSingle(this, Functions.createArrayList(capacityHint)));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <U extends Collection<? super T>> Flowable<U> toList(Callable<U> collectionSupplier) {
        ObjectHelper.requireNonNull(collectionSupplier, "collectionSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableToList(this, collectionSupplier));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K> Single<Map<K, T>> toMap(Function<? super T, ? extends K> keySelector) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        return this.collect(HashMapSupplier.asCallable(), Functions.toMapKeySelector(keySelector));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, V>> toMap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, "valueSelector is null");
        return this.collect(HashMapSupplier.asCallable(), Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, V>> toMap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<? extends Map<K, V>> mapSupplier) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, "valueSelector is null");
        return this.collect(mapSupplier, Functions.toMapKeyValueSelector(keySelector, valueSelector));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K> Single<Map<K, Collection<T>>> toMultimap(Function<? super T, ? extends K> keySelector) {
        Function valueSelector = Functions.identity();
        Callable mapSupplier = HashMapSupplier.asCallable();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, Collection<V>>> toMultimap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        Callable mapSupplier = HashMapSupplier.asCallable();
        Function collectionFactory = ArrayListSupplier.asFunction();
        return this.toMultimap(keySelector, valueSelector, mapSupplier, collectionFactory);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, Collection<V>>> toMultimap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<? extends Map<K, Collection<V>>> mapSupplier, Function<? super K, ? extends Collection<? super V>> collectionFactory) {
        ObjectHelper.requireNonNull(keySelector, "keySelector is null");
        ObjectHelper.requireNonNull(valueSelector, "valueSelector is null");
        ObjectHelper.requireNonNull(mapSupplier, "mapSupplier is null");
        ObjectHelper.requireNonNull(collectionFactory, "collectionFactory is null");
        return this.collect(mapSupplier, Functions.toMultimapKeyValueSelector(keySelector, valueSelector, collectionFactory));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final <K, V> Single<Map<K, Collection<V>>> toMultimap(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Callable<Map<K, Collection<V>>> mapSupplier) {
        return this.toMultimap(keySelector, valueSelector, mapSupplier, ArrayListSupplier.asFunction());
    }

    @BackpressureSupport(value=BackpressureKind.NONE)
    @SchedulerSupport(value="none")
    public final Observable<T> toObservable() {
        return RxJavaPlugins.onAssembly(new ObservableFromPublisher(this));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<List<T>> toSortedList() {
        return this.toSortedList(Functions.naturalComparator());
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<List<T>> toSortedList(Comparator<? super T> comparator) {
        ObjectHelper.requireNonNull(comparator, "comparator is null");
        return this.toList().map(Functions.listSorter(comparator));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<List<T>> toSortedList(Comparator<? super T> comparator, int capacityHint) {
        ObjectHelper.requireNonNull(comparator, "comparator is null");
        return this.toList(capacityHint).map(Functions.listSorter(comparator));
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final Single<List<T>> toSortedList(int capacityHint) {
        return this.toSortedList(Functions.naturalComparator(), capacityHint);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="custom")
    public final Flowable<T> unsubscribeOn(Scheduler scheduler) {
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableUnsubscribeOn(this, scheduler));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<Flowable<T>> window(long count) {
        return this.window(count, count, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<Flowable<T>> window(long count, long skip) {
        return this.window(count, skip, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final Flowable<Flowable<T>> window(long count, long skip, int bufferSize) {
        ObjectHelper.verifyPositive(skip, "skip");
        ObjectHelper.verifyPositive(count, "count");
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        return RxJavaPlugins.onAssembly(new FlowableWindow(this, count, skip, bufferSize));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<Flowable<T>> window(long timespan, long timeskip, TimeUnit unit) {
        return this.window(timespan, timeskip, unit, Schedulers.computation(), Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler) {
        return this.window(timespan, timeskip, unit, scheduler, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.verifyPositive(timespan, "timespan");
        ObjectHelper.verifyPositive(timeskip, "timeskip");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.requireNonNull(unit, "unit is null");
        return RxJavaPlugins.onAssembly(new FlowableWindowTimed(this, timespan, timeskip, unit, scheduler, Long.MAX_VALUE, bufferSize, false));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit) {
        return this.window(timespan, unit, Schedulers.computation(), Long.MAX_VALUE, false);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, long count) {
        return this.window(timespan, unit, Schedulers.computation(), count, false);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="io.reactivex:computation")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, long count, boolean restart) {
        return this.window(timespan, unit, Schedulers.computation(), count, restart);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler) {
        return this.window(timespan, unit, scheduler, Long.MAX_VALUE, false);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler, long count) {
        return this.window(timespan, unit, scheduler, count, false);
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler, long count, boolean restart) {
        return this.window(timespan, unit, scheduler, count, restart, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="custom")
    public final Flowable<Flowable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler, long count, boolean restart, int bufferSize) {
        ObjectHelper.verifyPositive(bufferSize, "bufferSize");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.verifyPositive(count, "count");
        return RxJavaPlugins.onAssembly(new FlowableWindowTimed(this, timespan, timespan, unit, scheduler, count, bufferSize, restart));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<Flowable<T>> window(Publisher<B> boundaryIndicator) {
        return this.window(boundaryIndicator, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<Flowable<T>> window(Publisher<B> boundaryIndicator, int bufferSize) {
        ObjectHelper.requireNonNull(boundaryIndicator, "boundaryIndicator is null");
        return RxJavaPlugins.onAssembly(new FlowableWindowBoundary(this, boundaryIndicator, bufferSize));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<Flowable<T>> window(Publisher<U> openingIndicator, Function<? super U, ? extends Publisher<V>> closingIndicator) {
        return this.window(openingIndicator, closingIndicator, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <U, V> Flowable<Flowable<T>> window(Publisher<U> openingIndicator, Function<? super U, ? extends Publisher<V>> closingIndicator, int bufferSize) {
        ObjectHelper.requireNonNull(openingIndicator, "openingIndicator is null");
        ObjectHelper.requireNonNull(closingIndicator, "closingIndicator is null");
        return RxJavaPlugins.onAssembly(new FlowableWindowBoundarySelector(this, openingIndicator, closingIndicator, bufferSize));
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<Flowable<T>> window(Callable<? extends Publisher<B>> boundaryIndicatorSupplier) {
        return this.window(boundaryIndicatorSupplier, Flowable.bufferSize());
    }

    @BackpressureSupport(value=BackpressureKind.ERROR)
    @SchedulerSupport(value="none")
    public final <B> Flowable<Flowable<T>> window(Callable<? extends Publisher<B>> boundaryIndicatorSupplier, int bufferSize) {
        ObjectHelper.requireNonNull(boundaryIndicatorSupplier, "boundaryIndicatorSupplier is null");
        return RxJavaPlugins.onAssembly(new FlowableWindowBoundarySupplier(this, boundaryIndicatorSupplier, bufferSize));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> withLatestFrom(Publisher<? extends U> other, BiFunction<? super T, ? super U, ? extends R> combiner) {
        ObjectHelper.requireNonNull(other, "other is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new FlowableWithLatestFrom<T, U, R>(this, combiner, other));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <T1, T2, R> Flowable<R> withLatestFrom(Publisher<T1> source1, Publisher<T2> source2, Function3<? super T, ? super T1, ? super T2, R> combiner) {
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new Publisher[]{source1, source2}, f);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <T1, T2, T3, R> Flowable<R> withLatestFrom(Publisher<T1> source1, Publisher<T2> source2, Publisher<T3> source3, Function4<? super T, ? super T1, ? super T2, ? super T3, R> combiner) {
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new Publisher[]{source1, source2, source3}, f);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <T1, T2, T3, T4, R> Flowable<R> withLatestFrom(Publisher<T1> source1, Publisher<T2> source2, Publisher<T3> source3, Publisher<T4> source4, Function5<? super T, ? super T1, ? super T2, ? super T3, ? super T4, R> combiner) {
        Function<Object[], R> f = Functions.toFunction(combiner);
        return this.withLatestFrom(new Publisher[]{source1, source2, source3, source4}, f);
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> withLatestFrom(Publisher<?>[] others, Function<? super Object[], R> combiner) {
        ObjectHelper.requireNonNull(others, "others is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new FlowableWithLatestFromMany(this, others, combiner));
    }

    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @SchedulerSupport(value="none")
    public final <R> Flowable<R> withLatestFrom(Iterable<? extends Publisher<?>> others, Function<? super Object[], R> combiner) {
        ObjectHelper.requireNonNull(others, "others is null");
        ObjectHelper.requireNonNull(combiner, "combiner is null");
        return RxJavaPlugins.onAssembly(new FlowableWithLatestFromMany(this, others, combiner));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> zipWith(Iterable<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        ObjectHelper.requireNonNull(other, "other is null");
        ObjectHelper.requireNonNull(zipper, "zipper is null");
        return RxJavaPlugins.onAssembly(new FlowableZipIterable<T, U, R>(this, other, zipper));
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> zipWith(Publisher<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        ObjectHelper.requireNonNull(other, "other is null");
        return Flowable.zip(this, other, zipper);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> zipWith(Publisher<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError) {
        return Flowable.zip(this, other, zipper, delayError);
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final <U, R> Flowable<R> zipWith(Publisher<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper, boolean delayError, int bufferSize) {
        return Flowable.zip(this, other, zipper, delayError, bufferSize);
    }

    @BackpressureSupport(value=BackpressureKind.UNBOUNDED_IN)
    @SchedulerSupport(value="none")
    public final TestSubscriber<T> test() {
        TestSubscriber ts = new TestSubscriber();
        this.subscribe(ts);
        return ts;
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final TestSubscriber<T> test(long initialRequest) {
        TestSubscriber ts = new TestSubscriber(initialRequest);
        this.subscribe(ts);
        return ts;
    }

    @BackpressureSupport(value=BackpressureKind.FULL)
    @SchedulerSupport(value="none")
    public final TestSubscriber<T> test(long initialRequest, boolean cancel) {
        TestSubscriber ts = new TestSubscriber(initialRequest);
        if (cancel) {
            ts.cancel();
        }
        this.subscribe(ts);
        return ts;
    }
}

