/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.schedulers;

import io.reactivex.Scheduler;
import io.reactivex.internal.schedulers.ComputationScheduler;
import io.reactivex.internal.schedulers.ExecutorScheduler;
import io.reactivex.internal.schedulers.IoScheduler;
import io.reactivex.internal.schedulers.NewThreadScheduler;
import io.reactivex.internal.schedulers.SchedulerPoolFactory;
import io.reactivex.internal.schedulers.SingleScheduler;
import io.reactivex.internal.schedulers.TrampolineScheduler;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Executor;

public final class Schedulers {
    static final Scheduler SINGLE = RxJavaPlugins.initSingleScheduler(new SingleScheduler());
    static final Scheduler COMPUTATION = RxJavaPlugins.initComputationScheduler(new ComputationScheduler());
    static final Scheduler IO = RxJavaPlugins.initIoScheduler(new IoScheduler());
    static final Scheduler TRAMPOLINE = TrampolineScheduler.instance();
    static final Scheduler NEW_THREAD = RxJavaPlugins.initNewThreadScheduler(NewThreadScheduler.instance());

    private Schedulers() {
        throw new IllegalStateException("No instances!");
    }

    public static Scheduler computation() {
        return RxJavaPlugins.onComputationScheduler(COMPUTATION);
    }

    public static Scheduler io() {
        return RxJavaPlugins.onIoScheduler(IO);
    }

    public static Scheduler trampoline() {
        return TRAMPOLINE;
    }

    public static Scheduler newThread() {
        return RxJavaPlugins.onNewThreadScheduler(NEW_THREAD);
    }

    public static Scheduler single() {
        return RxJavaPlugins.onSingleScheduler(SINGLE);
    }

    public static Scheduler from(Executor executor) {
        return new ExecutorScheduler(executor);
    }

    public static void shutdown() {
        Schedulers.computation().shutdown();
        Schedulers.io().shutdown();
        Schedulers.newThread().shutdown();
        Schedulers.single().shutdown();
        Schedulers.trampoline().shutdown();
        SchedulerPoolFactory.shutdown();
    }

    public static void start() {
        Schedulers.computation().start();
        Schedulers.io().start();
        Schedulers.newThread().start();
        Schedulers.single().start();
        Schedulers.trampoline().start();
        SchedulerPoolFactory.start();
    }
}

