/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;
import java.util.concurrent.Callable;

public final class ObservableFromCallable<T>
extends Observable<T> {
    final Callable<? extends T> callable;

    public ObservableFromCallable(Callable<? extends T> callable) {
        this.callable = callable;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        T value;
        Disposable d = Disposables.empty();
        s.onSubscribe(d);
        if (d.isDisposed()) {
            return;
        }
        try {
            value = this.callable.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            if (!d.isDisposed()) {
                s.onError(e);
            }
            return;
        }
        if (d.isDisposed()) {
            return;
        }
        if (value != null) {
            s.onNext(value);
            s.onComplete();
        } else {
            s.onError(new NullPointerException("Callable returned null"));
        }
    }
}

