/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.observable.QueueDrainObserver;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableBufferBoundarySupplier<T, U extends Collection<? super T>, B>
extends AbstractObservableWithUpstream<T, U> {
    final Callable<? extends ObservableSource<B>> boundarySupplier;
    final Callable<U> bufferSupplier;

    public ObservableBufferBoundarySupplier(ObservableSource<T> source, Callable<? extends ObservableSource<B>> boundarySupplier, Callable<U> bufferSupplier) {
        super(source);
        this.boundarySupplier = boundarySupplier;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t) {
        this.source.subscribe(new BufferBoundarySupplierSubscriber(new SerializedObserver<U>(t), this.bufferSupplier, this.boundarySupplier));
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends DisposableObserver<B> {
        final BufferBoundarySupplierSubscriber<T, U, B> parent;
        boolean once;

        public BufferBoundarySubscriber(BufferBoundarySupplierSubscriber<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            if (this.once) {
                return;
            }
            this.once = true;
            this.dispose();
            this.parent.next();
        }

        @Override
        public void onError(Throwable t) {
            if (this.once) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.once = true;
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.once) {
                return;
            }
            this.once = true;
            this.parent.next();
        }
    }

    static final class BufferBoundarySupplierSubscriber<T, U extends Collection<? super T>, B>
    extends QueueDrainObserver<T, U, U>
    implements Observer<T>,
    Disposable {
        final Callable<U> bufferSupplier;
        final Callable<? extends ObservableSource<B>> boundarySupplier;
        Disposable s;
        final AtomicReference<Disposable> other = new AtomicReference();
        U buffer;

        public BufferBoundarySupplierSubscriber(Observer<? super U> actual, Callable<U> bufferSupplier, Callable<? extends ObservableSource<B>> boundarySupplier) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundarySupplier = boundarySupplier;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                ObservableSource<B> boundary;
                Collection b;
                this.s = s;
                Observer actual = this.actual;
                try {
                    b = (Collection)this.bufferSupplier.call();
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancelled = true;
                    s.dispose();
                    EmptyDisposable.error(e, actual);
                    return;
                }
                if (b == null) {
                    this.cancelled = true;
                    s.dispose();
                    EmptyDisposable.error((Throwable)new NullPointerException("The buffer supplied is null"), actual);
                    return;
                }
                this.buffer = b;
                try {
                    boundary = this.boundarySupplier.call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.cancelled = true;
                    s.dispose();
                    EmptyDisposable.error(ex, actual);
                    return;
                }
                if (boundary == null) {
                    this.cancelled = true;
                    s.dispose();
                    EmptyDisposable.error((Throwable)new NullPointerException("The boundary publisher supplied is null"), actual);
                    return;
                }
                BufferBoundarySubscriber bs = new BufferBoundarySubscriber(this);
                this.other.set(bs);
                actual.onSubscribe(this);
                if (!this.cancelled) {
                    boundary.subscribe(bs);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferBoundarySupplierSubscriber bufferBoundarySupplierSubscriber = this;
            synchronized (bufferBoundarySupplierSubscriber) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.dispose();
            this.actual.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferBoundarySupplierSubscriber bufferBoundarySupplierSubscriber = this;
            synchronized (bufferBoundarySupplierSubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(this.queue, this.actual, false, this, this);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.dispose();
                this.disposeOther();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeOther() {
            DisposableHelper.dispose(this.other);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b;
            ObservableSource<B> boundary;
            Collection next;
            try {
                next = (Collection)this.bufferSupplier.call();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.dispose();
                this.actual.onError(e);
                return;
            }
            if (next == null) {
                this.dispose();
                this.actual.onError(new NullPointerException("The buffer supplied is null"));
                return;
            }
            try {
                boundary = this.boundarySupplier.call();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.cancelled = true;
                this.s.dispose();
                this.actual.onError(ex);
                return;
            }
            if (boundary == null) {
                this.cancelled = true;
                this.s.dispose();
                this.actual.onError(new NullPointerException("The boundary publisher supplied is null"));
                return;
            }
            BufferBoundarySubscriber bs = new BufferBoundarySubscriber(this);
            Disposable o = this.other.get();
            if (!this.other.compareAndSet(o, bs)) {
                return;
            }
            BufferBoundarySupplierSubscriber bufferBoundarySupplierSubscriber = this;
            synchronized (bufferBoundarySupplierSubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = next;
            }
            boundary.subscribe(bs);
            this.fastPathEmit(b, false, this);
        }

        @Override
        public void accept(Observer<? super U> a, U v) {
            this.actual.onNext(v);
        }
    }
}

