/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.HasUpstreamMaybeSource;
import java.util.NoSuchElementException;

public final class MaybeToSingle<T>
extends Single<T>
implements HasUpstreamMaybeSource<T> {
    final MaybeSource<T> source;

    public MaybeToSingle(MaybeSource<T> source) {
        this.source = source;
    }

    @Override
    public MaybeSource<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new ToSingleMaybeSubscriber<T>(observer));
    }

    static final class ToSingleMaybeSubscriber<T>
    implements MaybeObserver<T>,
    Disposable {
        final SingleObserver<? super T> actual;
        Disposable d;

        public ToSingleMaybeSubscriber(SingleObserver<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onError(e);
        }

        @Override
        public void onComplete() {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onError(new NoSuchElementException("The MaybeSource is empty"));
        }
    }
}

