/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.Maybe;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.fuseable.HasUpstreamPublisher;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MaybeFromPublisher<T>
extends Maybe<T>
implements HasUpstreamPublisher<T> {
    final Publisher<T> source;

    public MaybeFromPublisher(Publisher<T> source) {
        this.source = source;
    }

    @Override
    public Publisher<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new FromPublisherToMaybeObserver<T>(observer));
    }

    static final class FromPublisherToMaybeObserver<T>
    extends AtomicReference<Subscription>
    implements Subscriber<T>,
    Disposable {
        private static final long serialVersionUID = -8017657973346356002L;
        final MaybeObserver<? super T> actual;
        T value;

        public FromPublisherToMaybeObserver(MaybeObserver<? super T> observer) {
            this.actual = observer;
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public boolean isDisposed() {
            return SubscriptionHelper.isCancelled((Subscription)this.get());
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (!this.isDisposed()) {
                if (this.value != null) {
                    ((Subscription)this.get()).cancel();
                    this.onError(new IndexOutOfBoundsException("The source Publisher produced more than one item"));
                } else {
                    this.value = t;
                }
            }
        }

        public void onError(Throwable t) {
            if (!this.isDisposed()) {
                this.value = null;
                this.lazySet(SubscriptionHelper.CANCELLED);
                this.actual.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (!this.isDisposed()) {
                this.lazySet(SubscriptionHelper.CANCELLED);
                T v = this.value;
                if (v == null) {
                    this.actual.onComplete();
                } else {
                    this.actual.onSuccess(v);
                }
            }
        }
    }
}

