/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowablePublishMulticast<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector;
    final int prefetch;
    final boolean delayError;

    public FlowablePublishMulticast(Publisher<T> source, Function<? super Flowable<T>, ? extends Publisher<? extends R>> selector, int prefetch, boolean delayError) {
        super(source);
        this.selector = selector;
        this.prefetch = prefetch;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        Publisher<? extends R> other;
        MulticastProcessor mp = new MulticastProcessor(this.prefetch, this.delayError);
        try {
            other = ObjectHelper.requireNonNull(this.selector.apply(mp), "selector returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, s);
            return;
        }
        OutputCanceller<? super R> out = new OutputCanceller<R>(s, mp);
        other.subscribe(out);
        this.source.subscribe(mp);
    }

    static final class MulticastSubscription<T>
    extends AtomicLong
    implements Subscription {
        private static final long serialVersionUID = 8664815189257569791L;
        final Subscriber<? super T> actual;
        final MulticastProcessor<T> parent;

        public MulticastSubscription(Subscriber<? super T> actual, MulticastProcessor<T> parent) {
            this.actual = actual;
            this.parent = parent;
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                long u;
                long r;
                do {
                    if ((r = this.get()) != Long.MIN_VALUE) continue;
                    return;
                } while (r != Long.MAX_VALUE && !this.compareAndSet(r, u = BackpressureHelper.addCap(r, n)));
                this.parent.drain();
            }
        }

        public void cancel() {
            this.getAndSet(Long.MIN_VALUE);
            this.parent.remove(this);
        }

        public boolean isCancelled() {
            return this.get() == Long.MIN_VALUE;
        }
    }

    static final class MulticastProcessor<T>
    extends Flowable<T>
    implements Subscriber<T>,
    Disposable {
        static final MulticastSubscription[] EMPTY = new MulticastSubscription[0];
        static final MulticastSubscription[] TERMINATED = new MulticastSubscription[0];
        final AtomicInteger wip;
        final AtomicReference<MulticastSubscription<T>[]> subscribers;
        final int prefetch;
        final int limit;
        final boolean delayError;
        final AtomicReference<Subscription> s;
        SimpleQueue<T> queue;
        int sourceMode;
        volatile boolean done;
        Throwable error;

        public MulticastProcessor(int prefetch, boolean delayError) {
            this.prefetch = prefetch;
            this.delayError = delayError;
            this.limit = prefetch - (prefetch >> 2);
            this.wip = new AtomicInteger();
            this.s = new AtomicReference();
            this.subscribers = new AtomicReference<MulticastSubscription[]>(EMPTY);
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.s, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        QueueDrainHelper.request(s, this.prefetch);
                        return;
                    }
                }
                this.queue = QueueDrainHelper.createQueue(this.prefetch);
                QueueDrainHelper.request(s, this.prefetch);
            }
        }

        @Override
        public void dispose() {
            SubscriptionHelper.cancel(this.s);
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return SubscriptionHelper.isCancelled(this.s.get());
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                SubscriptionHelper.cancel(this.s);
                this.onError(new MissingBackpressureException());
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.drain();
            }
        }

        boolean add(MulticastSubscription<T> s) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                if ((current = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int n = current.length;
                next = new MulticastSubscription[n + 1];
                System.arraycopy(current, 0, next, 0, n);
                next[n] = s;
            } while (!this.subscribers.compareAndSet(current, next));
            return true;
        }

        void remove(MulticastSubscription<T> s) {
            MulticastSubscription[] next;
            MulticastSubscription<T>[] current;
            do {
                if ((current = this.subscribers.get()) == TERMINATED || current == EMPTY) {
                    return;
                }
                int n = current.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (current[i] != s) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    next = EMPTY;
                    continue;
                }
                next = new MulticastSubscription[n - 1];
                System.arraycopy(current, 0, next, 0, j);
                System.arraycopy(current, j + 1, next, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(current, next));
        }

        @Override
        protected void subscribeActual(Subscriber<? super T> s) {
            MulticastSubscription<T> ms = new MulticastSubscription<T>(s, this);
            s.onSubscribe(ms);
            if (this.add(ms)) {
                if (ms.isCancelled()) {
                    this.remove(ms);
                    return;
                }
                this.drain();
            } else {
                Throwable ex = this.error;
                if (ex != null) {
                    s.onError(ex);
                } else {
                    s.onComplete();
                }
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimpleQueue<T> q = this.queue;
            while (true) {
                MulticastSubscription<T>[] array = this.subscribers.get();
                int n = array.length;
                if (q != null && n != 0) {
                    Throwable ex;
                    boolean d;
                    long e;
                    long r = Long.MAX_VALUE;
                    for (MulticastSubscription<T> ms : array) {
                        long u = ms.get();
                        if (u == Long.MIN_VALUE || r <= u) continue;
                        r = u;
                    }
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        T v;
                        if (this.isDisposed()) {
                            q.clear();
                            return;
                        }
                        d = this.done;
                        if (d && !this.delayError && (ex = this.error) != null) {
                            this.errorAll(ex);
                            return;
                        }
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex2) {
                            Exceptions.throwIfFatal(ex2);
                            SubscriptionHelper.cancel(this.s);
                            this.errorAll(ex2);
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (d && empty) {
                            Throwable ex3 = this.error;
                            if (ex3 != null) {
                                this.errorAll(ex3);
                            } else {
                                this.completeAll();
                            }
                            return;
                        }
                        if (empty) break;
                        for (MulticastSubscription<T> ms : array) {
                            if (ms.get() == Long.MIN_VALUE) continue;
                            ms.actual.onNext(v);
                        }
                    }
                    if (e == r) {
                        if (this.isDisposed()) {
                            q.clear();
                            return;
                        }
                        d = this.done;
                        if (d && !this.delayError && (ex = this.error) != null) {
                            this.errorAll(ex);
                            return;
                        }
                        if (d && q.isEmpty()) {
                            ex = this.error;
                            if (ex != null) {
                                this.errorAll(ex);
                            } else {
                                this.completeAll();
                            }
                            return;
                        }
                    }
                    for (MulticastSubscription<T> ms : array) {
                        BackpressureHelper.produced(ms, e);
                    }
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                if (q != null) continue;
                q = this.queue;
            }
        }

        void errorAll(Throwable ex) {
            for (MulticastSubscription ms : this.subscribers.getAndSet(TERMINATED)) {
                if (ms.get() == Long.MIN_VALUE) continue;
                ms.actual.onError(ex);
            }
        }

        void completeAll() {
            for (MulticastSubscription ms : this.subscribers.getAndSet(TERMINATED)) {
                if (ms.get() == Long.MIN_VALUE) continue;
                ms.actual.onComplete();
            }
        }
    }

    static final class OutputCanceller<R>
    implements Subscriber<R>,
    Subscription {
        final Subscriber<? super R> actual;
        final MulticastProcessor<?> processor;
        Subscription s;

        public OutputCanceller(Subscriber<? super R> actual, MulticastProcessor<?> processor) {
            this.actual = actual;
            this.processor = processor;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(R t) {
            this.actual.onNext(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            try {
                this.actual.onError(t);
            }
            finally {
                this.processor.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            try {
                this.actual.onComplete();
            }
            finally {
                this.processor.dispose();
            }
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            this.processor.dispose();
        }
    }
}

