/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnBackpressureLatest<T>
extends AbstractFlowableWithUpstream<T, T> {
    public FlowableOnBackpressureLatest(Publisher<T> source) {
        super(source);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new BackpressureLatestSubscriber<T>(s));
    }

    static final class BackpressureLatestSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 163080509307634843L;
        final Subscriber<? super T> actual;
        Subscription s;
        volatile boolean done;
        Throwable error;
        volatile boolean cancelled;
        final AtomicLong requested = new AtomicLong();
        final AtomicReference<T> current = new AtomicReference();

        public BackpressureLatestSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            this.current.lazySet(t);
            this.drain();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.getAndIncrement() == 0) {
                    this.current.lazySet(null);
                    this.s.cancel();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<? super T> a = this.actual;
            int missed = 1;
            do {
                if (this.checkTerminated(this.done, this.current.get() == null, a)) {
                    return;
                }
                long r = this.requested.get();
                while (r != 0L) {
                    boolean empty;
                    boolean d = this.done;
                    Object v = this.current.getAndSet(null);
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                    if (r == Long.MAX_VALUE) continue;
                    --r;
                    this.requested.decrementAndGet();
                }
                if (!this.checkTerminated(this.done, this.current.get() == null, a)) continue;
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a) {
            if (this.cancelled) {
                this.current.lazySet(null);
                this.s.cancel();
                return true;
            }
            if (d) {
                Throwable e = this.error;
                if (e != null) {
                    this.current.lazySet(null);
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }
    }
}

