/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Notification;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMaterialize<T>
extends AbstractFlowableWithUpstream<T, Notification<T>> {
    public FlowableMaterialize(Publisher<T> source) {
        super(source);
    }

    @Override
    protected void subscribeActual(Subscriber<? super Notification<T>> s) {
        this.source.subscribe(new MaterializeSubscriber(s));
    }

    static final class MaterializeSubscriber<T>
    extends AtomicLong
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3740826063558713822L;
        final Subscriber<? super Notification<T>> actual;
        Subscription s;
        final AtomicInteger state = new AtomicInteger();
        Notification<T> value;
        volatile boolean done;
        static final int NO_REQUEST_NO_VALUE = 0;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;

        public MaterializeSubscriber(Subscriber<? super Notification<T>> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(Notification.createOnNext(t));
            if (this.get() != Long.MAX_VALUE) {
                this.decrementAndGet();
            }
        }

        void tryEmit(Notification<T> v) {
            if (this.get() == 0L) {
                while (true) {
                    int s;
                    if ((s = this.state.get()) == 2) {
                        if (!this.state.compareAndSet(s, 3)) continue;
                        this.actual.onNext(v);
                        this.actual.onComplete();
                        return;
                    }
                    if (s == 1) {
                        return;
                    }
                    if (s == 3) {
                        this.value = null;
                        return;
                    }
                    this.value = v;
                    this.done = true;
                    if (this.state.compareAndSet(s, 1)) break;
                }
                return;
            }
            this.state.lazySet(3);
            this.actual.onNext(v);
            this.actual.onComplete();
        }

        public void onError(Throwable t) {
            Notification v = Notification.createOnError(t);
            this.tryEmit(v);
        }

        public void onComplete() {
            Notification v = Notification.createOnComplete();
            this.tryEmit(v);
        }

        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            BackpressureHelper.add(this, n);
            if (this.done) {
                while (true) {
                    int s;
                    if ((s = this.state.get()) == 1) {
                        if (!this.state.compareAndSet(s, 3)) continue;
                        Notification<T> v = this.value;
                        this.value = null;
                        this.actual.onNext(v);
                        this.actual.onComplete();
                        return;
                    }
                    if (s == 2 || s == 3) {
                        return;
                    }
                    if (this.state.compareAndSet(s, 2)) break;
                }
                return;
            }
            this.s.request(n);
        }

        public void cancel() {
            this.state.lazySet(3);
            this.s.cancel();
        }
    }
}

