/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.fuseable.ConditionalSubscriber;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscribers.flowable.BasicFuseableConditionalSubscriber;
import io.reactivex.internal.subscribers.flowable.BasicFuseableSubscriber;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableDistinctUntilChanged<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiPredicate<? super T, ? super T> comparer;

    public FlowableDistinctUntilChanged(Publisher<T> source, BiPredicate<? super T, ? super T> comparer) {
        super(source);
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            ConditionalSubscriber cs = (ConditionalSubscriber)s;
            this.source.subscribe(new DistinctUntilChangedConditionalSubscriber<T>(cs, this.comparer));
        } else {
            this.source.subscribe(new DistinctUntilChangedSubscriber<T>(s, this.comparer));
        }
    }

    static final class DistinctUntilChangedConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final BiPredicate<? super T, ? super T> comparer;
        T last;
        boolean hasValue;

        public DistinctUntilChangedConditionalSubscriber(ConditionalSubscriber<? super T> actual, BiPredicate<? super T, ? super T> comparer) {
            super(actual);
            this.comparer = comparer;
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                return this.actual.tryOnNext(t);
            }
            if (this.hasValue) {
                boolean equal;
                try {
                    equal = this.comparer.test(this.last, t);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                    return false;
                }
                this.last = t;
                return !equal && this.actual.tryOnNext(t);
            }
            this.hasValue = true;
            this.last = t;
            return this.actual.tryOnNext(t);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public T poll() throws Exception {
            Object v;
            while ((v = this.qs.poll()) != null) {
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = v;
                    return v;
                }
                if (!this.comparer.test(this.last, v)) {
                    this.last = v;
                    return v;
                }
                this.last = v;
                if (this.sourceMode == 1) continue;
                this.s.request(1L);
            }
            return null;
        }
    }

    static final class DistinctUntilChangedSubscriber<T>
    extends BasicFuseableSubscriber<T, T>
    implements ConditionalSubscriber<T> {
        final BiPredicate<? super T, ? super T> comparer;
        T last;
        boolean hasValue;

        public DistinctUntilChangedSubscriber(Subscriber<? super T> actual, BiPredicate<? super T, ? super T> comparer) {
            super(actual);
            this.comparer = comparer;
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(t);
                return true;
            }
            if (this.hasValue) {
                boolean equal;
                try {
                    equal = this.comparer.test(this.last, t);
                }
                catch (Throwable ex) {
                    this.fail(ex);
                    return false;
                }
                this.last = t;
                if (equal) {
                    return false;
                }
                this.actual.onNext(t);
                return true;
            }
            this.hasValue = true;
            this.last = t;
            this.actual.onNext(t);
            return true;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        public T poll() throws Exception {
            Object v;
            while ((v = this.qs.poll()) != null) {
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = v;
                    return v;
                }
                if (!this.comparer.test(this.last, v)) {
                    this.last = v;
                    return v;
                }
                this.last = v;
                if (this.sourceMode == 1) continue;
                this.s.request(1L);
            }
            return null;
        }
    }
}

