/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.internal.util.LinkedArrayList;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCache<T>
extends AbstractFlowableWithUpstream<T, T> {
    final CacheState<T> state;
    final AtomicBoolean once;

    public static <T> Flowable<T> from(Flowable<T> source) {
        return FlowableCache.from(source, 16);
    }

    public static <T> Flowable<T> from(Flowable<T> source, int capacityHint) {
        if (capacityHint < 1) {
            throw new IllegalArgumentException("capacityHint > 0 required");
        }
        CacheState<T> state = new CacheState<T>(source, capacityHint);
        return RxJavaPlugins.onAssembly(new FlowableCache<T>(source, state));
    }

    private FlowableCache(Flowable<T> source, CacheState<T> state) {
        super(source);
        this.state = state;
        this.once = new AtomicBoolean();
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> t) {
        ReplaySubscription<? super T> rp = new ReplaySubscription<T>(t, this.state);
        this.state.addProducer(rp);
        t.onSubscribe(rp);
        if (!this.once.get() && this.once.compareAndSet(false, true)) {
            this.state.connect();
        }
    }

    boolean isConnected() {
        return this.state.isConnected;
    }

    boolean hasSubscribers() {
        return this.state.producers.length != 0;
    }

    int cachedEventCount() {
        return this.state.size();
    }

    static final class ReplaySubscription<T>
    extends AtomicLong
    implements Subscription,
    Disposable {
        private static final long serialVersionUID = -2557562030197141021L;
        private static final long CANCELLED = -1L;
        final Subscriber<? super T> child;
        final CacheState<T> state;
        Object[] currentBuffer;
        int currentIndexInBuffer;
        int index;
        boolean emitting;
        boolean missed;

        public ReplaySubscription(Subscriber<? super T> child, CacheState<T> state) {
            this.child = child;
            this.state = state;
        }

        public void request(long n) {
            long u;
            long r;
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            do {
                if ((r = this.get()) != -1L) continue;
                return;
            } while (!this.compareAndSet(r, u = BackpressureHelper.addCap(r, n)));
            this.replay();
        }

        public long produced(long n) {
            return this.addAndGet(-n);
        }

        @Override
        public boolean isDisposed() {
            return this.get() == -1L;
        }

        @Override
        public void dispose() {
            long r = this.get();
            if (r != -1L && (r = this.getAndSet(-1L)) != -1L) {
                this.state.removeProducer(this);
            }
        }

        public void cancel() {
            this.dispose();
        }

        /*
         * Exception decompiling
         */
        public void replay() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [47[UNCONDITIONALDOLOOP]], but top level block is 25[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static final class CacheState<T>
    extends LinkedArrayList
    implements Subscriber<T> {
        final Flowable<? extends T> source;
        final AtomicReference<Subscription> connection = new AtomicReference();
        volatile ReplaySubscription<?>[] producers;
        static final ReplaySubscription<?>[] EMPTY = new ReplaySubscription[0];
        volatile boolean isConnected;
        boolean sourceDone;

        public CacheState(Flowable<? extends T> source, int capacityHint) {
            super(capacityHint);
            this.source = source;
            this.producers = EMPTY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProducer(ReplaySubscription<T> p) {
            AtomicReference<Subscription> atomicReference = this.connection;
            synchronized (atomicReference) {
                ReplaySubscription<?>[] a = this.producers;
                int n = a.length;
                ReplaySubscription[] b = new ReplaySubscription[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = p;
                this.producers = b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProducer(ReplaySubscription<T> p) {
            AtomicReference<Subscription> atomicReference = this.connection;
            synchronized (atomicReference) {
                ReplaySubscription<?>[] a = this.producers;
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (!a[i].equals(p)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    this.producers = EMPTY;
                    return;
                }
                ReplaySubscription[] b = new ReplaySubscription[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
                this.producers = b;
            }
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.connection, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void connect() {
            this.source.subscribe(this);
            this.isConnected = true;
        }

        public void onNext(T t) {
            if (!this.sourceDone) {
                Object o = NotificationLite.next(t);
                this.add(o);
                this.dispatch();
            }
        }

        public void onError(Throwable e) {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.error(e);
                this.add(o);
                SubscriptionHelper.cancel(this.connection);
                this.dispatch();
            }
        }

        public void onComplete() {
            if (!this.sourceDone) {
                this.sourceDone = true;
                Object o = NotificationLite.complete();
                this.add(o);
                SubscriptionHelper.cancel(this.connection);
                this.dispatch();
            }
        }

        void dispatch() {
            ReplaySubscription<?>[] a;
            for (ReplaySubscription<?> rp : a = this.producers) {
                rp.replay();
            }
        }
    }
}

