/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public final class CompletableDelay
extends Completable {
    final CompletableSource source;
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public CompletableDelay(CompletableSource source, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        this.source = source;
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(final CompletableObserver s) {
        final CompositeDisposable set = new CompositeDisposable();
        this.source.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                set.add(CompletableDelay.this.scheduler.scheduleDirect(new Runnable(){

                    @Override
                    public void run() {
                        s.onComplete();
                    }
                }, CompletableDelay.this.delay, CompletableDelay.this.unit));
            }

            @Override
            public void onError(final Throwable e) {
                if (CompletableDelay.this.delayError) {
                    set.add(CompletableDelay.this.scheduler.scheduleDirect(new Runnable(){

                        @Override
                        public void run() {
                            s.onError(e);
                        }
                    }, CompletableDelay.this.delay, CompletableDelay.this.unit));
                } else {
                    s.onError(e);
                }
            }

            @Override
            public void onSubscribe(Disposable d) {
                set.add(d);
                s.onSubscribe(set);
            }
        });
    }
}

