/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subscribers;

import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SafeSubscriber<T>
implements Subscriber<T> {
    final Subscriber<? super T> actual;
    Subscription subscription;
    boolean done;

    public SafeSubscriber(Subscriber<? super T> actual) {
        this.actual = actual;
    }

    public void onSubscribe(Subscription s) {
        if (this.done) {
            return;
        }
        if (this.subscription != null) {
            IllegalStateException ise = new IllegalStateException("Subscription already set!");
            try {
                s.cancel();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                ise.initCause(e);
            }
            this.onError(ise);
            return;
        }
        if (s == null) {
            this.subscription = EmptySubscription.INSTANCE;
            this.onError(new NullPointerException("Subscription is null!"));
            return;
        }
        this.subscription = s;
        try {
            this.actual.onSubscribe(s);
        }
        catch (Throwable e2) {
            CompositeException e2;
            Exceptions.throwIfFatal(e2);
            this.done = true;
            try {
                s.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                CompositeException ce = new CompositeException();
                ce.suppress(e1);
                ce.suppress(e2);
                e2 = ce;
            }
            RxJavaPlugins.onError(e2);
        }
    }

    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (t == null) {
            this.onError(new NullPointerException());
            return;
        }
        if (this.subscription == null) {
            this.onError(null);
            return;
        }
        try {
            this.actual.onNext(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            this.onError(e);
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.subscription == null) {
            CompositeException t2 = new CompositeException(t, new NullPointerException("Subscription not set!"));
            try {
                this.actual.onSubscribe((Subscription)EmptySubscription.INSTANCE);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                t2.suppress(e);
                RxJavaPlugins.onError(t2);
                return;
            }
            try {
                this.actual.onError((Throwable)t2);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                t2.suppress(e);
                RxJavaPlugins.onError(t2);
            }
            return;
        }
        CompositeException t2 = null;
        if (t == null) {
            t = new NullPointerException();
        }
        try {
            this.subscription.cancel();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            t2 = new CompositeException(e, t);
        }
        try {
            if (t2 != null) {
                this.actual.onError(t2);
            } else {
                this.actual.onError(t);
            }
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            if (t2 == null) {
                t2 = new CompositeException(t, e);
            } else {
                t2.suppress(e);
            }
            RxJavaPlugins.onError(t2);
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        if (this.subscription == null) {
            this.onError(null);
            return;
        }
        this.done = true;
        try {
            this.subscription.cancel();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                this.actual.onError(e);
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                RxJavaPlugins.onError(new CompositeException(e1, e));
            }
            return;
        }
        try {
            this.actual.onComplete();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
    }
}

