/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.processors;

import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.IntFunction;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class PublishProcessor<T>
extends FlowableProcessor<T> {
    final State<T> state = new State();
    boolean done;

    public static <T> PublishProcessor<T> create() {
        return new PublishProcessor<T>();
    }

    protected PublishProcessor() {
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.state.subscribe(s);
    }

    public void onSubscribe(Subscription s) {
        if (this.done) {
            s.cancel();
            return;
        }
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (t == null) {
            this.onError(new NullPointerException());
            return;
        }
        for (PublishSubscriber<T> s : this.state.subscribers()) {
            s.onNext(t);
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        if (t == null) {
            t = new NullPointerException();
        }
        for (PublishSubscriber<T> s : this.state.terminate(t)) {
            s.onError(t);
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        for (PublishSubscriber<T> s : this.state.terminate()) {
            s.onComplete();
        }
    }

    @Override
    public boolean hasSubscribers() {
        return this.state.subscribers().length != 0;
    }

    @Override
    public Throwable getThrowable() {
        Object o = this.state.get();
        if (o == State.COMPLETE) {
            return null;
        }
        return (Throwable)o;
    }

    @Override
    public boolean hasThrowable() {
        Object o = this.state.get();
        return o != null && o != State.COMPLETE;
    }

    @Override
    public boolean hasComplete() {
        return this.state.get() == State.COMPLETE;
    }

    static final class PublishSubscriber<T>
    extends AtomicLong
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 3562861878281475070L;
        final Subscriber<? super T> actual;
        final State<T> state;
        final AtomicBoolean cancelled = new AtomicBoolean();

        public PublishSubscriber(Subscriber<? super T> actual, State<T> state) {
            this.actual = actual;
            this.state = state;
        }

        public void onSubscribe(Subscription s) {
        }

        public void onNext(T t) {
            long r = this.get();
            if (r != 0L) {
                this.actual.onNext(t);
                if (r != Long.MAX_VALUE) {
                    this.decrementAndGet();
                }
            } else {
                this.cancel();
                this.actual.onError((Throwable)new MissingBackpressureException("Could not emit value due to lack of requests"));
            }
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
            }
        }

        public void cancel() {
            if (!this.cancelled.get() && this.cancelled.compareAndSet(false, true)) {
                this.state.remove(this);
            }
        }
    }

    static final class State<T>
    extends AtomicReference<Object>
    implements Publisher<T>,
    IntFunction<PublishSubscriber<T>[]> {
        private static final long serialVersionUID = -2699311989055418316L;
        static final Object COMPLETE = new Object();
        static final PublishSubscriber[] TERMINATED = new PublishSubscriber[0];
        static final PublishSubscriber[] EMPTY = new PublishSubscriber[0];
        final AtomicReference<PublishSubscriber<T>[]> subscribers = new AtomicReference<PublishSubscriber[]>(EMPTY);

        State() {
        }

        public void subscribe(Subscriber<? super T> t) {
            PublishSubscriber<T> ps = new PublishSubscriber<T>(t, this);
            t.onSubscribe(ps);
            if (!ps.cancelled.get()) {
                if (this.add(ps)) {
                    if (ps.cancelled.get()) {
                        this.remove(ps);
                    }
                } else {
                    Object o = this.get();
                    if (o == COMPLETE) {
                        ps.onComplete();
                    } else {
                        ps.onError((Throwable)o);
                    }
                }
            }
        }

        PublishSubscriber<T>[] subscribers() {
            return this.subscribers.get();
        }

        PublishSubscriber<T>[] terminate() {
            return this.terminate(COMPLETE);
        }

        PublishSubscriber<T>[] terminate(Object event) {
            if (this.compareAndSet(null, event)) {
                PublishSubscriber<T>[] a = this.subscribers.get();
                if (a != TERMINATED) {
                    a = this.subscribers.getAndSet(TERMINATED);
                }
                return a;
            }
            return TERMINATED;
        }

        boolean add(PublishSubscriber<T> ps) {
            PublishSubscriber<T>[] b;
            PublishSubscriber<T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = this.apply(n + 1);
                System.arraycopy(a, 0, b, 0, n);
                b[n] = ps;
            } while (!this.subscribers.compareAndSet(a, b));
            return true;
        }

        void remove(PublishSubscriber<T> ps) {
            PublishSubscriber[] b;
            PublishSubscriber<T>[] a;
            do {
                if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                    return;
                }
                int n = a.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != ps) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = this.apply(n - 1);
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.subscribers.compareAndSet(a, b));
        }

        @Override
        public PublishSubscriber<T>[] apply(int value) {
            return new PublishSubscriber[value];
        }
    }
}

