/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.util;

import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;

public enum BackpressureHelper {


    public static long addCap(long a, long b) {
        long u = a + b;
        if (u < 0L) {
            return Long.MAX_VALUE;
        }
        return u;
    }

    public static long multiplyCap(long a, long b) {
        long u = a * b;
        if ((a | b) >>> 31 != 0L && u / a != b) {
            return Long.MAX_VALUE;
        }
        return u;
    }

    public static long add(AtomicLong requested, long n) {
        long u;
        long r;
        do {
            if ((r = requested.get()) != Long.MAX_VALUE) continue;
            return Long.MAX_VALUE;
        } while (!requested.compareAndSet(r, u = BackpressureHelper.addCap(r, n)));
        return r;
    }

    public static long produced(AtomicLong requested, long n) {
        long update;
        long current;
        do {
            if ((current = requested.get()) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            update = current - n;
            if (update >= 0L) continue;
            RxJavaPlugins.onError(new IllegalStateException("More produced than requested: " + update));
            update = 0L;
        } while (!requested.compareAndSet(current, update));
        return update;
    }
}

