/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscriptions;

import io.reactivex.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;

public class DeferredScalarSubscription<T>
extends BasicQueueSubscription<T> {
    private static final long serialVersionUID = -2151279923272604993L;
    protected final Subscriber<? super T> actual;
    protected T value;
    protected int fusionState;
    static final long NO_REQUEST_NO_VALUE = 0L;
    static final long NO_REQUEST_HAS_VALUE = 1L;
    static final long HAS_REQUEST_NO_VALUE = 2L;
    static final long HAS_REQUEST_HAS_VALUE = 3L;
    static final long CANCELLED = 4L;
    static final int NOT_FUSED = 0;
    static final int EMPTY = 1;
    static final int HAS_VALUE = 2;
    static final int CONSUMED = 3;

    public DeferredScalarSubscription(Subscriber<? super T> actual) {
        this.actual = actual;
    }

    public void request(long n) {
        if (SubscriptionHelper.validate(n)) {
            do {
                long state;
                if ((state = this.get()) == 2L || state == 3L || state == 4L) {
                    return;
                }
                if (state != 1L) continue;
                if (this.compareAndSet(1L, 3L)) {
                    if (this.fusionState == 1) {
                        this.fusionState = 2;
                    }
                    this.actual.onNext(this.value);
                    if (this.get() != 4L) {
                        this.actual.onComplete();
                    }
                }
                return;
            } while (!this.compareAndSet(0L, 2L));
            return;
        }
    }

    public final void complete(T v) {
        do {
            long state;
            if ((state = this.get()) == 1L || state == 3L || state == 4L) {
                return;
            }
            if (state == 2L) {
                if (this.fusionState == 1) {
                    this.value = v;
                    this.fusionState = 2;
                }
                this.actual.onNext(v);
                if (this.get() != 4L) {
                    this.actual.onComplete();
                }
                this.lazySet(3L);
                return;
            }
            this.value = v;
        } while (!this.compareAndSet(0L, 1L));
    }

    @Override
    public final int requestFusion(int mode) {
        if ((mode & 2) != 0) {
            this.fusionState = 1;
            return 2;
        }
        return 0;
    }

    @Override
    public final T poll() {
        if (this.fusionState == 2) {
            this.fusionState = 3;
            return this.value;
        }
        return null;
    }

    @Override
    public final boolean isEmpty() {
        return this.fusionState != 2;
    }

    @Override
    public final void clear() {
        this.fusionState = 3;
    }

    public void cancel() {
        this.set(4L);
    }

    public final boolean isCancelled() {
        return this.get() == 4L;
    }
}

