/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.subscribers.observable;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;

public final class SubscriptionLambdaObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    final Consumer<? super Disposable> onSubscribe;
    final Action onCancel;
    Disposable s;

    public SubscriptionLambdaObserver(Observer<? super T> actual, Consumer<? super Disposable> onSubscribe, Action onCancel) {
        this.actual = actual;
        this.onSubscribe = onSubscribe;
        this.onCancel = onCancel;
    }

    @Override
    public void onSubscribe(Disposable s) {
        try {
            this.onSubscribe.accept(s);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            s.dispose();
            RxJavaPlugins.onError(e);
            EmptyDisposable.error(e, this.actual);
            return;
        }
        if (DisposableHelper.validate(this.s, s)) {
            this.s = s;
            this.actual.onSubscribe(this);
        }
    }

    @Override
    public void onNext(T t) {
        this.actual.onNext(t);
    }

    @Override
    public void onError(Throwable t) {
        this.actual.onError(t);
    }

    @Override
    public void onComplete() {
        this.actual.onComplete();
    }

    @Override
    public void dispose() {
        try {
            this.onCancel.run();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }
}

