/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOperator;
import io.reactivex.SingleSource;
import io.reactivex.plugins.RxJavaPlugins;

public final class SingleLift<T, R>
extends Single<R> {
    final SingleSource<T> source;
    final SingleOperator<? extends R, ? super T> onLift;

    public SingleLift(SingleSource<T> source, SingleOperator<? extends R, ? super T> onLift) {
        this.source = source;
        this.onLift = onLift;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> s) {
        try {
            SingleObserver sr = (SingleObserver)this.onLift.apply(s);
            if (sr == null) {
                throw new NullPointerException("The onLift returned a null subscriber");
            }
            this.source.subscribe(sr);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            RxJavaPlugins.onError(ex);
            NullPointerException npe = new NullPointerException("Not really but can't throw other than NPE");
            npe.initCause(ex);
            throw npe;
        }
    }
}

