/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.plugins.RxJavaPlugins;

public final class SingleDoOnCancel<T>
extends Single<T> {
    final SingleSource<T> source;
    final Action onCancel;

    public SingleDoOnCancel(SingleSource<T> source, Action onCancel) {
        this.source = source;
        this.onCancel = onCancel;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        this.source.subscribe(new DoOnCancelObserver<T>(s, this.onCancel));
    }

    static final class DoOnCancelObserver<T>
    implements SingleObserver<T>,
    Disposable {
        final SingleObserver<? super T> actual;
        final Action onCancel;
        Disposable d;

        public DoOnCancelObserver(SingleObserver<? super T> actual, Action onCancel) {
            this.actual = actual;
            this.onCancel = onCancel;
        }

        @Override
        public void dispose() {
            try {
                this.onCancel.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
            this.d.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            this.actual.onError(e);
        }
    }
}

