/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.util.NotificationLite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleCache<T>
extends Single<T> {
    final SingleSource<? extends T> source;
    final AtomicInteger wip;
    final AtomicReference<Object> notification;
    final List<SingleObserver<? super T>> subscribers;

    public SingleCache(SingleSource<? extends T> source) {
        this.source = source;
        this.wip = new AtomicInteger();
        this.notification = new AtomicReference();
        this.subscribers = new ArrayList<SingleObserver<? super T>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        Object o = this.notification.get();
        if (o != null) {
            s.onSubscribe(EmptyDisposable.INSTANCE);
            if (NotificationLite.isError(o)) {
                s.onError(NotificationLite.getError(o));
            } else {
                s.onSuccess(NotificationLite.getValue(o));
            }
            return;
        }
        List<SingleObserver<? super T>> list = this.subscribers;
        synchronized (list) {
            o = this.notification.get();
            if (o == null) {
                this.subscribers.add(s);
            }
        }
        if (o != null) {
            s.onSubscribe(EmptyDisposable.INSTANCE);
            if (NotificationLite.isError(o)) {
                s.onError(NotificationLite.getError(o));
            } else {
                s.onSuccess(NotificationLite.getValue(o));
            }
            return;
        }
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        this.source.subscribe(new SingleObserver<T>(){

            @Override
            public void onSubscribe(Disposable d) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(T value) {
                ArrayList list;
                SingleCache.this.notification.set(NotificationLite.next(value));
                List list2 = SingleCache.this.subscribers;
                synchronized (list2) {
                    list = new ArrayList(SingleCache.this.subscribers);
                    SingleCache.this.subscribers.clear();
                }
                for (SingleObserver singleObserver : list) {
                    singleObserver.onSuccess(value);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(Throwable e) {
                ArrayList list;
                SingleCache.this.notification.set(NotificationLite.error(e));
                List list2 = SingleCache.this.subscribers;
                synchronized (list2) {
                    list = new ArrayList(SingleCache.this.subscribers);
                    SingleCache.this.subscribers.clear();
                }
                for (SingleObserver singleObserver : list) {
                    singleObserver.onError(e);
                }
            }
        });
    }
}

