/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleAmbIterable<T>
extends Single<T> {
    final Iterable<? extends SingleSource<? extends T>> sources;

    public SingleAmbIterable(Iterable<? extends SingleSource<? extends T>> sources) {
        this.sources = sources;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        Iterator<SingleSource<T>> iterator;
        final CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        try {
            iterator = this.sources.iterator();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            s.onError(e);
            return;
        }
        if (iterator == null) {
            s.onError(new NullPointerException("The iterator returned is null"));
            return;
        }
        final AtomicBoolean once = new AtomicBoolean();
        int c = 0;
        while (true) {
            SingleSource<T> s1;
            boolean b;
            if (once.get()) {
                return;
            }
            try {
                b = iterator.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                s.onError(e);
                return;
            }
            if (once.get()) {
                return;
            }
            if (!b) break;
            if (once.get()) {
                return;
            }
            try {
                s1 = iterator.next();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                set.dispose();
                s.onError(e);
                return;
            }
            if (s1 == null) {
                set.dispose();
                s.onError(new NullPointerException("The single source returned by the iterator is null"));
                return;
            }
            s1.subscribe(new SingleObserver<T>(){

                @Override
                public void onSubscribe(Disposable d) {
                    set.add(d);
                }

                @Override
                public void onSuccess(T value) {
                    if (once.compareAndSet(false, true)) {
                        s.onSuccess(value);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    if (once.compareAndSet(false, true)) {
                        s.onError(e);
                    } else {
                        RxJavaPlugins.onError(e);
                    }
                }
            });
            ++c;
        }
        if (c == 0 && !set.isDisposed()) {
            s.onError(new NoSuchElementException());
        }
    }
}

