/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleAmbArray<T>
extends Single<T> {
    final SingleSource<? extends T>[] sources;

    public SingleAmbArray(SingleSource<? extends T>[] sources) {
        this.sources = sources;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        final AtomicBoolean once = new AtomicBoolean();
        final CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        for (SingleSource<T> singleSource : this.sources) {
            if (once.get()) {
                return;
            }
            if (singleSource == null) {
                set.dispose();
                NullPointerException e = new NullPointerException("One of the sources is null");
                if (once.compareAndSet(false, true)) {
                    s.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
                return;
            }
            singleSource.subscribe(new SingleObserver<T>(){

                @Override
                public void onSubscribe(Disposable d) {
                    set.add(d);
                }

                @Override
                public void onSuccess(T value) {
                    if (once.compareAndSet(false, true)) {
                        s.onSuccess(value);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    if (once.compareAndSet(false, true)) {
                        s.onError(e);
                    } else {
                        RxJavaPlugins.onError(e);
                    }
                }
            });
        }
    }
}

