/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ObservableFromPublisher<T>
extends Observable<T> {
    private final Publisher<? extends T> publisher;

    public ObservableFromPublisher(Publisher<? extends T> publisher) {
        this.publisher = publisher;
    }

    @Override
    protected void subscribeActual(Observer<? super T> o) {
        this.publisher.subscribe(new PublisherSubscriber<T>(o));
    }

    static final class PublisherSubscriber<T>
    extends AtomicBoolean
    implements Subscriber<T>,
    Disposable {
        private static final long serialVersionUID = -7306579371159152354L;
        private final Observer<? super T> o;
        private Subscription inner;

        PublisherSubscriber(Observer<? super T> o) {
            this.o = o;
        }

        public void onComplete() {
            this.o.onComplete();
        }

        public void onError(Throwable t) {
            this.o.onError(t);
        }

        public void onNext(T t) {
            this.o.onNext(t);
        }

        public void onSubscribe(Subscription inner) {
            this.inner = inner;
            this.o.onSubscribe(this);
            inner.request(Long.MAX_VALUE);
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.inner.cancel();
                this.inner = null;
            }
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }
    }
}

