/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.observable.QueueDrainObserver;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableBufferBoundary<T, U extends Collection<? super T>, Open, Close>
extends AbstractObservableWithUpstream<T, U> {
    final Callable<U> bufferSupplier;
    final ObservableSource<? extends Open> bufferOpen;
    final Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose;

    public ObservableBufferBoundary(ObservableSource<T> source, ObservableSource<? extends Open> bufferOpen, Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose, Callable<U> bufferSupplier) {
        super(source);
        this.bufferOpen = bufferOpen;
        this.bufferClose = bufferClose;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Observer<? super U> t) {
        this.source.subscribe(new BufferBoundarySubscriber(new SerializedObserver<U>(t), this.bufferOpen, this.bufferClose, this.bufferSupplier));
    }

    static final class BufferCloseSubscriber<T, U extends Collection<? super T>, Open, Close>
    extends DisposableObserver<Close> {
        final BufferBoundarySubscriber<T, U, Open, Close> parent;
        final U value;
        boolean done;

        public BufferCloseSubscriber(U value, BufferBoundarySubscriber<T, U, Open, Close> parent) {
            this.parent = parent;
            this.value = value;
        }

        @Override
        public void onNext(Close t) {
            this.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.close(this.value, this);
        }
    }

    static final class BufferOpenSubscriber<T, U extends Collection<? super T>, Open, Close>
    extends DisposableObserver<Open> {
        final BufferBoundarySubscriber<T, U, Open, Close> parent;
        boolean done;

        public BufferOpenSubscriber(BufferBoundarySubscriber<T, U, Open, Close> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(Open t) {
            if (this.done) {
                return;
            }
            this.parent.open(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.openFinished(this);
        }
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, Open, Close>
    extends QueueDrainObserver<T, U, U>
    implements Disposable {
        final ObservableSource<? extends Open> bufferOpen;
        final Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose;
        final Callable<U> bufferSupplier;
        final CompositeDisposable resources;
        Disposable s;
        final List<U> buffers;
        final AtomicInteger windows = new AtomicInteger();

        public BufferBoundarySubscriber(Observer<? super U> actual, ObservableSource<? extends Open> bufferOpen, Function<? super Open, ? extends ObservableSource<? extends Close>> bufferClose, Callable<U> bufferSupplier) {
            super(actual, new MpscLinkedQueue());
            this.bufferOpen = bufferOpen;
            this.bufferClose = bufferClose;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new LinkedList<U>();
            this.resources = new CompositeDisposable();
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                BufferOpenSubscriber bos = new BufferOpenSubscriber(this);
                this.resources.add(bos);
                this.actual.onSubscribe(this);
                this.windows.lazySet(1);
                this.bufferOpen.subscribe(bos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                for (Collection b : this.buffers) {
                    b.add(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            this.dispose();
            this.cancelled = true;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                this.buffers.clear();
            }
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.windows.decrementAndGet() == 0) {
                this.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void complete() {
            ArrayList<U> list;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                list = new ArrayList<U>(this.buffers);
                this.buffers.clear();
            }
            SimpleQueue q = this.queue;
            for (Collection u : list) {
                q.offer(u);
            }
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainLoop(q, this.actual, false, this, this);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.resources.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void accept(Observer<? super U> a, U v) {
            a.onNext(v);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(Open window) {
            ObservableSource<Close> p;
            Collection b;
            if (this.cancelled) {
                return;
            }
            try {
                b = (Collection)this.bufferSupplier.call();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.onError(e);
                return;
            }
            if (b == null) {
                this.onError(new NullPointerException("The buffer supplied is null"));
                return;
            }
            try {
                p = this.bufferClose.apply(window);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.onError(e);
                return;
            }
            if (p == null) {
                this.onError(new NullPointerException("The buffer closing Observable is null"));
                return;
            }
            if (this.cancelled) {
                return;
            }
            BufferBoundarySubscriber e = this;
            synchronized (e) {
                if (this.cancelled) {
                    return;
                }
                this.buffers.add(b);
            }
            BufferCloseSubscriber bcs = new BufferCloseSubscriber(b, this);
            this.resources.add(bcs);
            this.windows.getAndIncrement();
            p.subscribe(bcs);
        }

        void openFinished(Disposable d) {
            if (this.resources.remove(d) && this.windows.decrementAndGet() == 0) {
                this.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(U b, Disposable d) {
            boolean e;
            BufferBoundarySubscriber bufferBoundarySubscriber = this;
            synchronized (bufferBoundarySubscriber) {
                e = this.buffers.remove(b);
            }
            if (e) {
                this.fastPathOrderedEmit(b, false, this);
            }
            if (this.resources.remove(d) && this.windows.decrementAndGet() == 0) {
                this.complete();
            }
        }
    }
}

