/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSubscribeOn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Scheduler scheduler;

    public FlowableSubscribeOn(Publisher<T> source, Scheduler scheduler) {
        super(source);
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Scheduler.Worker w = this.scheduler.createWorker();
        final SubscribeOnSubscriber<? super T> sos = new SubscribeOnSubscriber<T>(s, w);
        s.onSubscribe(sos);
        w.schedule(new Runnable(){

            @Override
            public void run() {
                sos.lazySet(Thread.currentThread());
                FlowableSubscribeOn.this.source.subscribe((Subscriber)sos);
            }
        });
    }

    static final class SubscribeOnSubscriber<T>
    extends AtomicReference<Thread>
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 8094547886072529208L;
        final Subscriber<? super T> actual;
        final Scheduler.Worker worker;
        final AtomicReference<Subscription> s;
        final AtomicLong requested;

        public SubscribeOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker) {
            this.actual = actual;
            this.worker = worker;
            this.s = new AtomicReference();
            this.requested = new AtomicLong();
        }

        public void onSubscribe(Subscription s) {
            long r;
            if (SubscriptionHelper.setOnce(this.s, s) && (r = this.requested.getAndSet(0L)) != 0L) {
                this.requestUpstream(r, s);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            try {
                this.actual.onError(t);
            }
            finally {
                this.worker.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            try {
                this.actual.onComplete();
            }
            finally {
                this.worker.dispose();
            }
        }

        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            Subscription s = this.s.get();
            if (s != null) {
                this.requestUpstream(n, s);
            } else {
                long r;
                BackpressureHelper.add(this.requested, n);
                s = this.s.get();
                if (s != null && (r = this.requested.getAndSet(0L)) != 0L) {
                    this.requestUpstream(r, s);
                }
            }
        }

        void requestUpstream(final long n, final Subscription s) {
            if (Thread.currentThread() == this.get()) {
                s.request(n);
            } else {
                this.worker.schedule(new Runnable(){

                    @Override
                    public void run() {
                        s.request(n);
                    }
                });
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.s);
            this.worker.dispose();
        }
    }
}

