/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.ArrayCompositeSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSequenceEqual<T>
extends Flowable<Boolean> {
    final Publisher<? extends T> first;
    final Publisher<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int bufferSize;

    public FlowableSequenceEqual(Publisher<? extends T> first, Publisher<? extends T> second, BiPredicate<? super T, ? super T> comparer, int bufferSize) {
        this.first = first;
        this.second = second;
        this.comparer = comparer;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Subscriber<? super Boolean> s) {
        EqualCoordinator<T> ec = new EqualCoordinator<T>(s, this.bufferSize, this.first, this.second, this.comparer);
        ec.subscribe();
    }

    static final class EqualSubscriber<T>
    implements Subscriber<T> {
        final EqualCoordinator<T> parent;
        final SpscArrayQueue<T> queue;
        final int index;
        final int bufferSize;
        volatile boolean done;
        Throwable error;
        Subscription s;

        public EqualSubscriber(EqualCoordinator<T> parent, int index, int bufferSize) {
            this.parent = parent;
            this.bufferSize = bufferSize;
            this.index = index;
            this.queue = new SpscArrayQueue(bufferSize);
        }

        public void onSubscribe(Subscription s) {
            if (this.parent.setSubscription(s, this.index)) {
                this.s = s;
                s.request((long)this.bufferSize);
            }
        }

        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                this.onError(new IllegalStateException("Queue full?!"));
                return;
            }
            this.parent.drain();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.parent.drain();
        }

        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }
    }

    static final class EqualCoordinator<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = -6178010334400373240L;
        final Subscriber<? super Boolean> actual;
        final BiPredicate<? super T, ? super T> comparer;
        final ArrayCompositeSubscription resources;
        final Publisher<? extends T> first;
        final Publisher<? extends T> second;
        final EqualSubscriber<T>[] subscribers;
        volatile boolean cancelled;
        final AtomicBoolean once = new AtomicBoolean();
        T v1;
        T v2;

        public EqualCoordinator(Subscriber<? super Boolean> actual, int bufferSize, Publisher<? extends T> first, Publisher<? extends T> second, BiPredicate<? super T, ? super T> comparer) {
            this.actual = actual;
            this.first = first;
            this.second = second;
            this.comparer = comparer;
            EqualSubscriber[] as = new EqualSubscriber[2];
            this.subscribers = as;
            as[0] = new EqualSubscriber(this, 0, bufferSize);
            as[1] = new EqualSubscriber(this, 1, bufferSize);
            this.resources = new ArrayCompositeSubscription(2);
        }

        boolean setSubscription(Subscription s, int index) {
            return this.resources.setResource(index, s);
        }

        void subscribe() {
            EqualSubscriber<T>[] as = this.subscribers;
            this.first.subscribe(as[0]);
            this.second.subscribe(as[1]);
        }

        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            if (this.once.compareAndSet(false, true)) {
                EqualSubscriber<T>[] as = this.subscribers;
                this.first.subscribe(as[0]);
                this.second.subscribe(as[1]);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.resources.dispose();
                if (this.getAndIncrement() == 0) {
                    EqualSubscriber<T>[] as = this.subscribers;
                    as[0].queue.clear();
                    as[1].queue.clear();
                }
            }
        }

        void cancel(SpscArrayQueue<T> q1, SpscArrayQueue<T> q2) {
            this.cancelled = true;
            q1.clear();
            q2.clear();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            EqualSubscriber<T>[] as = this.subscribers;
            EqualSubscriber<T> s1 = as[0];
            SpscArrayQueue q1 = s1.queue;
            EqualSubscriber<T> s2 = as[1];
            SpscArrayQueue q2 = s2.queue;
            do {
                boolean e2;
                boolean e1;
                long r = 0L;
                do {
                    boolean c;
                    Throwable e;
                    Throwable e3;
                    if (this.cancelled) {
                        q1.clear();
                        q2.clear();
                        return;
                    }
                    boolean d1 = s1.done;
                    if (d1 && (e3 = s1.error) != null) {
                        this.cancel(q1, q2);
                        this.actual.onError(e3);
                        return;
                    }
                    boolean d2 = s2.done;
                    if (d2 && (e = s2.error) != null) {
                        this.cancel(q1, q2);
                        this.actual.onError(e);
                        return;
                    }
                    if (this.v1 == null) {
                        this.v1 = q1.poll();
                    }
                    boolean bl = e1 = this.v1 == null;
                    if (this.v2 == null) {
                        this.v2 = q2.poll();
                    }
                    boolean bl2 = e2 = this.v2 == null;
                    if (d1 && d2 && e1 && e2) {
                        this.actual.onNext((Object)true);
                        this.actual.onComplete();
                        return;
                    }
                    if (d1 && d2 && e1 != e2) {
                        this.cancel(q1, q2);
                        this.actual.onNext((Object)false);
                        this.actual.onComplete();
                        return;
                    }
                    if (e1 || e2) continue;
                    try {
                        c = this.comparer.test(this.v1, this.v2);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancel(q1, q2);
                        this.actual.onError(ex);
                        return;
                    }
                    if (!c) {
                        this.cancel(q1, q2);
                        this.actual.onNext((Object)false);
                        this.actual.onComplete();
                        return;
                    }
                    ++r;
                    this.v1 = null;
                    this.v2 = null;
                } while (!e1 && !e2);
                if (r == 0L) continue;
                s1.s.request(r);
                s2.s.request(r);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

