/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Action;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableOnBackpressureBuffer<T>
extends AbstractFlowableWithUpstream<T, T> {
    final int bufferSize;
    final boolean unbounded;
    final boolean delayError;
    final Action onOverflow;

    public FlowableOnBackpressureBuffer(Publisher<T> source, int bufferSize, boolean unbounded, boolean delayError, Action onOverflow) {
        super(source);
        this.bufferSize = bufferSize;
        this.unbounded = unbounded;
        this.delayError = delayError;
        this.onOverflow = onOverflow;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new BackpressureBufferSubscriber<T>(s, this.bufferSize, this.unbounded, this.delayError, this.onOverflow));
    }

    static final class BackpressureBufferSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -2514538129242366402L;
        final Subscriber<? super T> actual;
        final SimpleQueue<T> queue;
        final boolean delayError;
        final Action onOverflow;
        Subscription s;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();

        public BackpressureBufferSubscriber(Subscriber<? super T> actual, int bufferSize, boolean unbounded, boolean delayError, Action onOverflow) {
            this.actual = actual;
            this.onOverflow = onOverflow;
            this.delayError = delayError;
            SimpleQueue<Object> q = unbounded ? new SpscLinkedArrayQueue(bufferSize) : new SpscArrayQueue(bufferSize);
            this.queue = q;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                this.s.cancel();
                MissingBackpressureException ex = new MissingBackpressureException("Buffer is full");
                try {
                    this.onOverflow.run();
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    ex.initCause(e);
                }
                this.onError(ex);
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                    this.s.cancel();
                }
            }
        }

        void drain() {
            block6: {
                if (this.getAndIncrement() != 0) break block6;
                int missed = 1;
                SimpleQueue<T> q = this.queue;
                Subscriber<? super T> a = this.actual;
                do {
                    long e;
                    if (this.checkTerminated(this.done, q.isEmpty(), a)) {
                        return;
                    }
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        T v;
                        boolean d = this.done;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.s.cancel();
                            a.onError(ex);
                            return;
                        }
                        boolean bl = empty = v == null;
                        if (this.checkTerminated(d, empty, a)) {
                            return;
                        }
                        if (empty) break;
                        a.onNext(v);
                    }
                    if (e == 0L || r == Long.MAX_VALUE) continue;
                    this.requested.addAndGet(-e);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a) {
            if (this.cancelled) {
                this.s.cancel();
                this.queue.clear();
                return true;
            }
            if (d) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

