/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableMergeIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(final CompletableObserver s) {
        Iterator<? extends CompletableSource> iterator;
        final CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        try {
            iterator = this.sources.iterator();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            s.onError(e);
            return;
        }
        if (iterator == null) {
            s.onError(new NullPointerException("The source iterator returned is null"));
            return;
        }
        final AtomicInteger wip = new AtomicInteger(1);
        final AtomicBoolean once = new AtomicBoolean();
        while (true) {
            CompletableSource c;
            boolean b;
            if (set.isDisposed()) {
                return;
            }
            try {
                b = iterator.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                set.dispose();
                if (once.compareAndSet(false, true)) {
                    s.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
                return;
            }
            if (!b) break;
            if (set.isDisposed()) {
                return;
            }
            try {
                c = iterator.next();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                set.dispose();
                if (once.compareAndSet(false, true)) {
                    s.onError(e);
                } else {
                    RxJavaPlugins.onError(e);
                }
                return;
            }
            if (set.isDisposed()) {
                return;
            }
            if (c == null) {
                set.dispose();
                NullPointerException npe = new NullPointerException("A completable source is null");
                if (once.compareAndSet(false, true)) {
                    s.onError(npe);
                } else {
                    RxJavaPlugins.onError(npe);
                }
                return;
            }
            wip.getAndIncrement();
            c.subscribe(new CompletableObserver(){

                @Override
                public void onSubscribe(Disposable d) {
                    set.add(d);
                }

                @Override
                public void onError(Throwable e) {
                    set.dispose();
                    if (once.compareAndSet(false, true)) {
                        s.onError(e);
                    } else {
                        RxJavaPlugins.onError(e);
                    }
                }

                @Override
                public void onComplete() {
                    if (wip.decrementAndGet() == 0 && once.compareAndSet(false, true)) {
                        s.onComplete();
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0 && once.compareAndSet(false, true)) {
            s.onComplete();
        }
    }
}

